/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.strategy.dataset;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.dataset.dto.DataSetConfigInfoDto;
import com.jxdinfo.hussar.dataset.dto.DataSetInfoDto;
import com.jxdinfo.hussar.dataset.dto.SqlDataSetDto;
import com.jxdinfo.hussar.dataset.enums.DataSetErrorCodeEnum;
import com.jxdinfo.hussar.dataset.enums.DataSetTypeEnum;
import com.jxdinfo.hussar.dataset.factory.DbDataTypeStrategyFactory;
import com.jxdinfo.hussar.dataset.model.SqlConfigSchema1;
import com.jxdinfo.hussar.dataset.model.SqlField1;
import com.jxdinfo.hussar.dataset.service.IDataSetProcessor;
import com.jxdinfo.hussar.dataset.service.IDataTypeStrategy;
import com.jxdinfo.hussar.dataset.strategy.dataset.DataSetCommonProcessor;
import com.jxdinfo.hussar.dataset.vo.SqlDataSetVo;
import com.jxdinfo.hussar.datasource.exception.DataSourceException;
import com.jxdinfo.hussar.datasource.model.DsTableField;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.datasource.service.DatasourceDataService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelSaveDto;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DbDataSetProcessor
extends DataSetCommonProcessor
implements IDataSetProcessor {
    public Object save(DataSetInfoDto dataSetInfoDto) {
        DataSetConfigInfoDto dataSetConfigInfoDto = (DataSetConfigInfoDto)JSONObject.parseObject((String)dataSetInfoDto.getData(), DataSetConfigInfoDto.class);
        List tables = dataSetConfigInfoDto.getTables();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)tables), (Integer)DataSetErrorCodeEnum.DATASET_DB_TABLE_ISNULL.getCode(), (String)String.format("\u6570\u636e\u96c6\u3010%s\u3011\u8868\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", dataSetInfoDto.getDataSetName()));
        ThreadPoolTaskExecutor hussarAsyncPoolTaskExecutor = (ThreadPoolTaskExecutor)SpringContextHolder.getBean((String)"hussarAsyncPoolTaskExecutor");
        try {
            List<CompletableFuture> dataSets = tables.stream().map(table -> CompletableFuture.supplyAsync(() -> this.processDbDataSet((DsTableInfo)table, dataSetInfoDto), (Executor)hussarAsyncPoolTaskExecutor)).collect(Collectors.toList());
            CompletionStage allDatasets = CompletableFuture.allOf(dataSets.toArray(new CompletableFuture[0])).thenApply(v -> dataSets.stream().map(CompletableFuture::join).collect(Collectors.toList()));
            if (HussarUtils.isNotEmpty(((CompletableFuture)allDatasets).get())) {
                return ((CompletableFuture)allDatasets).get();
            }
            return null;
        }
        catch (Exception e) {
            throw new HussarException(String.format("db\u6570\u636e\u96c6\u5165\u5e93\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a\u3010%s\u3011", HussarUtils.isNotEmpty((Object)e.getCause()) ? e.getCause().getMessage() : e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void editModel(DataSetInfoDto DataSetInfoDto2) {
        super.editModel(DataSetInfoDto2);
    }

    public void delete(DataSetInfoDto dataSetInfoDto) {
        super.deleteModel(dataSetInfoDto.getDataSetId().toString());
    }

    @Override
    public SqlDataSetVo preivewDataBySql(SqlDataSetDto sqlDataSetDto) {
        Object object = super.processSql(sqlDataSetDto);
        return super.processSqlData(object, sqlDataSetDto.isPagination(), sqlDataSetDto.getDataSourceName());
    }

    private Long processDbDataSet(DsTableInfo tableInfo, DataSetInfoDto DataSetInfoDto2) {
        DataSetInfoDto newDataSetInfoDto = super.copyNewDataSetInfoDto(DataSetInfoDto2);
        newDataSetInfoDto.setDataSetCode(tableInfo.getName());
        newDataSetInfoDto.setDataSetName(HussarUtils.isEmpty((Object)tableInfo.getComment()) ? tableInfo.getName() : tableInfo.getComment());
        newDataSetInfoDto.setDataSetType(DataSetTypeEnum.DB.getCode());
        newDataSetInfoDto.setDataSetDesc(newDataSetInfoDto.getDataSetName());
        DataSetConfigInfoDto dataSetConfigInfoDto = this.packageDataSetConfigInfo(tableInfo, newDataSetInfoDto);
        newDataSetInfoDto.setData(JsonUtil.toJson((Object)dataSetConfigInfoDto));
        ModelSaveDto modelSaveDto = super.getModelSaveDto(newDataSetInfoDto);
        this.insertModelToDb(modelSaveDto);
        this.insertDbSetToDb(newDataSetInfoDto);
        return newDataSetInfoDto.getDataSetId();
    }

    private DataSetConfigInfoDto packageDataSetConfigInfo(DsTableInfo tableInfo, DataSetInfoDto DataSetInfoDto2) {
        DataSetConfigInfoDto dataSetConfigInfoDto = super.getDataSetConfigInfoDto(DataSetInfoDto2);
        ArrayList<DsTableInfo> tables = new ArrayList<DsTableInfo>();
        tables.add(tableInfo);
        dataSetConfigInfoDto.setTables(tables);
        SqlConfigSchema1 dataSetParam = this.packageDataSetParam(tableInfo, DataSetInfoDto2.getDataSourceId(), DataSetInfoDto2.getDataSourceName());
        dataSetConfigInfoDto.setDataSetParam(dataSetParam);
        return dataSetConfigInfoDto;
    }

    private SqlConfigSchema1 packageDataSetParam(DsTableInfo tableInfo, Long dataSourceId, String dataSourceName) {
        SqlConfigSchema1 dataSetParam = new SqlConfigSchema1();
        String sql = String.format("select * from %s", tableInfo.getName());
        dataSetParam.setSql(sql);
        dataSetParam.setProjection(this.getProjection(dataSourceId, tableInfo.getName(), dataSourceName));
        return dataSetParam;
    }

    private List<SqlField1> getProjection(Long datasourceId, String tableName, String dataSourceName) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)tableName), (Integer)DataSetErrorCodeEnum.DATASET_TABLENAME_ISNULL.getCode(), (String)DataSetErrorCodeEnum.DATASET_TABLENAME_ISNULL.getMessage());
        List<DsTableField> fields = this.getFields(datasourceId, tableName);
        HussarException.throwBy((boolean)HussarUtils.isEmpty(fields), (Integer)DataSetErrorCodeEnum.DATASET_FIELD_NOT_EXISTS.getCode(), (String)String.format("\u8868\u3010%s\u3011\u4e2d\u5b57\u6bb5\u4fe1\u606f\u4e0d\u5b58\u5728!", tableName));
        try {
            return fields.stream().map(field -> {
                SqlField1 sqlField = (SqlField1)HussarUtils.copyProperties((Object)field, SqlField1.class);
                sqlField.setField(field.getName());
                sqlField.setTable(field.getTableName());
                sqlField.setComment(field.getComment());
                sqlField.setFieldAlias(field.getName());
                String jdbcType = field.getType().toUpperCase();
                sqlField.setType(jdbcType);
                IDataTypeStrategy IDataTypeStrategy2 = DbDataTypeStrategyFactory.getStrategy(dataSourceName);
                sqlField.setDataType(IDataTypeStrategy2.convertJdbcToFrontType(jdbcType).toLowerCase());
                sqlField.setDataTypeConversion(IDataTypeStrategy2.convertJdbcToFrontType(jdbcType).toLowerCase());
                sqlField.setRename(HussarUtils.isNotEmpty((Object)field.getComment()) ? field.getComment() : field.getName());
                return sqlField;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_FIELD_TOSHOW_EXCEPTION.getCode()), String.format("DB\u6570\u636e\u96c6\u6570\u636e\u8868\u3010%s\u3011\u5b57\u6bb5\u8f6c\u6362\u5f02\u5e38\uff01", tableName), (Throwable)e);
        }
    }

    private List<DsTableField> getFields(Long datasourceId, String tableName) {
        try {
            DatasourceDataService datasourceDataService = (DatasourceDataService)SpringContextHolder.getBean(DatasourceDataService.class);
            List fields = datasourceDataService.getTableFieldByTableName(datasourceId, tableName.toUpperCase());
            return fields;
        }
        catch (DataSourceException e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_DATASOURCE_NOT_EXISTS.getCode()), DataSetErrorCodeEnum.DATASET_DATASOURCE_NOT_EXISTS.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_IO_EXCEPTION.getCode()), DataSetErrorCodeEnum.DATASET_IO_EXCEPTION.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_FIELD_EXCEPTION.getCode()), DataSetErrorCodeEnum.DATASET_FIELD_EXCEPTION.getMessage(), (Throwable)e);
        }
    }
}

