/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.factory;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.dataset.service.IDataTypeStrategy;
import com.jxdinfo.hussar.dataset.strategy.db.DmDataTypeStrategy;
import com.jxdinfo.hussar.dataset.strategy.db.HighGoDataTypeStrategy;
import com.jxdinfo.hussar.dataset.strategy.db.KingbaseEsDataTypeStrategy;
import com.jxdinfo.hussar.dataset.strategy.db.MysqlDataTypeStrategy;
import com.jxdinfo.hussar.dataset.strategy.db.OracleDataTypeStrategy;
import com.jxdinfo.hussar.dataset.strategy.db.OscarDataTypeStrategy;
import com.jxdinfo.hussar.dataset.strategy.db.PgDataTypeStrategy;
import com.jxdinfo.hussar.dataset.strategy.db.SqlServerDataTypeStrategy;
import com.jxdinfo.hussar.dataset.util.DataSourceUtil;

public class DbDataTypeStrategyFactory {
    public static IDataTypeStrategy getStrategy(String dbName) {
        DbType dbType = DataSourceUtil.getDbType(dbName);
        switch (dbType) {
            case DM: {
                return new DmDataTypeStrategy();
            }
            case OSCAR: {
                return new OscarDataTypeStrategy();
            }
            case ORACLE: 
            case ORACLE_12C: {
                return new OracleDataTypeStrategy();
            }
            case HIGH_GO: {
                return new HighGoDataTypeStrategy();
            }
            case KINGBASE_ES: {
                return new KingbaseEsDataTypeStrategy();
            }
            case SQL_SERVER: 
            case SQL_SERVER2005: {
                return new SqlServerDataTypeStrategy();
            }
            case POSTGRE_SQL: {
                return new PgDataTypeStrategy();
            }
        }
        return new MysqlDataTypeStrategy();
    }
}

