/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datapush.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.datapush.bo.HttpRequestBO;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpURLConnectionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpURLConnectionUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private HttpURLConnectionUtil() {
    }

    public static String sendGet(String baseUrl, Map<String, Object> headerMap, Map<String, Object> paramMap) {
        StringBuilder url = new StringBuilder(baseUrl);
        StringBuilder response = new StringBuilder();
        try {
            String inputLine;
            HttpURLConnectionUtil.setUrlParams(url, paramMap);
            URL sendUrl = new URL(url.toString());
            HttpURLConnection connection = (HttpURLConnection)sendUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(60000);
            HttpURLConnectionUtil.setHeaders(headerMap, connection);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        }
        catch (IOException e) {
            throw new BaseException("\u8bf7\u6c42" + url + "\u5931\u8d25\uff0c\u786e\u8ba4\u7f51\u7edc\u662f\u5426\u53ef\u8bbf\u95ee", (Throwable)e);
        }
        return response.toString();
    }

    public static <T> T sendGet(HttpRequestBO HttpRequestBO2) {
        String responseJsonStr = HttpURLConnectionUtil.sendGet(HttpRequestBO2.getUrl(), HttpRequestBO2.getHeaders(), HttpRequestBO2.getParams());
        return HttpURLConnectionUtil.getResponseObj(HttpRequestBO2, responseJsonStr);
    }

    public static <T> T sendGet(String baseUrl, Map<String, Object> headerMap, Map<String, Object> paramMap, Class<T> clazz) {
        Object result = null;
        String responseJsonStr = HttpURLConnectionUtil.sendGet(baseUrl, headerMap, paramMap);
        try {
            result = OBJECT_MAPPER.readValue(responseJsonStr, clazz);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        return (T)result;
    }

    public static <T> T sendGet(String baseUrl, Map<String, Object> headerMap, Map<String, Object> paramMap, TypeReference<T> typeReference) {
        Object result = null;
        String responseJsonStr = HttpURLConnectionUtil.sendGet(baseUrl, headerMap, paramMap);
        try {
            result = OBJECT_MAPPER.readValue(responseJsonStr, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        return (T)result;
    }

    public static <T> T sendGet(String baseUrl, Map<String, Object> headerMap, Map<String, Object> paramMap, Class<?> ... responseObjectCls) {
        Object result = null;
        String responseJsonStr = HttpURLConnectionUtil.sendGet(baseUrl, headerMap, paramMap);
        JavaType responseObject = HttpURLConnectionUtil.buildJavaType(responseObjectCls);
        try {
            result = OBJECT_MAPPER.readValue(responseJsonStr, responseObject);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        return (T)result;
    }

    public static <T> T sendGet(String baseUrl, Map<String, Object> headerMap, Map<String, Object> paramMap, JavaType responseJavaType) {
        Object result = null;
        String responseJsonStr = HttpURLConnectionUtil.sendGet(baseUrl, headerMap, paramMap);
        try {
            result = OBJECT_MAPPER.readValue(responseJsonStr, responseJavaType);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        return (T)result;
    }

    public static String sendPost(String baseUrl, Map<String, Object> headerMap, Map<String, Object> paramMap, Object requestBody) {
        String result = "";
        StringBuilder url = new StringBuilder(baseUrl);
        HttpURLConnectionUtil.setUrlParams(url, paramMap);
        try {
            String inputLine;
            URL sendUrl = new URL(url.toString());
            HttpURLConnection connection = (HttpURLConnection)sendUrl.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setConnectTimeout(60000);
            String requestBodyJsonStr = "";
            if (requestBody != null) {
                requestBodyJsonStr = OBJECT_MAPPER.writeValueAsString(requestBody);
            }
            HttpURLConnectionUtil.setHeaders(headerMap, connection, String.valueOf(requestBodyJsonStr.getBytes().length));
            DataOutputStream dos = new DataOutputStream(connection.getOutputStream());
            dos.write(requestBodyJsonStr.getBytes(StandardCharsets.UTF_8));
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            connection.getResponseCode();
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            result = response.toString();
            in.close();
            dos.close();
        }
        catch (JsonProcessingException e) {
            throw new BaseException("\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            String errorMsg = "\u8bf7\u6c42 " + url + " \u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage();
            LOGGER.error(errorMsg, (Throwable)e);
            throw new BaseException(errorMsg, (Throwable)e);
        }
        return result;
    }

    public static <T> T sendPost(HttpRequestBO HttpRequestBO2) {
        String responseJsonStr = HttpURLConnectionUtil.sendPost(HttpRequestBO2.getUrl(), HttpRequestBO2.getHeaders(), HttpRequestBO2.getParams(), HttpRequestBO2.getRequestBody());
        LOGGER.info("====================\u63a5\u53e3\u8fd4\u56de\u503c\uff1a{}====================\n", (Object)responseJsonStr);
        return HttpURLConnectionUtil.getResponseObj(HttpRequestBO2, responseJsonStr);
    }

    public static <T> T sendPost(String baseUrl, Map<String, Object> headerMap, Map<String, Object> paramMap, Object requestBody, Class<T> clazz) {
        Object result = null;
        String responseStr = HttpURLConnectionUtil.sendPost(baseUrl, headerMap, paramMap, requestBody);
        try {
            result = OBJECT_MAPPER.readValue(responseStr, clazz);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        return (T)result;
    }

    public static <T> T sendPost(String baseUrl, Map<String, Object> headerMap, Map<String, Object> paramMap, Object requestBody, TypeReference<T> typeReference) {
        Object result = null;
        String responseStr = HttpURLConnectionUtil.sendPost(baseUrl, headerMap, paramMap, requestBody);
        try {
            result = OBJECT_MAPPER.readValue(responseStr, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        return (T)result;
    }

    public static <T> T sendPost(String baseUrl, Map<String, Object> headerMap, Map<String, Object> paramMap, Object requestBody, Class<?> ... responseObjectCls) {
        Object result = null;
        String responseStr = HttpURLConnectionUtil.sendPost(baseUrl, headerMap, paramMap, requestBody);
        JavaType javaType = HttpURLConnectionUtil.buildJavaType(responseObjectCls);
        try {
            result = OBJECT_MAPPER.readValue(responseStr, javaType);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        return (T)result;
    }

    public static <T> T sendPost(String baseUrl, Map<String, Object> headerMap, Map<String, Object> paramMap, Object requestBody, JavaType responseJavaType) {
        Object result = null;
        String responseStr = HttpURLConnectionUtil.sendPost(baseUrl, headerMap, paramMap, requestBody);
        try {
            result = OBJECT_MAPPER.readValue(responseStr, responseJavaType);
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        return (T)result;
    }

    public static void setUrlParams(StringBuilder url, Map<String, Object> paramMap) {
        Optional<Map<String, Object>> paramMapOpt = Optional.ofNullable(paramMap);
        paramMapOpt.ifPresent(params -> {
            url.append("?");
            for (Map.Entry entry : params.entrySet()) {
                try {
                    url.append((String)entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue().toString(), "utf-8")).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    throw new BaseException((Throwable)e);
                }
            }
            url.deleteCharAt(url.length() - 1);
        });
    }

    public static void setHeaders(Map<String, Object> headerMap, HttpURLConnection connection) {
        Optional<Map<String, Object>> headerMapOpt = Optional.ofNullable(headerMap);
        headerMapOpt.ifPresent(headers -> {
            for (Map.Entry entry : headerMap.entrySet()) {
                connection.setRequestProperty((String)entry.getKey(), entry.getValue().toString());
            }
        });
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("connection", "Keep-Alive");
    }

    public static void setHeaders(Map<String, Object> headerMap, HttpURLConnection connection, String contentSize) {
        HttpURLConnectionUtil.setHeaders(headerMap, connection);
        connection.setRequestProperty("Content-Length", contentSize);
    }

    private static <T> T getResponseObj(HttpRequestBO requestDto, String responseJsonStr) {
        Object result = null;
        try {
            result = requestDto.getResponseObj() != null ? OBJECT_MAPPER.readValue(responseJsonStr, requestDto.getResponseObj()) : (requestDto.getTypeReference() != null ? OBJECT_MAPPER.readValue(responseJsonStr, requestDto.getTypeReference()) : (requestDto.getJavaType() != null ? OBJECT_MAPPER.readValue(responseJsonStr, requestDto.getJavaType()) : OBJECT_MAPPER.readValue(responseJsonStr, ObjectNode.class)));
        }
        catch (JsonProcessingException e) {
            throw new BaseException((Throwable)e);
        }
        return (T)result;
    }

    private static JavaType buildJavaType(Class<?> ... responseObjectCls) {
        JavaType result = responseObjectCls.length > 1 ? OBJECT_MAPPER.getTypeFactory().constructParametricType(responseObjectCls[0], (Class[])Arrays.copyOfRange(responseObjectCls, 1, responseObjectCls.length)) : OBJECT_MAPPER.getTypeFactory().constructType(responseObjectCls[0]);
        return result;
    }
}

