/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datapush.listener;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.authorization.organ.feign.RemoteHussarBaseStaffService;
import com.jxdinfo.hussar.authorization.organ.vo.StaffBo;
import com.jxdinfo.hussar.datapush.bo.HttpRequestBO;
import com.jxdinfo.hussar.datapush.properties.UnifiedTodoPushProperty;
import com.jxdinfo.hussar.datapush.utils.HttpURLConnectionUtil;
import com.jxdinfo.hussar.htsz.extend.model.SysTenantDataPush;
import com.jxdinfo.hussar.htsz.extend.service.ISysTenantDataPushBoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.ProcessDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushAbstractListener;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

@Component
public class UnifiedTodoPushListener
extends DataPushAbstractListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnifiedTodoPushListener.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String WEB_FORM_TYPE = "web";
    private static final String MOBILE_FORM_TYPE = "mobile";
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RemoteHussarBaseStaffService remoteHussarBaseStaffService;
    @Autowired
    private UnifiedTodoPushProperty iamDataPushProperty;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private ISysTenantDataPushBoService sysTenantDataPushBoService;

    public void addTask(DataPush dataPush) {
        String sysCode = "";
        String receiveTodoRequestUrl = "";
        if (HussarUtils.isEmpty((Object)this.iamDataPushProperty.getReceiveTodoRequestUrl())) {
            if (!this.lcdpBpmProperties.isUseZQDatapush()) {
                return;
            }
            SysTenantDataPush sysTenantDataPush = this.sysTenantDataPushBoService.getTenantDataPushConfig(dataPush.getTCode());
            if (HussarUtils.isEmpty((Object)sysTenantDataPush) || HussarUtils.hasEmpty((Object[])new Object[]{sysTenantDataPush.getReceiveTodoRequestUrl(), sysTenantDataPush.getSysCode()})) {
                LOGGER.error("********************\u7f3a\u5c11\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53c2\u6570********************");
                return;
            }
            if ("0".equals(sysTenantDataPush.getEnableFlag())) {
                LOGGER.info("********************{}\u79df\u6237\u4e0b\u667a\u4f01\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u7981\u7528********************", (Object)dataPush.getTCode());
                return;
            }
            sysCode = sysTenantDataPush.getSysCode();
            receiveTodoRequestUrl = sysTenantDataPush.getReceiveTodoRequestUrl();
        } else {
            sysCode = this.iamDataPushProperty.getSysCode();
            receiveTodoRequestUrl = this.iamDataPushProperty.getReceiveTodoRequestUrl();
        }
        String receiverIdCards = this.getReceiverIdCards(dataPush.getUserId());
        if (HussarUtils.isEmpty((Object)receiverIdCards)) {
            return;
        }
        StaffBo creator = this.remoteHussarBaseStaffService.findStaffByUserId(Long.valueOf(dataPush.getStartUserId()));
        ObjectNode reqBody = this.objectMapper.createObjectNode();
        reqBody.put("syscode", sysCode);
        reqBody.put("flowid", dataPush.getProcessInsId());
        reqBody.put("requestname", dataPush.getDescription());
        reqBody.put("workflowname", dataPush.getDescription());
        reqBody.put("nodename", dataPush.getTaskDefinitionName());
        Map<String, String> formUrlMap = this.geFormUrl(dataPush);
        reqBody.put("pcurl", formUrlMap.get(WEB_FORM_TYPE));
        reqBody.put("appurl", formUrlMap.get(MOBILE_FORM_TYPE));
        reqBody.put("creator", creator.getIdcard());
        Date startDate = dataPush.getStartDate();
        LocalDateTime startDateTime = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        reqBody.put("createdatetime", startDateTime.format(DATE_TIME_FORMATTER));
        reqBody.put("receiver", receiverIdCards);
        reqBody.put("receivedatetime", LocalDateTime.now().format(DATE_TIME_FORMATTER));
        reqBody.put("recetvets", String.valueOf(System.currentTimeMillis()));
        HttpRequestBO receiveTodoRequest = new HttpRequestBO.HttpRequestBOBuilder().url(receiveTodoRequestUrl).requestBody(reqBody).request();
        LOGGER.info("====================\u63a8\u9001\u5f85\u529e\u53c2\u6570====================\n{}", (Object)receiveTodoRequest);
        HttpURLConnectionUtil.sendPost(receiveTodoRequest);
    }

    public void completeTask(DataPush dataPush) {
        String sysCode = "";
        String processDoneRequestUrl = "";
        if (HussarUtils.isEmpty((Object)this.iamDataPushProperty.getReceiveTodoRequestUrl())) {
            if (!this.lcdpBpmProperties.isUseZQDatapush()) {
                return;
            }
            SysTenantDataPush sysTenantDataPush = this.sysTenantDataPushBoService.getTenantDataPushConfig(dataPush.getTCode());
            if (HussarUtils.isEmpty((Object)sysTenantDataPush) || HussarUtils.hasEmpty((Object[])new Object[]{sysTenantDataPush.getProcessDoneRequestUrl(), sysTenantDataPush.getSysCode()})) {
                LOGGER.error("********************\u7f3a\u5c11\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53c2\u6570********************");
                return;
            }
            if ("0".equals(sysTenantDataPush.getEnableFlag())) {
                LOGGER.info("********************{}\u79df\u6237\u4e0b\u667a\u4f01\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u7981\u7528********************", (Object)dataPush.getTCode());
                return;
            }
            sysCode = sysTenantDataPush.getSysCode();
            processDoneRequestUrl = sysTenantDataPush.getProcessDoneRequestUrl();
        } else {
            sysCode = this.iamDataPushProperty.getSysCode();
            processDoneRequestUrl = this.iamDataPushProperty.getProcessDoneRequestUrl();
        }
        LOGGER.info("====================\u53c2\u4e0e\u8005IDs\uff1a{}====================", (Object)dataPush.getAllUserIdList());
        String receiverIdsStr = Optional.ofNullable(dataPush.getAllUserIdList()).map(receiverIds -> String.join((CharSequence)",", receiverIds)).orElse(dataPush.getUserId());
        String receiverIdCards = this.getReceiverIdCards(receiverIdsStr);
        if (StringUtils.isEmpty((CharSequence)receiverIdCards)) {
            return;
        }
        ObjectNode reqBody = this.objectMapper.createObjectNode();
        reqBody.put("syscode", sysCode);
        reqBody.put("flowid", dataPush.getProcessInsId());
        reqBody.put("requestname", dataPush.getDescription());
        reqBody.put("workflowname", dataPush.getDescription());
        reqBody.put("nodename", dataPush.getTaskDefinitionName());
        reqBody.put("receiver", receiverIdCards);
        reqBody.put("recetvets", String.valueOf(System.currentTimeMillis()));
        HttpRequestBO processDoneRequest = new HttpRequestBO.HttpRequestBOBuilder().url(processDoneRequestUrl).requestBody(reqBody).request();
        LOGGER.info("====================\u63a8\u9001\u5df2\u529e\u53c2\u6570====================\n{}", (Object)processDoneRequest);
        HttpURLConnectionUtil.sendPost(processDoneRequest);
    }

    public void deleteTask(DataPush dataPush) {
        super.deleteTask(dataPush);
    }

    public void entrustTask(DataPush dataPush) {
        super.entrustTask(dataPush);
    }

    public void transferUserTask(DataPush dataPush) {
        super.transferUserTask(dataPush);
    }

    public void rejectTask(DataPush dataPush) {
        super.rejectTask(dataPush);
    }

    public void revokeTask(DataPush dataPush) {
        super.revokeTask(dataPush);
    }

    public void freeJumpTask(DataPush dataPush) {
        super.freeJumpTask(dataPush);
    }

    public void addUser(DataPush dataPush) {
        super.addUser(dataPush);
    }

    public void deleteMultiTask(DataPush dataPush) {
        super.deleteMultiTask(dataPush);
    }

    public void addCcTask(DataPush dataPush) {
        super.addCcTask(dataPush);
    }

    public void addCcTask(List<DataPush> dataPushList) {
        super.addCcTask(dataPushList);
    }

    public void readCcTask(DataPush dataPush) {
        super.readCcTask(dataPush);
    }

    public void deleteCcTask(DataPush dataPush) {
        super.deleteCcTask(dataPush);
    }

    public void addUrgeTask(DataPush dataPush) {
        super.addUrgeTask(dataPush);
    }

    public void endProcess(DataPush dataPush) {
        super.endProcess(dataPush);
    }

    public void transferTask(DataPush dataPush) {
        super.transferTask(dataPush);
    }

    public void reTransferTask(DataPush dataPush) {
        super.reTransferTask(dataPush);
    }

    public void changeProcessState(DataPush dataPush) {
        String sysCode = "";
        String processOverRequestUrl = "";
        if (HussarUtils.isEmpty((Object)this.iamDataPushProperty.getReceiveTodoRequestUrl())) {
            if (!this.lcdpBpmProperties.isUseZQDatapush()) {
                return;
            }
            SysTenantDataPush sysTenantDataPush = this.sysTenantDataPushBoService.getTenantDataPushConfig(dataPush.getTCode());
            if (HussarUtils.isEmpty((Object)sysTenantDataPush) || HussarUtils.hasEmpty((Object[])new Object[]{sysTenantDataPush.getProcessOverRequestUrl(), sysTenantDataPush.getSysCode()})) {
                LOGGER.error("********************\u7f3a\u5c11\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53c2\u6570********************");
                return;
            }
            if ("0".equals(sysTenantDataPush.getEnableFlag())) {
                LOGGER.info("********************{}\u79df\u6237\u4e0b\u667a\u4f01\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u7981\u7528********************", (Object)dataPush.getTCode());
                return;
            }
            sysCode = sysTenantDataPush.getSysCode();
            processOverRequestUrl = sysTenantDataPush.getProcessOverRequestUrl();
        } else {
            sysCode = this.iamDataPushProperty.getSysCode();
            processOverRequestUrl = this.iamDataPushProperty.getProcessOverRequestUrl();
        }
        if (HussarUtils.isEmpty((Object)dataPush.getProcessEndTime())) {
            return;
        }
        String receiverIdCards = this.getReceiverIdCards(dataPush.getUserId());
        if (HussarUtils.isEmpty((Object)receiverIdCards)) {
            return;
        }
        ObjectNode reqBody = this.objectMapper.createObjectNode();
        reqBody.put("syscode", sysCode);
        reqBody.put("flowid", dataPush.getProcessInsId());
        reqBody.put("requestname", dataPush.getDescription());
        reqBody.put("workflowname", dataPush.getDescription());
        reqBody.put("nodename", dataPush.getTaskDefinitionName());
        reqBody.put("receiver", receiverIdCards);
        reqBody.put("recetvets", String.valueOf(System.currentTimeMillis()));
        HttpRequestBO processOverRequest = new HttpRequestBO.HttpRequestBOBuilder().url(processOverRequestUrl).requestBody(reqBody).request();
        LOGGER.info("====================\u63a8\u9001\u6d41\u7a0b\u5b8c\u7ed3\u53c2\u6570====================\n{}", (Object)processOverRequest);
        HttpURLConnectionUtil.sendPost(processOverRequest);
    }

    public void addStartProcess(DataPush dataPush) {
        super.addStartProcess(dataPush);
    }

    public void updateStartProcess(DataPush dataPush) {
        super.updateStartProcess(dataPush);
    }

    public void deleteStartProcess(DataPush dataPush) {
        super.deleteStartProcess(dataPush);
    }

    public void updateBusinessInfo(DataPush dataPush) {
        super.updateBusinessInfo(dataPush);
    }

    public void changeProcessNode(DataPush dataPush) {
        super.changeProcessNode(dataPush);
    }

    public void processChange(ProcessDataPush processDataPush) {
        super.processChange(processDataPush);
    }

    public void processChangeList(List<ProcessDataPush> processDataPushList) {
        super.processChangeList(processDataPushList);
    }

    private Map<String, String> geFormUrl(DataPush dataPush) {
        String webFormAddress;
        LOGGER.info("====================webUrl: {}====================", (Object)dataPush.getUrl());
        HashMap<String, String> formUrlMap = new HashMap<String, String>();
        if (HussarUtils.isEmpty((Object)dataPush.getUrl())) {
            return formUrlMap;
        }
        LambdaQueryWrapper extendPropertiesWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)extendPropertiesWrapper.eq(SysActExtendProperties::getProcDefId, (Object)dataPush.getProcessDefinitionId())).eq(SysActExtendProperties::getTaskDefKey, (Object)dataPush.getTaskDefinitionKey());
        String urlParameter = new StringBuffer().append("?businessId=").append(dataPush.getBusinessKey()).append("&taskId=").append(dataPush.getTaskId()).append("&processDefinitionKey=").append(dataPush.getProcessKey()).append("&taskDefinitionKey=").append(dataPush.getTaskDefinitionKey()).toString();
        String webAddress = JSON.parseObject((String)dataPush.getUrl()).getString(WEB_FORM_TYPE);
        String mobileAddress = JSON.parseObject((String)dataPush.getUrl()).getString(MOBILE_FORM_TYPE);
        String authAddress = "";
        String frontAddress = "";
        String clientId = "";
        if (HussarUtils.isEmpty((Object)this.iamDataPushProperty.getReceiveTodoRequestUrl())) {
            SysTenantDataPush sysTenantDataPush = this.sysTenantDataPushBoService.getTenantDataPushConfig(dataPush.getTCode());
            LOGGER.info("\u667a\u4f01\u63a8\u9001geFormUrl\u83b7\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSON.toJSONString((Object)sysTenantDataPush));
            authAddress = sysTenantDataPush.getAuthAddress();
            frontAddress = sysTenantDataPush.getFrontAddress();
            clientId = sysTenantDataPush.getClientId();
        } else {
            authAddress = this.iamDataPushProperty.getAuthAddress();
            frontAddress = this.iamDataPushProperty.getFrontAddress();
            clientId = this.iamDataPushProperty.getClientId();
        }
        if ("2".equals(dataPush.getTaskType())) {
            webFormAddress = (HussarUtils.isEmpty((Object)webAddress) ? "" : webAddress) + urlParameter + "&doneListIdentification=4";
            String encodedWebFormAddress = frontAddress + "/#/ssoLogin?" + webFormAddress;
            encodedWebFormAddress = UriUtils.encode((String)encodedWebFormAddress, (Charset)StandardCharsets.UTF_8);
            formUrlMap.put(WEB_FORM_TYPE, authAddress + "?redirect_uri=" + encodedWebFormAddress + "&client_id=" + clientId + "&response_type=code&state=123");
            String mobileFormAddress = (HussarUtils.isEmpty((Object)mobileAddress) ? "" : mobileAddress) + urlParameter + "&doneListIdentification=4";
            String encodedMobileFormAddress = frontAddress + "/#/ssoLogin?" + mobileFormAddress;
            encodedMobileFormAddress = UriUtils.encode((String)encodedMobileFormAddress, (Charset)StandardCharsets.UTF_8);
            formUrlMap.put(MOBILE_FORM_TYPE, authAddress + "?redirect_uri=" + encodedMobileFormAddress + "&client_id=" + clientId + "&response_type=code&state=123");
        } else {
            webFormAddress = (HussarUtils.isEmpty((Object)webAddress) ? "" : webAddress) + urlParameter;
            String encodedWebFormAddress = frontAddress + "/#/ssoLogin?" + webFormAddress;
            encodedWebFormAddress = UriUtils.encode((String)encodedWebFormAddress, (Charset)StandardCharsets.UTF_8);
            formUrlMap.put(WEB_FORM_TYPE, authAddress + "?redirect_uri=" + encodedWebFormAddress + "&client_id=" + clientId + "&response_type=code&state=123");
            String mobileFormAddress = (HussarUtils.isEmpty((Object)mobileAddress) ? "" : mobileAddress) + urlParameter;
            String encodedMobileFormAddress = frontAddress + "/#/ssoLogin?" + mobileFormAddress;
            encodedMobileFormAddress = UriUtils.encode((String)encodedMobileFormAddress, (Charset)StandardCharsets.UTF_8);
            formUrlMap.put(MOBILE_FORM_TYPE, authAddress + "?redirect_uri=" + encodedMobileFormAddress + "&client_id=" + clientId + "&response_type=code&state=123");
        }
        return formUrlMap;
    }

    private String getReceiverIdCards(String receiverIdsStr) {
        if (StringUtils.isEmpty((CharSequence)receiverIdsStr)) {
            return null;
        }
        LOGGER.info("====================\u53c2\u4e0e\u8005id\uff1a{}\n====================", (Object)receiverIdsStr);
        List receiverIds = Arrays.stream(receiverIdsStr.split(",")).filter(HussarUtils::isNotEmpty).map(Long::valueOf).collect(Collectors.toList());
        List receivers = this.remoteHussarBaseStaffService.findStaffsByUserIds(receiverIds);
        if (HussarUtils.isEmpty((Object)receivers)) {
            LOGGER.error("********************\u53c2\u4e0e\u8005\u4e0d\u5b58\u5728\uff01********************");
            return null;
        }
        String receiverIdCards = receivers.stream().map(StaffBo::getIdcard).filter(HussarUtils::isNotEmpty).collect(Collectors.joining(","));
        if (StringUtils.isEmpty((CharSequence)receiverIdCards)) {
            LOGGER.error("********************\u65e0\u6cd5\u83b7\u53d6\u53c2\u4e0e\u8005\uff01********************");
            return null;
        }
        return receiverIdCards;
    }
}

