/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.example.datapush;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActHiTaskinstMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiTaskinst;
import com.jxdinfo.hussar.workflow.engine.bpm.config.DataPushProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.dto.DataPushDto;
import com.jxdinfo.hussar.workflow.engine.bpm.util.HttpUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushAbstractListener;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class DataPushForTask
extends DataPushAbstractListener {
    private static final Logger logger = LogManager.getLogger(DataPushForTask.class);
    @Resource
    private DataPushService dataPushService;
    @Resource
    private SysStruUserMapper sysStruUserMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private HistoryService historyService;
    @Resource
    private DataPushProperties dataPushProperties;
    @Resource
    private BpmActHiTaskinstMapper bpmActHiTaskinstMapper;

    public void addTask(DataPush dataPush) {
        String startThirdId = null;
        startThirdId = dataPush.getStartUserId();
        logger.info("\u53d1\u8d77\u4eba\u7528\u6237id\uff08jxd\uff09\uff0cstartThirdId:{}", (Object)startThirdId);
        DataPushDto dataPushDto = this.combineOutsideDataPushForCreate(dataPush, startThirdId);
        String url = this.dataPushProperties.getAddTaskUrl();
        try {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(BpmActHiTaskinst::getProcInstId, (Object)dataPush.getProcessInsId());
            Long l = this.bpmActHiTaskinstMapper.selectCount((Wrapper)lambdaQueryWrapper);
            dataPushDto.setIsStart(l < 1L);
            HttpUtil.doPost(url, JSON.toJSONString((Object)dataPushDto));
        }
        catch (Exception e) {
            logger.info("\u5f85\u529e\u63a8\u9001\u5931\u8d25");
            e.printStackTrace();
        }
    }

    public void rejectTask(DataPush dataPush) {
        this.completeTask(dataPush);
    }

    public void freeJumpTask(DataPush dataPush) {
        this.completeTask(dataPush);
    }

    public void endProcess(DataPush dataPush) {
        DataPushDto dataPushDto = this.combineOutsideDataPushForComplete(dataPush);
        String url = this.dataPushProperties.getCompleteProcessUrl();
        if (HussarUtils.isNotEmpty((Object)dataPush.getTaskId())) {
            dataPushDto.setTaskId(dataPush.getTaskId());
            try {
                HttpUtil.doPost(url, JSON.toJSONString((Object)dataPushDto));
            }
            catch (Exception e) {
                logger.info("\u63a8\u9001\u529e\u7ed3\u4efb\u52a1\u5931\u8d25");
                e.printStackTrace();
            }
        } else if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
            List taskIds = dataPush.getTaskIds();
            taskIds.forEach(taskId -> {
                dataPushDto.setTaskId((String)taskId);
                try {
                    HttpUtil.doPost(url, JSON.toJSONString((Object)dataPushDto));
                }
                catch (Exception e) {
                    logger.info("\u63a8\u9001\u5b8c\u7ed3\u4efb\u52a1\u5931\u8d25");
                    e.printStackTrace();
                }
            });
        }
    }

    public void completeTask(DataPush dataPush) {
        DataPushDto dataPushDto = this.combineOutsideDataPushForComplete(dataPush);
        String url = this.dataPushProperties.getFinishTaskUrl();
        if (HussarUtils.isNotEmpty((Object)dataPush.getTaskId())) {
            dataPushDto.setTaskId(dataPush.getTaskId());
            try {
                HttpUtil.doPost(url, JSON.toJSONString((Object)dataPushDto));
            }
            catch (Exception e) {
                logger.info("\u63a8\u9001\u5b8c\u6210\u4efb\u52a1\u5931\u8d25");
                e.printStackTrace();
            }
        } else if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
            List taskIds = dataPush.getTaskIds();
            taskIds.forEach(taskId -> {
                dataPushDto.setTaskId((String)taskId);
                try {
                    HttpUtil.doPost(url, JSON.toJSONString((Object)dataPushDto));
                }
                catch (Exception e) {
                    logger.info("\u63a8\u9001\u5b8c\u6210\u4efb\u52a1\u5931\u8d25");
                    e.printStackTrace();
                }
            });
        }
    }

    public void deleteMultiTask(DataPush dataPush) {
        if (HussarUtils.isEmpty((Object)dataPush.getBusinessKey())) {
            String taskId = dataPush.getTaskId();
            if (HussarUtils.isEmpty((Object)taskId)) {
                taskId = (String)dataPush.getTaskIds().get(0);
            }
            String processInstanceId = ((HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult()).getProcessInstanceId();
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (historicProcessInstance != null) {
                dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            }
        }
        this.completeTask(dataPush);
    }

    public void changeProcessState(DataPush task) {
        if ("completeProcess".equals(task.getProcessState())) {
            String startUserId = task.getStartUserId();
            HashMap<String, Object> dataPush = new HashMap<String, Object>();
            ArrayList receiverIds = new ArrayList();
            dataPush.put("receiverIds", receiverIds);
            dataPush.put("businessId", task.getBusinessKey());
            dataPush.put("businessState", "1");
            dataPush.put("processInstId", task.getProcessInsId());
            String url = this.dataPushProperties.getCompleteProcessUrl();
            try {
                HttpUtil.doPost(url, JSON.toJSONString(dataPush));
            }
            catch (Exception e) {
                logger.info("\u63a8\u9001\u6d41\u7a0b\u7ed3\u675f\u5931\u8d25");
                e.printStackTrace();
            }
        }
    }

    private DataPushDto combineOutsideDataPushForCreate(DataPush task, String startThirdId) {
        DataPushDto dataPush = new DataPushDto();
        dataPush.setSyscode(this.dataPushProperties.getSysCode());
        dataPush.setFlowid(task.getProcessDefinitionId());
        dataPush.setRequestname(task.getProcessTitle());
        dataPush.setWorkflowname(task.getTaskDefinitionName());
        dataPush.setNodaname(task.getProcessName());
        dataPush.setPcurl("xxx");
        dataPush.setAppurl("xxx");
        dataPush.setCreator(startThirdId);
        dataPush.setCreatedatetime(task.getProcessStartTime().toString());
        dataPush.setReceivedatetime(task.getProcessStartTime().toString());
        dataPush.setReceivets(String.valueOf(System.currentTimeMillis()));
        dataPush.setBusinessId(task.getBusinessKey());
        dataPush.setTaskId(task.getTaskId());
        String taskAssignee = null;
        try {
            taskAssignee = this.getAssigneeByTaskId(task);
            HashMap<String, Object> assigneeMap = new HashMap<String, Object>();
            assigneeMap.put(task.getTaskDefinitionKey(), taskAssignee);
            dataPush.setAssigneeMap(assigneeMap);
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().includeTaskLocalVariables()).taskId(task.getTaskId())).singleResult();
            if (HussarUtils.isNotEmpty((Object)historicTaskInstance)) {
                dataPush.setNodeMap(historicTaskInstance.getTaskLocalVariables());
            } else {
                dataPush.setNodeMap(null);
            }
            String[] split = taskAssignee.split(",");
            List<String> list = Arrays.asList(split);
            dataPush.setUserIdList(list);
            dataPush.setReceiver(taskAssignee);
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u63a5\u53d7\u4eba\uff1a{}", (Object)taskAssignee);
            e.printStackTrace();
        }
        return dataPush;
    }

    private DataPushDto combineOutsideDataPushForComplete(DataPush task) {
        DataPushDto dataPush = new DataPushDto();
        dataPush.setBusinessId(task.getBusinessKey());
        dataPush.setBusinessState(task.getTaskState());
        dataPush.setSyscode(this.dataPushProperties.getSysCode());
        dataPush.setFlowid(task.getProcessDefinitionId());
        dataPush.setRequestname(task.getProcessTitle());
        dataPush.setWorkflowname(task.getTaskDefinitionName());
        dataPush.setNodaname(task.getProcessName());
        dataPush.setReceivets(String.valueOf(System.currentTimeMillis()));
        String taskAssignee = this.getAssigneeByTaskId(task);
        if (ToolUtil.isNotEmpty((Object)taskAssignee)) {
            dataPush.setReceivets(taskAssignee);
        }
        return dataPush;
    }

    private String getAssigneeByTaskId(DataPush task) {
        HashSet users = new HashSet();
        List identityLinks = task.getUserMaps();
        return String.join((CharSequence)",", users);
    }

    public void sendReq(DataPush dataPush) {
        DataPushDto dataPushDto = this.combineOutsideDataPushForComplete(dataPush);
        dataPushDto.setPcurl("xxx");
        dataPushDto.setAppurl("xxx");
        dataPushDto.setIsremark(dataPush.getProcessState());
        dataPushDto.setViewtype(dataPush.getTaskState());
        dataPushDto.setCreator(dataPush.getStartUserId());
        dataPushDto.setCreatedatetime(dataPush.getProcessStartTime().toString());
        dataPushDto.setReceivedatetime(dataPush.getProcessStartTime().toString());
        String url = this.dataPushProperties.getReceiveReqUrl();
        if (HussarUtils.isNotEmpty((Object)dataPush.getTaskId())) {
            dataPushDto.setTaskId(dataPush.getTaskId());
            try {
                HttpUtil.doPost(url, JSON.toJSONString((Object)dataPushDto));
            }
            catch (Exception e) {
                logger.info("\u63a8\u9001\u5f02\u6784\u63a5\u6536\u4efb\u52a1\u5931\u8d25");
                e.printStackTrace();
            }
        } else if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
            List taskIds = dataPush.getTaskIds();
            taskIds.forEach(taskId -> {
                dataPushDto.setTaskId((String)taskId);
                try {
                    HttpUtil.doPost(url, JSON.toJSONString((Object)dataPushDto));
                }
                catch (Exception e) {
                    logger.info("\u63a8\u9001\u5f02\u6784\u63a5\u6536\u4efb\u52a1\u5931\u8d25");
                    e.printStackTrace();
                }
            });
        }
    }

    public void deleteReq(DataPush dataPush) {
        DataPushDto dataPushDto = null;
        dataPushDto.setSyscode(this.dataPushProperties.getSysCode());
        dataPushDto.setFlowid(dataPush.getProcessDefinitionId());
        String url = this.dataPushProperties.getDeleteReqUrl();
        if (HussarUtils.isNotEmpty((Object)dataPush.getTaskId())) {
            dataPushDto.setTaskId(dataPush.getTaskId());
            try {
                HttpUtil.doPost(url, JSON.toJSONString((Object)dataPushDto));
            }
            catch (Exception e) {
                logger.info("\u63a8\u9001\u5f02\u6784\u5220\u9664\u4efb\u52a1\u5931\u8d25");
                e.printStackTrace();
            }
        } else if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
            List taskIds = dataPush.getTaskIds();
            taskIds.forEach(taskId -> {
                dataPushDto.setTaskId((String)taskId);
                try {
                    HttpUtil.doPost(url, JSON.toJSONString((Object)dataPushDto));
                }
                catch (Exception e) {
                    logger.info("\u63a8\u9001\u5f02\u6784\u5220\u9664\u4efb\u52a1\u5931\u8d25");
                    e.printStackTrace();
                }
            });
        }
    }

    public void deleteUserReq(DataPush dataPush, String userId) {
        DataPushDto dataPushDto = null;
        dataPushDto.setSyscode(this.dataPushProperties.getSysCode());
        dataPushDto.setFlowid(dataPush.getProcessDefinitionId());
        dataPushDto.setUserid(userId);
        String url = this.dataPushProperties.getDeleteUserReqUrl();
        if (HussarUtils.isNotEmpty((Object)dataPush.getTaskId())) {
            dataPushDto.setTaskId(dataPush.getTaskId());
            try {
                HttpUtil.doPost(url, JSON.toJSONString((Object)dataPushDto));
            }
            catch (Exception e) {
                logger.info("\u63a8\u9001\u5f02\u6784\u5220\u9664\u4efb\u52a1\u5931\u8d25");
                e.printStackTrace();
            }
        } else if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
            List taskIds = dataPush.getTaskIds();
            taskIds.forEach(taskId -> {
                dataPushDto.setTaskId((String)taskId);
                try {
                    HttpUtil.doPost(url, JSON.toJSONString((Object)dataPushDto));
                }
                catch (Exception e) {
                    logger.info("\u63a8\u9001\u5f02\u6784\u5220\u9664\u4efb\u52a1\u5931\u8d25");
                    e.printStackTrace();
                }
            });
        }
    }

    public void deleteUserReqs(List<DataPush> dataPushs) {
        List dataPushDtos = null;
        for (int d = 0; d < dataPushs.size(); ++d) {
            ((DataPushDto)dataPushDtos.get(d)).setSyscode(this.dataPushProperties.getSysCode());
            ((DataPushDto)dataPushDtos.get(d)).setFlowid(dataPushs.get(d).getProcessDefinitionId());
            ((DataPushDto)dataPushDtos.get(d)).setUserid(dataPushs.get(d).getUserId());
        }
        String url = this.dataPushProperties.getDeleteUserReqUrl();
        HttpUtil.doPost(url, JSON.toJSONString((Object)dataPushDtos));
    }

    public void batchReceiveReq(List<DataPush> dataPushs) {
        List dataPushDtos = null;
        for (int d = 0; d < dataPushs.size(); ++d) {
            DataPushDto dataPushDto = this.combineOutsideDataPushForComplete(dataPushs.get(d));
            dataPushDto.setPcurl("xxx");
            dataPushDto.setAppurl("xxx");
            dataPushDto.setIsremark(dataPushs.get(d).getProcessState());
            dataPushDto.setViewtype(dataPushs.get(d).getTaskState());
            dataPushDto.setCreator(dataPushs.get(d).getStartUserId());
            dataPushDto.setCreatedatetime(dataPushs.get(d).getProcessStartTime().toString());
            dataPushDto.setReceivedatetime(dataPushs.get(d).getProcessStartTime().toString());
            ((DataPushDto)dataPushDtos.get(d)).setSyscode(this.dataPushProperties.getSysCode());
            ((DataPushDto)dataPushDtos.get(d)).setFlowid(dataPushs.get(d).getProcessDefinitionId());
            ((DataPushDto)dataPushDtos.get(d)).setUserid(dataPushs.get(d).getUserId());
        }
        String url = this.dataPushProperties.getDeleteUserReqUrl();
        HttpUtil.doPost(url, JSON.toJSONString(dataPushDtos));
    }

    public void createOfsWorkflowType(DataPush dataPush) {
        DataPushDto dataPushDto = null;
        dataPushDto.setSyscode(this.dataPushProperties.getSysCode());
        dataPushDto.setOfsWorkFlowTypeName("xxx");
        dataPushDto.setOfsWorkFlowTypeCode("xxx");
        String url = this.dataPushProperties.getCreateOfsWorkflowTypeUrl();
        if (HussarUtils.isNotEmpty((Object)dataPush.getTaskId())) {
            dataPushDto.setTaskId(dataPush.getTaskId());
            try {
                HttpUtil.doPost2(url, JSON.toJSONString((Object)dataPushDto));
            }
            catch (Exception e) {
                logger.info("\u63a8\u9001\u7edf\u4e00\u6d41\u7a0b\u65b0\u5efa\uff1a\u521b\u5efa\u5f02\u6784\u7cfb\u7edf\u6d41\u7a0b\u7c7b\u578b\u4efb\u52a1\u5931\u8d25");
                e.printStackTrace();
            }
        } else if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
            List taskIds = dataPush.getTaskIds();
            taskIds.forEach(taskId -> {
                dataPushDto.setTaskId((String)taskId);
                try {
                    HttpUtil.doPost2(url, JSON.toJSONString((Object)dataPushDto));
                }
                catch (Exception e) {
                    logger.info("\u63a8\u9001\u7edf\u4e00\u6d41\u7a0b\u65b0\u5efa\uff1a\u521b\u5efa\u5f02\u6784\u7cfb\u7edf\u6d41\u7a0b\u7c7b\u578b\u4efb\u52a1\u5931\u8d25");
                    e.printStackTrace();
                }
            });
        }
    }

    public void createOfsWorkflow(DataPush dataPush, String userId) {
        DataPushDto dataPushDto = null;
        dataPushDto.setOfsWorkFlowName("xxx");
        dataPushDto.setOfsWorkFlowCode("xxx");
        dataPushDto.setPcurl("xxxx");
        dataPushDto.setAppurl("xxxx");
        dataPushDto.setScopecreator(this.getAssigneeByTaskId(dataPush));
        dataPushDto.setScopecreatortype("");
        dataPushDto.setOfsWorkFlowTypeCode("xxx");
        dataPushDto.setSyscode(this.dataPushProperties.getSysCode());
        String url = this.dataPushProperties.getCreateOfsWorkflowUrl();
        if (HussarUtils.isNotEmpty((Object)dataPush.getTaskId())) {
            dataPushDto.setTaskId(dataPush.getTaskId());
            try {
                HttpUtil.doPost2(url, JSON.toJSONString((Object)dataPushDto));
            }
            catch (Exception e) {
                logger.info("\u63a8\u9001\u5f02\u6784\u5220\u9664\u4efb\u52a1\u5931\u8d25");
                e.printStackTrace();
            }
        } else if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
            List taskIds = dataPush.getTaskIds();
            taskIds.forEach(taskId -> {
                dataPushDto.setTaskId((String)taskId);
                try {
                    HttpUtil.doPost2(url, JSON.toJSONString((Object)dataPushDto));
                }
                catch (Exception e) {
                    logger.info("\u63a8\u9001\u5f02\u6784\u5220\u9664\u4efb\u52a1\u5931\u8d25");
                    e.printStackTrace();
                }
            });
        }
    }

    public void sendCustomMessageSingle(DataPush dataPush) {
        DataPushDto dataPushDto = null;
        dataPushDto.setCode("xxx");
        dataPushDto.setCreator(dataPush.getStartUserId());
        dataPushDto.setTitle(dataPush.getProcessTitle());
        dataPushDto.setContent(dataPush.getProcessName());
        dataPushDto.setLinkUrl("xxxx");
        dataPushDto.setLinkMobileUrl("xxxx");
        dataPushDto.setTargetId("xx");
        dataPushDto.setBizState("0");
        String url = this.dataPushProperties.getSendCustomMessageSingleUrl();
        if (HussarUtils.isNotEmpty((Object)dataPush.getTaskId())) {
            dataPushDto.setTaskId(dataPush.getTaskId());
            try {
                HttpUtil.doPost2(url, JSON.toJSONString((Object)dataPushDto));
            }
            catch (Exception e) {
                logger.info("\u53d1\u9001\u6d88\u606f\u4efb\u52a1\u5931\u8d25");
                e.printStackTrace();
            }
        } else if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
            List taskIds = dataPush.getTaskIds();
            taskIds.forEach(taskId -> {
                dataPushDto.setTaskId((String)taskId);
                try {
                    HttpUtil.doPost2(url, JSON.toJSONString((Object)dataPushDto));
                }
                catch (Exception e) {
                    logger.info("\u53d1\u9001\u6d88\u606f\u4efb\u52a1\u5931\u8d25");
                    e.printStackTrace();
                }
            });
        }
    }

    public void alterCustomMessageSingle(DataPush dataPush) {
        DataPushDto dataPushDto = null;
        dataPushDto.setCode("xxx");
        dataPushDto.setTargetId("xx");
        dataPushDto.setBizState("0");
        String url = this.dataPushProperties.getAlterCustomMessageSingleUrl();
        if (HussarUtils.isNotEmpty((Object)dataPush.getTaskId())) {
            dataPushDto.setTaskId(dataPush.getTaskId());
            try {
                HttpUtil.doPost2(url, JSON.toJSONString((Object)dataPushDto));
            }
            catch (Exception e) {
                logger.info("\u6539\u53d8\u6d88\u606f\u72b6\u6001\u4efb\u52a1\u5931\u8d25");
                e.printStackTrace();
            }
        } else if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
            List taskIds = dataPush.getTaskIds();
            taskIds.forEach(taskId -> {
                dataPushDto.setTaskId((String)taskId);
                try {
                    HttpUtil.doPost2(url, JSON.toJSONString((Object)dataPushDto));
                }
                catch (Exception e) {
                    logger.info("\u6539\u53d8\u6d88\u606f\u72b6\u6001\u4efb\u52a1\u5931\u8d25");
                    e.printStackTrace();
                }
            });
        }
    }

    public void deleteCustomMessageSingle(DataPush dataPush) {
        DataPushDto dataPushDto = null;
        dataPushDto.setCode("xxx");
        dataPushDto.setTargetId("xx");
        String url = this.dataPushProperties.getDeleteCustomMessageSingleUrl();
        if (HussarUtils.isNotEmpty((Object)dataPush.getTaskId())) {
            dataPushDto.setTaskId(dataPush.getTaskId());
            try {
                HttpUtil.doPost2(url, JSON.toJSONString((Object)dataPushDto));
            }
            catch (Exception e) {
                logger.info("\u5220\u9664\u6d88\u606f\u4efb\u52a1\u5931\u8d25");
                e.printStackTrace();
            }
        } else if (HussarUtils.isNotEmpty((Object)dataPush.getTaskIds())) {
            List taskIds = dataPush.getTaskIds();
            taskIds.forEach(taskId -> {
                dataPushDto.setTaskId((String)taskId);
                try {
                    HttpUtil.doPost2(url, JSON.toJSONString((Object)dataPushDto));
                }
                catch (Exception e) {
                    logger.info("\u5220\u9664\u6d88\u606f\u4efb\u52a1\u5931\u8d25");
                    e.printStackTrace();
                }
            });
        }
    }
}

