/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.data.build.binddata.provide.data;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.data.build.binddata.attr.DuplicateAreaBindAttrs;
import com.jxdinfo.hussar.data.build.binddata.content.BindConstant;
import com.jxdinfo.hussar.data.build.binddata.empty.BindDataCtx;
import com.jxdinfo.hussar.data.build.binddata.empty.BindDataSource;
import com.jxdinfo.hussar.data.build.binddata.factory.BindNodeProvideFactory;
import com.jxdinfo.hussar.data.build.binddata.node.DuplicateAreaBindNode;
import com.jxdinfo.hussar.data.build.binddata.provide.BindDataVisitor;
import com.jxdinfo.hussar.data.build.binddata.util.BindDataSourceUtil;
import com.jxdinfo.hussar.data.build.binddata.util.DataBindUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.data.build.binddata.provide.data.duplicate_area")
public class DuplicateAreaDataProvide
implements BindDataVisitor {
    public static final String provideName = "com.jxdinfo.hussar.data.build.binddata.provide.data.duplicate_area";

    @PostConstruct
    public void register() {
        BindNodeProvideFactory.register(provideName, this);
    }

    @Override
    public JSONObject getNodeDataSet(JSONObject nodeJsonObj, BindDataCtx bindDataCtx) {
        DuplicateAreaBindNode duplicateAreaBindNode = (DuplicateAreaBindNode)JsonUtil.convertValue((Object)nodeJsonObj, DuplicateAreaBindNode.class);
        String bindKey = duplicateAreaBindNode.getBindKey();
        DuplicateAreaBindAttrs attrs = duplicateAreaBindNode.getBindAttrs();
        if (HussarUtils.isEmpty((Object)attrs) || HussarUtils.isEmpty((Object)attrs.getSourceWordDataSetId())) {
            return null;
        }
        if (HussarUtils.isEmpty((Object)bindKey)) {
            return null;
        }
        JSONObject resultData = new JSONObject();
        if (HussarUtils.isNotEmpty((Object)nodeJsonObj.getJSONArray("bindContent"))) {
            JSONArray childContent = nodeJsonObj.getJSONArray("bindContent");
            if (DuplicateAreaDataProvide.isQuotedChildContent(childContent)) {
                resultData.put(bindKey, (Object)DuplicateAreaDataProvide.disposeQuotedChildContext(nodeJsonObj, bindDataCtx));
            } else {
                resultData.put(bindKey, (Object)DuplicateAreaDataProvide.disposeTextContent(childContent, bindDataCtx));
            }
        } else {
            resultData.put(bindKey, (Object)new JSONArray());
        }
        return resultData;
    }

    private static boolean isQuotedChildContent(JSONArray childContent) {
        boolean flag = false;
        for (Object o : childContent) {
            JSONObject childContentJson = JSON.parseObject((String)HussarUtils.toJson(o));
            String bindType = childContentJson.get((Object)BindConstant.JSON_TYPE).toString();
            if ("text".equals(bindType) || "image".equals(bindType)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static JSONArray disposeTextContent(JSONArray childContent, BindDataCtx bindDataCtx) {
        JSONObject textDataMap = new JSONObject();
        for (Object o : childContent) {
            JSONObject childContentJson = JSON.parseObject((String)HussarUtils.toJson(o));
            String bindType = childContentJson.get((Object)BindConstant.JSON_TYPE).toString();
            BindDataVisitor bindDataVisitor = BindNodeProvideFactory.get("com.jxdinfo.hussar.data.build.binddata.provide.data." + bindType);
            if (!"text".equals(bindType) && !"image".equals(bindType)) continue;
            JSONObject textMap = bindDataVisitor.getNodeDataSet(childContentJson, bindDataCtx);
            textDataMap.putAll((Map)textMap);
        }
        return DataBindUtil.convert(textDataMap);
    }

    private static JSONArray disposeQuotedChildContext(JSONObject nodeJsonObj, BindDataCtx bindDataCtx) {
        DuplicateAreaBindNode duplicateAreaBindNode = (DuplicateAreaBindNode)JsonUtil.convertValue((Object)nodeJsonObj, DuplicateAreaBindNode.class);
        DuplicateAreaBindAttrs bindAttrs = duplicateAreaBindNode.getBindAttrs();
        String dupBindWordDataSetId = bindAttrs.getSourceWordDataSetId();
        List<String> duplicateDataTier = bindAttrs.getDuplicateDataTier();
        if (HussarUtils.isEmpty(duplicateDataTier)) {
            return new JSONArray();
        }
        Map<String, Object> datasetData = bindDataCtx.getDatasetData();
        Object duplicateAreaDataObj = datasetData.get(dupBindWordDataSetId);
        return DuplicateAreaDataProvide.recursiveDup(nodeJsonObj, bindDataCtx, duplicateAreaDataObj, null);
    }

    private static JSONArray recursiveDup(JSONObject nodeJsonObj, BindDataCtx bindDataCtx, Object dupData, List<String> parentDataTier) {
        DuplicateAreaBindNode duplicateAreaBindNode = (DuplicateAreaBindNode)JsonUtil.convertValue((Object)nodeJsonObj, DuplicateAreaBindNode.class);
        DuplicateAreaBindAttrs bindAttrs = duplicateAreaBindNode.getBindAttrs();
        String dupBindWordDataSetId = bindAttrs.getSourceWordDataSetId();
        List<String> duplicateDataTier = bindAttrs.getDuplicateDataTier();
        JSONArray duplicateAreaDirectData = DuplicateAreaDataProvide.getDuplicateAreaDirectData(duplicateDataTier, dupData, parentDataTier);
        JSONArray childContent = nodeJsonObj.getJSONArray("bindContent");
        JSONArray resultData = new JSONArray();
        for (Object duplicateAreaDirectDatum : duplicateAreaDirectData) {
            JSONObject rowData = new JSONObject();
            for (Object o : childContent) {
                JSONObject childContentJson = JSON.parseObject((String)HussarUtils.toJson(o));
                if (HussarUtils.isNotEmpty((Object)childContentJson.getJSONArray("bindContent"))) {
                    String childType = childContentJson.getString(BindConstant.JSON_TYPE);
                    if ("table_area".equals(childType)) {
                        rowData.put(childContentJson.getString(BindConstant.BIND_KEY), (Object)DuplicateAreaDataProvide.buildChildTableNode(childContentJson, bindDataCtx, duplicateAreaDirectDatum, dupBindWordDataSetId, duplicateDataTier));
                        continue;
                    }
                    if (!"duplicate_area".equals(childType)) continue;
                    rowData.put(childContentJson.getString(BindConstant.BIND_KEY), (Object)DuplicateAreaDataProvide.recursiveDup(childContentJson, bindDataCtx, duplicateAreaDirectDatum, duplicateDataTier));
                    continue;
                }
                String bindDataSouceString = childContentJson.getString("bindDataSource");
                BindDataSource convert = (BindDataSource)JsonUtil.parse((String)bindDataSouceString, BindDataSource.class);
                rowData.put(childContentJson.getString(BindConstant.BIND_KEY), BindDataSourceUtil.getDataByPathOfBasic(convert, bindDataCtx, duplicateAreaDirectDatum, dupBindWordDataSetId, duplicateDataTier));
            }
            resultData.add((Object)rowData);
        }
        return resultData;
    }

    private static JSONArray getDuplicateAreaDirectData(List<String> usagePath, Object duplicateAreaDataObj, List<String> parentDataTier) {
        if (HussarUtils.isNotEmpty(usagePath) && usagePath.size() >= 2) {
            JSONObject jsonObject = null;
            if (duplicateAreaDataObj instanceof String) {
                if (DuplicateAreaDataProvide.objIsJsonArray(duplicateAreaDataObj.toString())) {
                    return JSON.parseArray((String)duplicateAreaDataObj.toString());
                }
                jsonObject = JSON.parseObject((String)duplicateAreaDataObj.toString());
            } else {
                jsonObject = JSON.parseObject((String)duplicateAreaDataObj.toString());
            }
            List<String> actualPath = HussarUtils.isNotEmpty(parentDataTier) ? usagePath.subList(parentDataTier.size(), usagePath.size()) : usagePath.subList(2, usagePath.size());
            Object dataByNoPath = BindDataSourceUtil.getDataByNoPathInAllData(actualPath, jsonObject);
            if (dataByNoPath instanceof JSONObject) {
                JSONObject object = (JSONObject)dataByNoPath;
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)object);
                return jsonArray;
            }
            return (JSONArray)dataByNoPath;
        }
        if (duplicateAreaDataObj instanceof String) {
            if (DuplicateAreaDataProvide.objIsJsonArray((String)duplicateAreaDataObj)) {
                return JSON.parseArray((String)duplicateAreaDataObj.toString());
            }
            return new JSONArray();
        }
        if (duplicateAreaDataObj instanceof JSONObject) {
            JSONObject object = (JSONObject)duplicateAreaDataObj;
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)object);
            return jsonArray;
        }
        return (JSONArray)duplicateAreaDataObj;
    }

    private static boolean objIsJsonArray(String json) {
        return json.startsWith("[") && json.endsWith("]");
    }

    private static JSONObject buildChildTableNode(JSONObject nodeJson, BindDataCtx bindDataCtx, Object duplicateAreaDirectDatum, String dupBindWordDataSetId, List<String> dupPath) {
        JSONObject tableMap = new JSONObject();
        JSONArray childContent = nodeJson.getJSONArray("bindContent");
        for (Object o : childContent) {
            JSONObject childContentJson = JSON.parseObject((String)HussarUtils.toJson(o));
            String bindType = childContentJson.getString(BindConstant.JSON_TYPE);
            if (!"row_data".equals(bindType)) continue;
            String rowKey = childContentJson.getString(BindConstant.BIND_KEY);
            JSONArray rowNodeArray = childContentJson.getJSONArray("bindContent");
            JSONObject textDataMap = new JSONObject();
            for (Object rowDataObj : rowNodeArray) {
                JSONObject rowTextJson = JSON.parseObject((String)HussarUtils.toJson(rowDataObj));
                String bindDataSouceString = rowTextJson.getString("bindDataSource");
                BindDataSource convert = (BindDataSource)JsonUtil.parse((String)bindDataSouceString, BindDataSource.class);
                textDataMap.put(rowTextJson.getString(BindConstant.BIND_KEY), BindDataSourceUtil.getDataByPathOfBasic(convert, bindDataCtx, duplicateAreaDirectDatum, dupBindWordDataSetId, dupPath));
            }
            tableMap.put(rowKey, (Object)DataBindUtil.convert(textDataMap));
        }
        return tableMap;
    }
}

