/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.data.build.binddata.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.data.build.binddata.content.BindConstant;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class MultiColumnPivotTable {
    private static final String COLUMN_KEY_DELIMITER = "|";

    public static JSONArray pivot(JSONArray data, List<String> rowKeys, List<String> columnArrayNameList, Map<String, JSONArray> cloTextGroupContent, Map<String, List<String>> valueKeysMap) {
        JSONArray result = new JSONArray();
        HashMap<String, Set<String>> headerKeysGroup = new HashMap<String, Set<String>>();
        HashMap objectObjectHashMap = new HashMap();
        for (int i = 0; i < columnArrayNameList.size(); ++i) {
            JSONArray objects = cloTextGroupContent.get(columnArrayNameList.get(i));
            TreeSet<String> columnCombinationSet = new TreeSet<String>();
            TreeSet<String> objectObjectHashMapSet = new TreeSet<String>();
            for (Object item : objects) {
                JSONObject itemObj = (JSONObject)item;
                String string = itemObj.getString(BindConstant.BIND_KEY);
                for (Object datum : data) {
                    JSONObject datumObj = (JSONObject)datum;
                    columnCombinationSet.add(datumObj.getString(string));
                    objectObjectHashMapSet.add(string + " - " + datumObj.getString(string));
                }
            }
            objectObjectHashMap.put(columnArrayNameList.get(i), objectObjectHashMapSet);
            headerKeysGroup.put(columnArrayNameList.get(i), columnCombinationSet);
        }
        result.add((Object)MultiColumnPivotTable.createHeaderRow(rowKeys, headerKeysGroup, valueKeysMap));
        HashMap langMap = new HashMap();
        for (int i = 0; i < data.size(); ++i) {
            List<JSONObject> jsonObjects;
            JSONObject obj = (JSONObject)data.get(i);
            String eachLangKey = "";
            for (int j = 0; j < rowKeys.size(); ++j) {
                eachLangKey = eachLangKey + obj.getString(rowKeys.get(j)) + COLUMN_KEY_DELIMITER;
            }
            if (HussarUtils.isNotEmpty((Object)eachLangKey)) {
                eachLangKey = eachLangKey.substring(0, eachLangKey.length() - 1);
            }
            if (!langMap.containsKey(eachLangKey)) {
                jsonObjects = new ArrayList<JSONObject>();
                jsonObjects.add(obj);
                langMap.put(eachLangKey, jsonObjects);
                continue;
            }
            jsonObjects = (List)langMap.get(eachLangKey);
            jsonObjects.add(obj);
        }
        for (Map.Entry stringListEntry : langMap.entrySet()) {
            String key = (String)stringListEntry.getKey();
            JSONArray row = new JSONArray();
            String[] rowKeyParts = key.split("\\|");
            for (String part : rowKeyParts) {
                row.add((Object)part);
            }
            for (Map.Entry entry : valueKeysMap.entrySet()) {
                List valueKeyList = (List)entry.getValue();
                String valueKey = (String)valueKeyList.get(0);
                Set keyKeyList = (Set)objectObjectHashMap.get(entry.getKey());
                List dataValue = (List)stringListEntry.getValue();
                block8: for (String s : keyKeyList) {
                    int dashIndex = s.indexOf(" - ");
                    String keyFist = s.substring(0, dashIndex);
                    String keySec = s.substring(dashIndex + 3);
                    for (int i = 0; i < dataValue.size(); ++i) {
                        JSONObject jsonObject = (JSONObject)dataValue.get(i);
                        if (jsonObject.containsKey((Object)keyFist) && jsonObject.get((Object)keyFist).equals(keySec)) {
                            row.add((Object)jsonObject.getString(valueKey));
                            continue block8;
                        }
                        if (i < dataValue.size() - 1) continue;
                        row.add((Object)"");
                    }
                }
            }
            result.add((Object)row);
        }
        return result;
    }

    private static String generateRowKey(JSONObject obj, List<String> rowKeys) {
        StringBuilder sb = new StringBuilder();
        String delimiter = "";
        for (String key : rowKeys) {
            sb.append(delimiter);
            Object value = obj.get((Object)key);
            sb.append(value != null ? String.valueOf(value) : "");
            delimiter = COLUMN_KEY_DELIMITER;
        }
        return sb.toString();
    }

    private static String generateColumnKey(JSONObject obj, List<String> columnKeys) {
        StringBuilder sb = new StringBuilder();
        String delimiter = "";
        for (String key : columnKeys) {
            sb.append(delimiter);
            Object value = obj.get((Object)key);
            sb.append(value != null ? String.valueOf(value) : "");
            delimiter = COLUMN_KEY_DELIMITER;
        }
        return sb.toString();
    }

    private static String generateColumnKeyNew(JSONObject obj, Map<String, List<String>> columnKeysMap) {
        StringBuilder sb = new StringBuilder();
        String delimiter = "";
        for (Map.Entry<String, List<String>> entry : columnKeysMap.entrySet()) {
            List<String> keyList = entry.getValue();
            for (String key : keyList) {
                sb.append(delimiter);
                Object value = obj.get((Object)key);
                sb.append(value != null ? String.valueOf(value) : "");
                delimiter = COLUMN_KEY_DELIMITER;
            }
        }
        return sb.toString();
    }

    private static JSONArray createHeaderRow(List<String> rowKeys, Map<String, Set<String>> columnCombinations, Map<String, List<String>> valueKeysMap) {
        JSONArray header = new JSONArray();
        header.addAll(rowKeys);
        for (Map.Entry<String, Set<String>> entry : columnCombinations.entrySet()) {
            Set<String> value = entry.getValue();
            String key = entry.getKey();
            for (String s : value) {
                List<String> strings = valueKeysMap.get(key);
                for (String string : strings) {
                    header.add((Object)(s + " - " + string));
                }
            }
        }
        return header;
    }

    public static JSONArray pivot(JSONArray data, List<String> rowKeys, String columnKey, String valueKey) {
        Set columns = data.stream().map(obj -> (JSONObject)obj).map(obj -> obj.getString(columnKey)).filter(str -> str != null && !str.isEmpty()).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
        Map<List, Map<String, Object>> grouped = data.stream().map(JSONObject.class::cast).collect(Collectors.groupingBy(obj -> rowKeys.stream().map(key -> obj.get(key)).collect(Collectors.toList()), Collectors.toMap(obj -> obj.getString(columnKey), obj -> obj.get((Object)valueKey), (existing, replacement) -> existing)));
        JSONArray result = new JSONArray();
        JSONArray header = new JSONArray();
        header.addAll(rowKeys);
        header.addAll((Collection)columns);
        result.add((Object)header);
        grouped.forEach((rowKeysList, valueMap) -> {
            JSONArray row = new JSONArray();
            row.addAll((Collection)rowKeysList);
            for (String col : columns) {
                Object value = valueMap.get(col);
                row.add(value != null ? value : "");
            }
            result.add((Object)row);
        });
        return result;
    }
}

