/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dashboard.run.plugin.multiaxeschart.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.dashboard.json.Metric;
import com.jxdinfo.hussar.dashboard.json.ParamsData;
import com.jxdinfo.hussar.dashboard.json.QueryWidgetData;
import com.jxdinfo.hussar.dashboard.run.plugin.base.data.ConvertData;
import com.jxdinfo.hussar.dashboard.run.plugin.base.service.support.AbstractPluginBaseRemoteService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="multi_axes_chart")
public class MultiAxesChartConvertRemoteService
extends AbstractPluginBaseRemoteService<Map<String, Object>, Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(MultiAxesChartConvertRemoteService.class);

    protected ConvertData<Map<String, Object>> convertData(ConvertData<Map<String, Object>> data) {
        HashMap<String, JSONArray> optionMap = new HashMap<String, JSONArray>();
        JSONArray xAxis = new JSONArray();
        JSONArray series = new JSONArray();
        ParamsData dataMap = (ParamsData)((Map)data.getData()).get("dataMap");
        QueryWidgetData widgetData = (QueryWidgetData)((Map)data.getData()).get("widget");
        HashMap<String, String> metricNameMap = new HashMap<String, String>();
        JSONArray jsonArray = (JSONArray)((Map)data.getData()).get("json");
        List groupNames = dataMap.getGroupAggregation().getGroup();
        HashMap<String, String> groupNamesMap = new HashMap<String, String>();
        ArrayList<String> seriesFields = new ArrayList<String>();
        boolean hasEmptyValue = false;
        for (Object e : jsonArray) {
            JSONObject jSONObject = (JSONObject)e;
            String groupName = jSONObject.getString((String)groupNames.get(0));
            if ("".equals(groupName) || groupName == null) {
                hasEmptyValue = true;
                continue;
            }
            if (groupNamesMap.get(groupName) == null) {
                groupNamesMap.put(groupName, groupName);
                xAxis.add((Object)groupName);
            }
            if (groupNames.size() <= 1 || seriesFields.contains(jSONObject.get(groupNames.get(1)).toString())) continue;
            seriesFields.add(jSONObject.get(groupNames.get(1)).toString());
        }
        if (hasEmptyValue) {
            xAxis.add((Object)"\u5176\u4ed6");
        }
        for (Metric metric : widgetData.getMetrics()) {
            metricNameMap.put(metric.getName(), metric.getTitle());
            if (groupNames.size() != 1) continue;
            seriesFields.add(metric.getName());
        }
        for (String string : seriesFields) {
            JSONObject jSONObject = new JSONObject();
            if (groupNames.size() > 1) {
                jSONObject.put("name", (Object)string);
            } else {
                jSONObject.put("name", metricNameMap.get(string));
                jSONObject.put("field", (Object)string);
            }
            jSONObject.put("data", (Object)new JSONArray(xAxis.size()));
            jSONObject.put("type", (Object)"left");
            series.add((Object)jSONObject);
        }
        if (widgetData.getRtmetrics() != null) {
            ArrayList<String> rtSeriesFields = new ArrayList<String>();
            for (Metric metric : widgetData.getRtmetrics()) {
                metricNameMap.put(metric.getName(), metric.getTitle());
                if (groupNames.size() != 1) continue;
                rtSeriesFields.add(metric.getName());
                seriesFields.add(metric.getName());
            }
            for (String string : rtSeriesFields) {
                JSONObject seriesObj = new JSONObject();
                if (groupNames.size() > 1) {
                    seriesObj.put("name", (Object)string);
                } else {
                    seriesObj.put("name", metricNameMap.get(string));
                    seriesObj.put("field", (Object)string);
                }
                seriesObj.put("data", (Object)new JSONArray(xAxis.size()));
                seriesObj.put("type", (Object)"right");
                series.add((Object)seriesObj);
            }
        }
        HashMap<String, String> aggNameMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String str : dataMap.getGroupAggregation().getAgg().keySet()) {
            String aggName = (String)dataMap.getGroupAggregation().getAgg().get(str);
            arrayList.add(aggName);
            int lastIndex = aggName.lastIndexOf("_agg");
            aggNameMap.put(aggName.substring(0, lastIndex), aggName);
        }
        for (Object obj : jsonArray) {
            JSONObject jsonObject = (JSONObject)obj;
            if (groupNames.size() > 1) {
                String seriesFieldName = jsonObject.getString((String)groupNames.get(1)).toString();
                int seriesIndex = seriesFields.indexOf(seriesFieldName);
                JSONObject seriesObj = series.getJSONObject(seriesIndex);
                JSONArray values = seriesObj.getJSONArray("data");
                String xAxisName = jsonObject.getString((String)groupNames.get(0));
                if ("".equals(xAxisName) || xAxisName == null) {
                    xAxisName = "\u5176\u4ed6";
                }
                int xAxisIndex = xAxis.indexOf((Object)xAxisName);
                values.set(xAxisIndex, (Object)jsonObject.getDouble((String)arrayList.get(0)));
                continue;
            }
            String xAxisName = jsonObject.getString((String)groupNames.get(0));
            if ("".equals(xAxisName) || xAxisName == null) {
                xAxisName = "\u5176\u4ed6";
            }
            int xAxisIndex = xAxis.indexOf((Object)xAxisName);
            for (int i = 0; i < seriesFields.size(); ++i) {
                String aggName = (String)aggNameMap.get(seriesFields.get(i));
                JSONObject seriesObj = series.getJSONObject(i);
                JSONArray values = seriesObj.getJSONArray("data");
                values.set(xAxisIndex, (Object)jsonObject.getDouble(aggName));
            }
        }
        optionMap.put("xAxis", xAxis);
        optionMap.put("series", series);
        ConvertData convertData = new ConvertData(null, null, optionMap);
        return convertData;
    }
}

