/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dashboard.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.dashboard.json.DashboardJsonData;
import com.jxdinfo.hussar.dashboard.model.DashEntry;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.dashboard.controller.DashEntryController")
@RequestMapping(value={"/dashentry"})
@AuditLog(moduleName="\u4eea\u8868\u76d8-\u4eea\u8868\u76d8\u4fe1\u606f\u8868")
@Api(tags={"\u4eea\u8868\u76d8-\u4eea\u8868\u76d8\u5904\u7406"})
public class DashEntryController
extends HussarBaseController<DashEntry, IDashEntryService> {
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private IDashEntryService dashentryService;
    @Resource
    private ISysFormService sysFormService;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u4eea\u8868\u76d8\u4fe1\u606f\u4fdd\u5b58", notes="\u4eea\u8868\u76d8\u4fe1\u606f\u4fdd\u5b58")
    public ApiResponse<Long> add(@RequestBody DashEntry dashentry) {
        return ApiResponse.success((Object)this.dashentryService.savePanelData(dashentry));
    }

    @PostMapping(value={"/edit"})
    @ApiOperation(value="\u4eea\u8868\u76d8\u4fe1\u606f\u4fee\u6539", notes="\u4eea\u8868\u76d8\u4fe1\u606f\u4fee\u6539")
    public ApiResponse<Long> edit(@RequestBody DashEntry dashentry) {
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)dashentry.getEntryId());
        SysFormDto sysFormDto = new SysFormDto();
        sysFormDto.setFormType(sysForm.getFormType());
        sysFormDto.setId(sysForm.getId());
        sysFormDto.setFormName(dashentry.getEntryName());
        sysFormDto.setSeq(sysFormDto.getSeq());
        sysFormDto.setFormStatus(sysForm.getFormStatus());
        sysFormDto.setFormGroupId("".equals(dashentry.getGroupId()) ? null : Long.valueOf(Long.parseLong(dashentry.getGroupId())));
        sysFormDto.setTableName(sysForm.getTableName());
        sysFormDto.setAppId(sysForm.getAppId());
        sysFormDto.setAppName(sysFormDto.getAppName());
        sysFormDto.setFormIcon(dashentry.getIcon());
        sysFormDto.setFormIconType(sysFormDto.getFormIconType());
        sysFormDto.setFormIconColor(sysFormDto.getFormIconColor());
        sysFormDto.setExtname(sysFormDto.getExtname());
        boolean flag = this.sysFormService.editForm(sysFormDto).isSuccess();
        if (flag) {
            return ApiResponse.success((Object)dashentry.getEntryId());
        }
        return ApiResponse.fail((String)"\u4eea\u8868\u76d8\u6570\u636e\u4fee\u6539\u5931\u8d25");
    }

    @GetMapping(value={"/deleteWidgetById"})
    public ApiResponse<Boolean> deleteWidgetById(@RequestParam Long entryId) {
        if (HussarUtils.isEmpty((Object)entryId)) {
            return ApiResponse.fail((String)"\u5220\u9664\u4eea\u8868\u76d8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Wrapper queryWrapper = (Wrapper)new QueryWrapper().eq((Object)"ENTRY_ID", (Object)entryId);
        DashEntry dashEntry = (DashEntry)this.dashentryService.getOne(queryWrapper);
        if (dashEntry == null) {
            return ApiResponse.fail((String)"\u5220\u9664\u56fe\u8868\u6570\u636e\u4e0d\u5b58\u5728");
        }
        dashEntry.setEntryStatus("0");
        Boolean flag = this.dashentryService.updateById((Object)dashEntry);
        return ApiResponse.success((Object)flag);
    }

    @GetMapping(value={"/deletePanelById"})
    public ApiResponse<Boolean> deletePanelById(@RequestParam Long entryId) {
        if (HussarUtils.isEmpty((Object)entryId)) {
            return ApiResponse.fail((String)"\u5220\u9664\u4eea\u8868\u76d8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Boolean flag = this.dashentryService.deleteData(entryId);
        return ApiResponse.success((Object)flag);
    }

    @PostMapping(value={"/addChart"})
    @ApiOperation(value="\u65b0\u589e\u7ec4\u4ef6", notes="\u65b0\u589e\u7ec4\u4ef6")
    public ApiResponse<Long> addChart(@RequestBody DashEntry dashEntry) {
        return ApiResponse.success((Object)this.dashentryService.saveWidgetData(dashEntry));
    }

    @PostMapping(value={"/updateChart"})
    @ApiOperation(value="\u4fee\u6539\u7ec4\u4ef6", notes="\u4fee\u6539\u7ec4\u4ef6")
    public ApiResponse<Long> updateChart(@RequestBody String widgetInfo) {
        if (HussarUtils.isEmpty((Object)widgetInfo)) {
            return ApiResponse.fail((String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success((Object)this.dashentryService.updateWidgetData(widgetInfo));
    }

    @PostMapping(value={"/copyWidget"})
    @ApiOperation(value="\u56fe\u8868\u4fe1\u606f\u590d\u5236", notes="\u56fe\u8868\u4fe1\u606f\u590d\u5236")
    public ApiResponse<Long> copyWidget(@RequestBody String widgetInfo) {
        return ApiResponse.success((Object)this.dashentryService.copyWidget(widgetInfo));
    }

    @GetMapping(value={"/copyPanel"})
    @ApiOperation(value="\u4eea\u8868\u76d8\u590d\u5236", notes="\u4eea\u8868\u76d8\u590d\u5236")
    public ApiResponse<DashEntry> copyPanel(@RequestParam(value="entryId") Long entryId, @RequestParam(value="name") String name) {
        if (HussarUtils.isEmpty((Object)entryId) || HussarUtils.isEmpty((Object)name)) {
            return ApiResponse.fail((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DashEntry dashEntry = this.dashentryService.copyPanel(entryId, name);
        return ApiResponse.success((Object)dashEntry);
    }

    @PostMapping(value={"/savePanel"})
    @ApiOperation(value="\u4fdd\u5b58\u4eea\u8868\u76d8", notes="\u4fdd\u5b58\u4eea\u8868\u76d8")
    public ApiResponse<Boolean> savePanel(@RequestBody DashboardJsonData dashboardJsonData) {
        if (HussarUtils.isEmpty((Object)dashboardJsonData)) {
            return ApiResponse.fail((String)"\u4eea\u8868\u76d8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success((Object)this.dashentryService.savePanel(dashboardJsonData));
    }
}

