/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.config;

import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.config.IgnoreUrlsConfig;
import com.jxdinfo.hussar.core.listener.CloudConfigListener;
import com.jxdinfo.hussar.core.listener.ConfigListener;
import com.jxdinfo.hussar.core.listener.ErrorTipInterceptor;
import com.jxdinfo.hussar.core.listener.RLInterceptor;
import java.util.EventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="hussar.securityconfig")
public class SecurityConfig
implements WebMvcConfigurer {
    @Autowired
    IgnoreUrlsConfig ignoreUrlsConfig;

    @Bean
    ServletListenerRegistrationBean<ConfigListener> configListenerRegistration(@Autowired ConfigListener configListener) {
        return new ServletListenerRegistrationBean((EventListener)((Object)configListener));
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.cloud.client.discovery.DiscoveryClient"})
    ServletListenerRegistrationBean<CloudConfigListener> cloudConfigListenerRegistration(@Autowired CloudConfigListener cloudConfigListener) {
        return new ServletListenerRegistrationBean((EventListener)((Object)cloudConfigListener));
    }

    @Bean
    @ConditionalOnMissingBean(value={HussarConfig.class})
    HussarConfig hussarConfig() {
        return new HussarConfig();
    }

    @Bean
    @ConditionalOnMissingBean(value={RLInterceptor.class})
    HandlerInterceptor getInterceptor(HussarConfig hussarConfig) {
        return new RLInterceptor(hussarConfig);
    }

    @Bean
    HandlerInterceptor errorTipInterceptor() {
        return new ErrorTipInterceptor();
    }

    public void addInterceptors(InterceptorRegistry interceptorRegistry) {
        interceptorRegistry.addInterceptor(this.getInterceptor(this.hussarConfig())).addPathPatterns(new String[]{"/**"}).excludePathPatterns(this.ignoreUrlsConfig.getIgnoreUrls());
        interceptorRegistry.addInterceptor(this.errorTipInterceptor()).addPathPatterns(new String[]{"/**"});
    }
}

