/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1StreamParser;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nUl;
import com.jxdinfo.hussar.core.bouncycastle.util.Strings;
import com.jxdinfo.hussar.core.cache.CacheEntry;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement square();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract int getFieldSize();

    public abstract ECFieldElement sqrt();

    public abstract String getFieldName();

    public abstract ECFieldElement add(ECFieldElement var1);

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement invert();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private nUl K;
        public static final int TPB = 2;
        private int k;
        private int j;
        private int L;
        public static final int PPB = 3;
        private int G;
        private int b;
        public static final int GNB = 1;
        private int synchronized;

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            nUl nUl2 = f2m.K.volatile(f2m.L);
            int[] nArray = new int[3];
            nArray[0] = a.G;
            nArray[1] = a.k;
            nArray[2] = a.j;
            nUl2.if(a.L, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.L, f2m2.G, f2m3.k, f2m3.j, nUl2);
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.b = a + 31 >> 5;
            F2m f2m = a6;
            a6.K = new nUl(a5, a6.b);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.synchronized = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(ASN1StreamParser.new("(\u0005kR\u001fm7\u0017([bE'_-Y>]+\u000b\u0001|sI)\u0005"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(Tip.throws(")YC'?\u00107J)\u0007c\u0006)\u00135\u001ep\u000b\u0014!uSkR"));
                }
                a6.synchronized = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(ASN1StreamParser.new(";\u0017=^\u0006k&\u0017)_,X%JaW>\u000fe\u001a\u000e|i\u00004S"));
            }
            F2m f2m2 = a6;
            a6.L = a;
            f2m2.G = a2;
            f2m2.k = a3;
            a6.j = a4;
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, nUl a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.b = a + 31 >> 5;
            f2m3.K = a5;
            f2m2.L = a;
            f2m2.G = a2;
            f2m.k = a3;
            f2m.j = a4;
            if (a3 == 0 && a4 == 0) {
                a6.synchronized = 2;
                return;
            }
            a6.synchronized = 3;
        }

        @Override
        public String getFieldName() {
            return Tip.throws("{y\u000f");
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            nUl nUl2 = (nUl)a.K.clone();
            nUl nUl3 = new nUl(a.b);
            F2m f2m = a;
            nUl nUl4 = nUl3;
            nUl4.extends(a.L);
            nUl4.extends(0);
            nUl3.extends(f2m.G);
            if (f2m.synchronized == 3) {
                nUl nUl5 = nUl3;
                nUl5.extends(a.k);
                nUl5.extends(a.j);
            }
            nUl nUl6 = new nUl(a.b);
            nUl6.extends(0);
            nUl nUl7 = new nUl(a.b);
            nUl nUl8 = nUl2;
            while (!nUl8.char()) {
                int n = nUl2.this() - nUl3.this();
                if (n < 0) {
                    nUl nUl9 = nUl2;
                    nUl2 = nUl3;
                    nUl3 = nUl9;
                    nUl nUl10 = nUl6;
                    nUl6 = nUl7;
                    nUl7 = nUl10;
                    n = -n;
                }
                int n2 = n >> 5;
                nUl nUl11 = nUl3.for(n &= 0x1F);
                nUl nUl12 = nUl2;
                nUl8 = nUl12;
                nUl12.transient(nUl11, n2);
                nUl nUl13 = nUl7.for(n);
                nUl6.transient(nUl13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.L, f2m2.G, f2m3.k, f2m3.j, nUl7);
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.L;
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(Tip.throws(",,\u001eh\b?\u000bnN\r,zI.\u0006"));
        }

        public int getM() {
            F2m a;
            return a.L;
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        public int hashCode() {
            F2m a;
            return a.K.hashCode() ^ a.L ^ a.G ^ a.k ^ a.j;
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.K.case();
        }

        public int getK3() {
            F2m a;
            return a.j;
        }

        public int getK1() {
            F2m a;
            return a.G;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        public int getK2() {
            F2m a;
            return a.k;
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.L == f2m.L && a2.G == f2m.G && a2.k == f2m.k && a2.j == f2m.j && a2.synchronized == f2m.synchronized && a2.K.equals(f2m.K);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.K.null(((F2m)object).K, a2.L);
            int[] nArray = new int[3];
            nArray[0] = a2.G;
            nArray[1] = a2.k;
            nArray[2] = a2.j;
            ((nUl)object).if(a2.L, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.L, f2m.G, f2m2.k, f2m2.j, (nUl)object);
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            nUl nUl2 = (nUl)a2.K.clone();
            F2m f2m = (F2m)a;
            nUl2.transient(f2m.K, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.L, f2m2.G, f2m3.k, f2m3.j, nUl2);
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(ASN1StreamParser.new("i*R&Z!\u0010.S#_5[4\u0013`\u0007/\u001e\"WuU\bq\u0018pIt(A>_-T.LJq%\u0017\u000f}\u0004_/R%p7Jf\u001a\u0007i3/p["));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.L != f2m2.L || f2m.G != f2m2.G || f2m.k != f2m2.k || f2m.j != f2m2.j) {
                throw new IllegalArgumentException(Tip.throws("g\"\u0007+\nr\u001e\"\u0002eD-\u001e6LiS\u0006j\u000b#\u0014i*\n&\u0007/\r6\u0018C%,C7\u0002.B0\u000b%\u0004r\u001dkN\f-4{y\u000f"));
            }
            if (f2m.synchronized != f2m2.synchronized) {
                throw new IllegalArgumentException(ASN1StreamParser.new("z\"]vM*\u0018:R9\b=F&[.\u001ed\u0019'[+T/\\gRs\u0010jP#L!\u0010\u0006{\u0001}\u0007i5\u0012\"_0\u0017\"Q\tq1E/]6\u00168[1G>\\n\u0011\u001d|i\u0000-X"));
            }
        }

        public int getRepresentation() {
            F2m a;
            return a.synchronized;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger b;
        BigInteger private;

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.b, fp.private.modInverse(a.b));
        }

        @Override
        public String getFieldName() {
            return CacheEntry.else("\u0010(");
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.private = a2;
            if (a3.private.compareTo(a) >= 0) {
                throw new IllegalArgumentException(Strings.char("l}C\u001dp p|i;z|r6v*1=_\u0011 /%`u4>2u5i( s"));
            }
            a3.b = a;
        }

        public BigInteger getQ() {
            Fp a;
            return a.b;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.b, fp.private.multiply(a.toBigInteger()).mod(a2.b));
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.b, fp.private.subtract(a.toBigInteger()).mod(a2.b));
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.b.bitLength();
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.b, fp.private.multiply(a.private).mod(a.b));
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.b, fp.private.multiply(a.toBigInteger().modInverse(a2.b)).mod(a2.b));
        }

        public int hashCode() {
            Fp a;
            return a.b.hashCode() ^ a.private.hashCode();
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.b.testBit(0)) {
                throw new RuntimeException(Strings.char("X\u0010tig%o-\"2a9"));
            }
            if (a.b.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.b, fp.private.modPow(a.b.shiftRight(2).add(ECConstants.ONE), a.b));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.b.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.private.modPow(bigInteger2, a.b).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.private;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.b);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.b.bitLength(), random)).compareTo(a.b) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.b).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.volatile(a.b, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.b).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.b);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.b, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.b, fp.private.negate().mod(a.b));
        }

        private static /* synthetic */ BigInteger[] volatile(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.b.equals(fp.b) && a2.private.equals(fp.private);
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.private;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ECFieldElement add(ECFieldElement eCFieldElement) {
            void a;
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.b, fp.private.add(a.toBigInteger()).mod(a2.b));
        }
    }
}

