/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec;

import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.nist.NISTNamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.sec.SECNamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X962NamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9ECParameters;
import com.jxdinfo.hussar.core.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.jxdinfo.hussar.core.bouncycastle.crypto.params.ECDomainParameters;
import com.jxdinfo.hussar.core.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.jxdinfo.hussar.core.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.jxdinfo.hussar.core.bouncycastle.jce.interfaces.ECPrivateKey;
import com.jxdinfo.hussar.core.bouncycastle.jce.interfaces.ECPublicKey;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.JCEECPublicKey;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.ProviderUtil;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import com.jxdinfo.hussar.core.bouncycastle.jce.spec.ECParameterSpec;
import com.jxdinfo.hussar.core.support.PageKit;
import com.jxdinfo.hussar.core.support.exception.ToolBoxException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ECUtil {
    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey a) throws InvalidKeyException {
        if (a instanceof ECPrivateKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)a;
            ECParameterSpec eCParameterSpec = eCPrivateKey.getParameters();
            if (eCParameterSpec == null) {
                eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
            }
            return new ECPrivateKeyParameters(eCPrivateKey.getD(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        throw new InvalidKeyException(ToolBoxException.try("\u001b8\u0007o\u001bn\u001d1\u001b1G{\u001e ^\u001ap2(\u000b7\t)\u001d\fh\u001f0\b~"));
    }

    public static String getCurveName(DERObjectIdentifier a) {
        String string = X962NamedCurves.getName(a);
        if (string == null) {
            string = SECNamedCurves.getName(a);
            if (string == null) {
                string = NISTNamedCurves.getName(a);
            }
            if (string == null) {
                string = TeleTrusTNamedCurves.getName(a);
            }
            if (string == null) {
                string = ECGOST3410NamedCurves.getName(a);
            }
        }
        return string;
    }

    static int[] abstract(int[] a) {
        int[] nArray = new int[3];
        if (a.length == 1) {
            nArray[0] = a[0];
            return nArray;
        }
        if (a.length != 3) {
            throw new IllegalArgumentException(ToolBoxException.try("||\u0010$N\u001b\u0016,\u001e>\u001d8\u00195\u001ah\u000e \u0010u\u000e:]f\u00197\u00112Zs4\n~\f=\u0019\u0019'\u0006!\u00144"));
        }
        if (a[0] < a[1] && a[0] < a[2]) {
            nArray[0] = a[0];
            if (a[1] < a[2]) {
                int[] nArray2 = nArray;
                nArray2[1] = a[1];
                nArray[2] = a[2];
                return nArray2;
            }
            nArray[1] = a[2];
            nArray[2] = a[1];
            return nArray;
        }
        if (a[1] < a[2]) {
            nArray[0] = a[1];
            if (a[0] < a[2]) {
                int[] nArray3 = nArray;
                nArray3[1] = a[0];
                nArray[2] = a[2];
                return nArray3;
            }
            nArray[1] = a[2];
            nArray[2] = a[0];
            return nArray;
        }
        nArray[0] = a[2];
        if (a[0] < a[1]) {
            int[] nArray4 = nArray;
            nArray4[1] = a[0];
            nArray[2] = a[1];
            return nArray4;
        }
        nArray[1] = a[1];
        nArray[2] = a[0];
        return nArray;
    }

    public static X9ECParameters getNamedCurveByOid(DERObjectIdentifier a) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(a);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByOID(a);
            if (x9ECParameters == null) {
                x9ECParameters = NISTNamedCurves.getByOID(a);
            }
            if (x9ECParameters == null) {
                x9ECParameters = TeleTrusTNamedCurves.getByOID(a);
            }
        }
        return x9ECParameters;
    }

    public ECUtil() {
        ECUtil a;
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey a) throws InvalidKeyException {
        if (a instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)a;
            ECParameterSpec eCParameterSpec = eCPublicKey.getParameters();
            if (eCParameterSpec == null) {
                eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
                return new ECPublicKeyParameters(((JCEECPublicKey)eCPublicKey).engineGetQ(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
            }
            return new ECPublicKeyParameters(eCPublicKey.getQ(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        if (a instanceof java.security.interfaces.ECPublicKey) {
            java.security.interfaces.ECPublicKey eCPublicKey = (java.security.interfaces.ECPublicKey)a;
            ECParameterSpec eCParameterSpec = EC5Util.convertSpec(eCPublicKey.getParams(), false);
            return new ECPublicKeyParameters(EC5Util.convertPoint(eCPublicKey.getParams(), eCPublicKey.getW(), false), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        throw new InvalidKeyException(PageKit.double("\rC\u0005I\u000eYil\u0003N\u0015C;x\u001a\u000f5\u007fC_\u001aA\u000bB\u0015\u001a\fN\t\u0012"));
    }

    public static DERObjectIdentifier getNamedCurveOid(String a) {
        DERObjectIdentifier dERObjectIdentifier = X962NamedCurves.getOID(a);
        if (dERObjectIdentifier == null) {
            dERObjectIdentifier = SECNamedCurves.getOID(a);
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = NISTNamedCurves.getOID(a);
            }
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = TeleTrusTNamedCurves.getOID(a);
            }
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = ECGOST3410NamedCurves.getOID(a);
            }
        }
        return dERObjectIdentifier;
    }
}

