/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1InputStream;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEREncodable;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEROutputStream;
import com.jxdinfo.hussar.core.util.Checker;
import java.io.IOException;

public abstract class ASN1Object
extends DERObject {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ASN1Object fromByteArray(byte[] a) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(a);
        try {
            return (ASN1Object)aSN1InputStream.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(Checker.case("\u000b-Mm\u0003e^~\u00060S+MJ?T~C!9YN6 \u0006fGt\u001cs\u000bw\u0014"));
        }
    }

    @Override
    abstract void encode(DEROutputStream var1) throws IOException;

    @Override
    public abstract int hashCode();

    abstract boolean asn1Equals(DERObject var1);

    @Override
    public final boolean equals(Object a) {
        ASN1Object a2;
        if (a2 == a) {
            return true;
        }
        return a instanceof DEREncodable && a2.asn1Equals(((DEREncodable)a).getDERObject());
    }

    public ASN1Object() {
        ASN1Object a;
    }
}

