/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Boolean;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1EncodableVector;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Enumerated;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Exception;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1GeneralizedTime;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Integer;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1StreamParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1UTCTime;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERApplicationSpecificParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERConstructedOctetString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BEROctetStringParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERSequenceParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERSetParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERTaggedObjectParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.COn;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERApplicationSpecific;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERBMPString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERBitString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERExternal;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERExternalParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERGeneralString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERIA5String;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERNull;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERNumericString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEROctetString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERPrintableString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERT61String;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERTags;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERUTF8String;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERUniversalString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERUnknownTag;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERVisibleString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.LazyDERSequence;
import com.jxdinfo.hussar.core.bouncycastle.asn1.NUL;
import com.jxdinfo.hussar.core.bouncycastle.asn1.NuL;
import com.jxdinfo.hussar.core.bouncycastle.asn1.coN;
import com.jxdinfo.hussar.core.bouncycastle.util.io.Streams;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.FileLoader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ASN1InputStream
extends FilterInputStream
implements DERTags {
    private final int b;
    private final boolean break;

    public ASN1InputStream(InputStream a, int a2, boolean a3) {
        ASN1InputStream a4;
        ASN1InputStream aSN1InputStream = a4;
        super(a);
        aSN1InputStream.b = a2;
        aSN1InputStream.break = a3;
    }

    static int case(InputStream a) {
        if (a instanceof coN) {
            return ((coN)a).try();
        }
        if (a instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)a).available();
        }
        return Integer.MAX_VALUE;
    }

    public ASN1InputStream(byte[] a, boolean a2) {
        a3(new ByteArrayInputStream(a), a.length, a2);
        ASN1InputStream a3;
    }

    /*
     * Enabled aggressive block sorting
     */
    static DERObject enum(int a, byte[] a2) {
        switch (a) {
            case 3: {
                return DERBitString.strictfp(a2);
            }
            case 30: {
                return new DERBMPString(a2);
            }
            case 1: {
                return new ASN1Boolean(a2);
            }
            case 10: {
                return new ASN1Enumerated(a2);
            }
            case 24: {
                return new ASN1GeneralizedTime(a2);
            }
            case 27: {
                return new DERGeneralString(a2);
            }
            case 22: {
                return new DERIA5String(a2);
            }
            case 2: {
                return new ASN1Integer(a2);
            }
            case 5: {
                return DERNull.INSTANCE;
            }
            case 18: {
                return new DERNumericString(a2);
            }
            case 6: {
                return new ASN1ObjectIdentifier(a2);
            }
            case 4: {
                return new DEROctetString(a2);
            }
            case 19: {
                return new DERPrintableString(a2);
            }
            case 20: {
                return new DERT61String(a2);
            }
            case 28: {
                return new DERUniversalString(a2);
            }
            case 23: {
                return new ASN1UTCTime(a2);
            }
            case 12: {
                return new DERUTF8String(a2);
            }
            case 26: {
                return new DERVisibleString(a2);
            }
        }
        return new DERUnknownTag(false, a, a2);
    }

    public ASN1InputStream(byte[] a) {
        a2(new ByteArrayInputStream(a), a.length);
        ASN1InputStream a2;
    }

    static int boolean(InputStream a, int a2) throws IOException {
        int n = a.read();
        if (n < 0) {
            throw new EOFException(FileLoader.catch("TOE2x`\u0014\u001e}(IGE_\u0005XA[dfL\u0015GKEARTXH"));
        }
        if (n == 128) {
            return -1;
        }
        if (n > 127) {
            int n2;
            int n3 = n & 0x7F;
            if (n3 > 4) {
                throw new IOException(new StringBuilder().insert(0, HussarException.continue("\u001d\u000b\u0019|:$GY%.V\f\u0007\r\bZ\u0018\u0013*2LOJ\u001f\u0004\u001e\u001c\u001dOB")).append(n3).toString());
            }
            n = 0;
            int n4 = n2 = 0;
            while (n4 < n3) {
                int n5 = a.read();
                if (n5 < 0) {
                    throw new EOFException(FileLoader.catch("$?_(X@U_A\u0014VPbvM[E\u0013YA_GID"));
                }
                n = (n << 8) + n5;
                n4 = ++n2;
            }
            if (n < 0) {
                throw new IOException(HussarException.continue("\u001a\u0001\u0019\u000e\u0003\u0011][R\u0001*:997,\t\u0013q(\u0013\u0006\t\u000b\u0004\f\t['9\u0002\u001c\u001e\u0015]\f\u0016\u001b\u001b\u0006"));
            }
            if (n >= a2) {
                throw new IOException(FileLoader.catch("NZV\f\u001aATFV\u001e\\\u0015\u0002\u001b\u000e| .2qz\u0015Pvn\u001eMODKPW\u0015owJRV[\u0015B^USH"));
            }
        }
        return n;
    }

    ASN1EncodableVector volatile() throws IOException {
        DERObject dERObject;
        ASN1InputStream a;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1InputStream aSN1InputStream = a;
        while ((dERObject = aSN1InputStream.readObject()) != null) {
            aSN1InputStream = a;
            aSN1EncodableVector.add(dERObject);
        }
        return aSN1EncodableVector;
    }

    protected void readFully(byte[] a) throws IOException {
        ASN1InputStream a2;
        if (Streams.readFully(a2, a) != a.length) {
            throw new EOFException(HussarException.continue("$fx\u0016D7-$)85LL4\"V\b\u0006_\u0000\u0013\b\u001f'9L\u0014\f]\u0012\b\u0013\u000b\u0016\u0016"));
        }
    }

    public ASN1InputStream(InputStream a, int a2) {
        a3(a, a2, false);
        ASN1InputStream a3;
    }

    ASN1EncodableVector strictfp(NuL a) throws IOException {
        return new ASN1InputStream(a).volatile();
    }

    protected DERObject buildObject(int a, int a2, int a32) throws IOException {
        ASN1InputStream a4;
        boolean bl = (a & 0x20) != 0;
        NuL a32 = new NuL(a4, a32);
        if ((a & 0x40) != 0) {
            return new DERApplicationSpecific(bl, a2, a32.boolean());
        }
        if ((a & 0x80) != 0) {
            return new ASN1StreamParser(a32).native(bl, a2);
        }
        if (bl) {
            switch (a2) {
                case 4: {
                    return new BERConstructedOctetString(a4.strictfp((NuL)a32).while);
                }
                case 16: {
                    while (false) {
                    }
                    if (a4.break) {
                        return new LazyDERSequence(a32.boolean());
                    }
                    return NUL.goto(a4.strictfp(a32));
                }
                case 17: {
                    return NUL.package(a4.strictfp(a32), false);
                }
                case 8: {
                    return new DERExternal(a4.strictfp(a32));
                }
            }
            return new DERUnknownTag(true, a2, a32.boolean());
        }
        return ASN1InputStream.enum(a2, a32.boolean());
    }

    public ASN1InputStream(InputStream a) {
        ASN1InputStream a2;
        InputStream inputStream = a;
        a2(inputStream, ASN1InputStream.case(inputStream));
    }

    static int false(InputStream a, int a2) throws IOException {
        if ((a2 &= 0x1F) == 31) {
            a2 = 0;
            int n = a.read();
            if ((n & 0x7F) == 0) {
                throw new IOException(FileLoader.catch("GZN_@T\n\nU\u0000PFLJ\u0000\u001d^B1imd\u007fc\b\u00149`WHH\u0011QUC\u0015mgIWGA\u0015B^USH"));
            }
            int n2 = n;
            while (n2 >= 0 && (n & 0x80) != 0) {
                a2 |= n & 0x7F;
                a2 <<= 7;
                n2 = a.read();
            }
            if (n < 0) {
                throw new EOFException(HussarException.continue("\u0019\u0019\u0007\tX>3\u0018\u0005H\u0016\u0003\t\u0005\u001f.|\u0018\u001a\r]\u000b\u000b\u0015\u001b\u0010L"));
            }
            a2 |= n & 0x7F;
        }
        return a2;
    }

    public DERObject readObject() throws IOException {
        ASN1InputStream a;
        int n = a.read();
        if (n <= 0) {
            if (n == 0) {
                throw new IOException(FileLoader.catch("\u0005\u0010\nipfqjj\u0005P|fZ\u0002OW\bWK[wwJAQ\u0013XECKX^"));
            }
            return null;
        }
        int n2 = ASN1InputStream.false(a, n);
        boolean bl = (n & 0x20) != 0;
        int n3 = a.readLength();
        if (n3 < 0) {
            if (!bl) {
                throw new IOException(HussarException.continue("\u0005\u0015\u0010\u0006\u001b\u0003XH\r\u000bK\u0010\u0013\u000fNJ^\u0001)<\"1?5@H4f\u0013\u000f\u000b\u0010\t\u0013\u0002\u001ck9\u0002\u0018\u0005\b\u0013\u001e\u001c\u001c\u0010\u0006"));
            }
            ASN1InputStream aSN1InputStream = a;
            COn cOn2 = new COn(aSN1InputStream, aSN1InputStream.b);
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(cOn2, a.b);
            if ((n & 0x40) != 0) {
                return new BERApplicationSpecificParser(n2, aSN1StreamParser).getLoadedObject();
            }
            if ((n & 0x80) != 0) {
                return new BERTaggedObjectParser(true, n2, aSN1StreamParser).getLoadedObject();
            }
            switch (n2) {
                case 4: {
                    return new BEROctetStringParser(aSN1StreamParser).getLoadedObject();
                }
                case 16: {
                    return new BERSequenceParser(aSN1StreamParser).getLoadedObject();
                }
                case 17: {
                    return new BERSetParser(aSN1StreamParser).getLoadedObject();
                }
                case 8: {
                    return new DERExternalParser(aSN1StreamParser).getLoadedObject();
                }
            }
            throw new IOException(FileLoader.catch("dnh|qx\u000fP[Ml\u000fOSOQGA#wJVMF[PTRXH"));
        }
        try {
            return a.buildObject(n, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception(HussarException.continue("\"FL#3\u0006\u0015\r\u001bM\t\u0018\t.=\u0001[\u000e\u0018\t\u000f\u001a\u001a\u0010\u0006"), illegalArgumentException);
        }
    }

    protected int readLength() throws IOException {
        ASN1InputStream a;
        ASN1InputStream aSN1InputStream = a;
        return ASN1InputStream.boolean(aSN1InputStream, aSN1InputStream.b);
    }
}

