/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.auto.common.TypeHelper;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AUx;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CoN;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.Nul;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aUx;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.auX;
import com.jxdinfo.hussar.core.qr.QrImage;
import com.jxdinfo.hussar.core.util.CRC32Util;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    protected AUx multiplier;
    private static X9IntegerConverter L = new X9IntegerConverter();
    ECCurve G;
    ECFieldElement k;
    protected boolean withCompression;
    ECFieldElement boolean;
    protected aUx preCompInfo;

    public ECFieldElement getX() {
        ECPoint a;
        return a.boolean;
    }

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.boolean.equals(((ECPoint)a).boolean) && a2.k.equals(((ECPoint)a).k);
    }

    public boolean isInfinity() {
        ECPoint a;
        return a.boolean == null && a.k == null;
    }

    public ECCurve getCurve() {
        ECPoint a;
        return a.G;
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public abstract ECPoint twice();

    public abstract ECPoint negate();

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint add(ECPoint var1);

    public abstract byte[] getEncoded();

    public ECFieldElement getY() {
        ECPoint a;
        return a.k;
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(CRC32Util.default("\u0012f%(`0\nZ\tX\u001fR/e>m?%4~ h9joe2?$g4z;n,w"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.G.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.float();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.while(eCPoint2, a, eCPoint2.preCompInfo);
    }

    void catch(aUx a) {
        a.preCompInfo = a;
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.boolean.hashCode() ^ a.k.hashCode();
    }

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.G = a;
        eCPoint.boolean = a2;
        eCPoint.k = a3;
    }

    synchronized void float() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new auX();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.G, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(QrImage.else("t\u001c\u001bDMGL\u001eOLYD\u0015I\u0011]_\u0001Zixl{~$@WFPATJSN\u0019\u007f2\u0016\u0013KU"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.boolean, f2m.k);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.boolean, f2m2.G.getA());
                }
            }
            a5.withCompression = a4;
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        private static /* synthetic */ void for(ECPoint a, ECPoint a2) {
            if (!a.G.equals(a2.G)) {
                throw new IllegalArgumentException(TypeHelper.public("\u0010t!qj\u007f=~5jcu<x\u007fn\"jv`q8>>>mb#\u001e\u001e\u001eY\u0000\u000b3qws4q/k:0\n\u001d\u007f<1b*|2`)m"));
            }
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.for(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.boolean.equals(f2m)) {
                if (a2.k.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.G.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.k.add((ECFieldElement)object).divide(a2.boolean.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.boolean).add(f2m).add(a2.G.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.boolean.add(f2m)).add(f2m).add(a2.k);
            return new F2m(a2.G, f2m, (ECFieldElement)object, a2.withCompression);
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.for(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = L.getByteLength(a.boolean);
            byte[] byArray = L.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = L.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.boolean.toBigInteger().signum() == 0) {
                return a.G.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.boolean.add(f2m.k.divide(a.boolean));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.G.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.G.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.boolean.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.G, f2m3, eCFieldElement, a.withCompression);
        }

        @Override
        synchronized void float() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.G).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new CoN();
                    return;
                }
                a.multiplier = new Nul();
            }
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.boolean.equals(a.boolean)) {
                if (a2.k.equals(a.k)) {
                    return a2.twice();
                }
                return a2.G.getInfinity();
            }
            ECFieldElement eCFieldElement = a.k.subtract(a2.k).divide(a.boolean.subtract(a2.boolean));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.boolean).subtract(a.boolean);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.boolean.subtract(eCFieldElement2)).subtract(a2.k);
            return new Fp(a2.G, eCFieldElement2, eCFieldElement3);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(ECCurve.char("\u0003\u001e.Np\u0002>B$\u0019;K-K$\u0012'\u0005iKm#\u0003$I6\u0016\t(\u000f-\u00197W7T.+\u0019\u001f6"));
            }
            a5.withCompression = a4;
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = L.getByteLength(a.boolean);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = L.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = L.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = L.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.k.toBigInteger().signum() == 0) {
                return a.G.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.G.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.G.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.boolean.square().multiply(eCFieldElement2).add(a.G.k).divide(a.k.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.boolean.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.boolean.subtract(eCFieldElement2)).subtract(a.k);
            return new Fp(a.G, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        @Override
        synchronized void float() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new Nul();
            }
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.G, fp.boolean, a.k.negate(), a.withCompression);
        }
    }
}

