/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.Contact;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9ECParametersHolder;
import com.jxdinfo.hussar.core.bouncycastle.jce.ECGOST3410NamedCurveTable;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aux;
import com.jxdinfo.hussar.core.support.ObjectKit;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract int getFieldSize();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement sqrt();

    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement square();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement negate();

    public abstract String getFieldName();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        public static final int GNB = 1;
        public static final int PPB = 3;
        private aux a;
        private int J;
        private int I;
        private int L;
        private int G;
        private int k;
        private int return;
        public static final int TPB = 2;

        @Override
        public int getFieldSize() {
            F2m a;
            return a.L;
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.a.double();
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(Contact.package("u\u0004w(_mW)_ W(M/\u0003m\u0001\u000b1t\n1\u001a)[4Wm[%G7]\u0000r$Mm]\"\u001b\tp+{!W)w)_ W(MreiI"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.L != f2m2.L || f2m.k != f2m2.k || f2m.J != f2m2.J || f2m.I != f2m2.I) {
                throw new IllegalArgumentException(X9ECParametersHolder.goto("%]\u000eP\u0007\u0017\rA\u0017\u0010Gq4\u0018\u0014U\u0019_E_\u0001HC_\tW\u0000z.D\u001c\u001c\fSJI\nycF\u000bQ\u0006\u0014\rU\u0006[\f\r4\u0018\u0018"));
            }
            if (f2m.G != f2m2.G) {
                throw new IllegalArgumentException(Contact.package("]\u0005qN~'\u001e9Z!\u001b*Z\b~ \u001b(^ W(\\2J|B~\u0016N\u007fu\u0011e_'Q-Z#F8\u0014+]\u001d1(P.]6I)P\u001926^=@ I(\\2X(J4J"));
            }
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.return = a + 31 >> 5;
            F2m f2m = a6;
            a6.a = new aux(a5, a6.return);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.G = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(Contact.package("&\u0000fT)PxS\ft:\u0016([x\u0007$LfM)_2\u0003}Z"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(X9ECParametersHolder.goto("\\Z\r\u001f\bQk`\tQ\u0014\u0007\u0004HW\nEHD\u0007L\u001cG\b"));
                }
                a6.G = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(Contact.package("5\u00120X0ViS\rpt\u000b*N4\t$\u001e(\\&_(J`\f"));
            }
            F2m f2m2 = a6;
            a6.L = a;
            f2m2.k = a2;
            f2m2.J = a3;
            a6.I = a4;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(X9ECParametersHolder.goto("lp4K]Y\u001bF\u0010E\u0012E\u0000H\u0016"));
        }

        public int getK2() {
            F2m a;
            return a.J;
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.L == f2m.L && a2.k == f2m.k && a2.J == f2m.J && a2.I == f2m.I && a2.G == f2m.G && a2.a.equals(f2m.a);
        }

        public int hashCode() {
            F2m a;
            return a.a.hashCode() ^ a.L ^ a.k ^ a.J ^ a.I;
        }

        public int getM() {
            F2m a;
            return a.L;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            aux aux2 = f2m.a.return(f2m.L);
            int[] nArray = new int[3];
            nArray[0] = a.k;
            nArray[1] = a.J;
            nArray[2] = a.I;
            aux2.const(a.L, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.L, f2m2.k, f2m3.J, f2m3.I, aux2);
        }

        public int getRepresentation() {
            F2m a;
            return a.G;
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            aux aux2 = (aux)a.a.clone();
            aux aux3 = new aux(a.return);
            F2m f2m = a;
            aux aux4 = aux3;
            aux4.final(a.L);
            aux4.final(0);
            aux3.final(f2m.k);
            if (f2m.G == 3) {
                aux aux5 = aux3;
                aux5.final(a.J);
                aux5.final(a.I);
            }
            aux aux6 = new aux(a.return);
            aux6.final(0);
            aux aux7 = new aux(a.return);
            aux aux8 = aux2;
            while (!aux8.double()) {
                int n = aux2.return() - aux3.return();
                if (n < 0) {
                    aux aux9 = aux2;
                    aux2 = aux3;
                    aux3 = aux9;
                    aux aux10 = aux6;
                    aux6 = aux7;
                    aux7 = aux10;
                    n = -n;
                }
                int n2 = n >> 5;
                aux aux11 = aux3.transient(n &= 0x1F);
                aux aux12 = aux2;
                aux8 = aux12;
                aux12.package(aux11, n2);
                aux aux13 = aux7.transient(n);
                aux6.package(aux13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.L, f2m2.k, f2m3.J, f2m3.I, aux7);
        }

        public int getK1() {
            F2m a;
            return a.k;
        }

        public int getK3() {
            F2m a;
            return a.I;
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, aux a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.return = a + 31 >> 5;
            f2m3.a = a5;
            f2m2.L = a;
            f2m2.k = a2;
            f2m.J = a3;
            f2m.I = a4;
            if (a3 == 0 && a4 == 0) {
                a6.G = 2;
                return;
            }
            a6.G = 3;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            aux aux2 = (aux)a2.a.clone();
            F2m f2m = (F2m)a;
            aux2.package(f2m.a, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.L, f2m2.k, f2m3.J, f2m3.I, aux2);
        }

        @Override
        public String getFieldName() {
            return X9ECParametersHolder.goto("-\u000e\u000e");
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.a.const(((F2m)object).a, a2.L);
            int[] nArray = new int[3];
            nArray[0] = a2.k;
            nArray[1] = a2.J;
            nArray[2] = a2.I;
            ((aux)object).const(a2.L, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.L, f2m.k, f2m2.J, f2m2.I, (aux)object);
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger k;
        BigInteger return;

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.k, fp.return.negate().mod(a.k));
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.return = a2;
            if (a3.return.compareTo(a) >= 0) {
                throw new IllegalArgumentException(ObjectKit.byte("E^M\u0019R\btri1{wp>O\u0019qwt050t;z1,*0zS\u0018f?"));
            }
            a3.k = a;
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.k.bitLength();
        }

        public int hashCode() {
            Fp a;
            return a.k.hashCode() ^ a.return.hashCode();
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.k, fp.return.multiply(a.return).mod(a.k));
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.k, fp.return.modInverse(a.k));
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.k.equals(fp.k) && a2.return.equals(fp.return);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.k, fp.return.multiply(a.toBigInteger()).mod(a2.k));
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.k, fp.return.subtract(a.toBigInteger()).mod(a2.k));
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.k, fp.return.multiply(a.toBigInteger().modInverse(a2.k)).mod(a2.k));
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.k.testBit(0)) {
                throw new RuntimeException(ObjectKit.byte("s1buh 2z\u001e\u0004m?"));
            }
            if (a.k.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.k, fp.return.modPow(a.k.shiftRight(2).add(ECConstants.ONE), a.k));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.k.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.return.modPow(bigInteger2, a.k).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.return;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.k);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.k.bitLength(), random)).compareTo(a.k) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.k).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.int(a.k, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.k).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.k);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.k, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        public BigInteger getQ() {
            Fp a;
            return a.k;
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.return;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.k, fp.return.add(a.toBigInteger()).mod(a2.k));
        }

        private static /* synthetic */ BigInteger[] int(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public String getFieldName() {
            return ECGOST3410NamedCurveTable.abstract("I>");
        }
    }
}

