/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec;

import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.nist.NISTNamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.sec.SECNamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X962NamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9ECParameters;
import com.jxdinfo.hussar.core.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.jxdinfo.hussar.core.bouncycastle.crypto.params.ECDomainParameters;
import com.jxdinfo.hussar.core.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.jxdinfo.hussar.core.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.jxdinfo.hussar.core.bouncycastle.jce.interfaces.ECPrivateKey;
import com.jxdinfo.hussar.core.bouncycastle.jce.interfaces.ECPublicKey;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.JCEECPublicKey;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.ProviderUtil;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import com.jxdinfo.hussar.core.bouncycastle.jce.spec.ECParameterSpec;
import com.jxdinfo.hussar.core.cache.LRULinkedHashMap;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ECUtil {
    public static String static(String a) {
        int n;
        StackTraceElement stackTraceElement = new RuntimeException().getStackTrace()[1];
        String string = new StringBuffer(stackTraceElement.getMethodName()).append(stackTraceElement.getClassName()).toString();
        int n2 = a.length();
        int n3 = n2 - 1;
        char[] cArray = new char[n2];
        int n4 = 4 << 4 ^ 5 << 1;
        int cfr_ignored_0 = 1 << 3 ^ 3;
        int n5 = (2 ^ 5) << 4 ^ 3 << 1;
        int n6 = n = string.length() - 1;
        int n7 = n3;
        String string2 = string;
        while (n7 >= 0) {
            int n8 = n3--;
            cArray[n8] = (char)(n5 ^ (a.charAt(n8) ^ string2.charAt(n)));
            if (n3 < 0) break;
            int n9 = n3--;
            char c = cArray[n9] = (char)(n4 ^ (a.charAt(n9) ^ string2.charAt(n)));
            if (--n < 0) {
                n = n6;
            }
            n7 = n3;
        }
        return new String(cArray);
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey a) throws InvalidKeyException {
        if (a instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)a;
            ECParameterSpec eCParameterSpec = eCPublicKey.getParameters();
            if (eCParameterSpec == null) {
                eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
                return new ECPublicKeyParameters(((JCEECPublicKey)eCPublicKey).engineGetQ(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
            }
            return new ECPublicKeyParameters(eCPublicKey.getQ(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        if (a instanceof java.security.interfaces.ECPublicKey) {
            java.security.interfaces.ECPublicKey eCPublicKey = (java.security.interfaces.ECPublicKey)a;
            ECParameterSpec eCParameterSpec = EC5Util.convertSpec(eCPublicKey.getParams(), false);
            return new ECPublicKeyParameters(EC5Util.convertPoint(eCPublicKey.getParams(), eCPublicKey.getW(), false), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        throw new InvalidKeyException(LRULinkedHashMap.do("\u0018\u0010\u0004\u000e\u0003\u0012W\u0014\u0019\u0012^N\u0012\u0017\u0004Wuy{!(5'(\t@\u001c\u0018\u000bV"));
    }

    public static X9ECParameters getNamedCurveByOid(DERObjectIdentifier a) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(a);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByOID(a);
            if (x9ECParameters == null) {
                x9ECParameters = NISTNamedCurves.getByOID(a);
            }
            if (x9ECParameters == null) {
                x9ECParameters = TeleTrusTNamedCurves.getByOID(a);
            }
        }
        return x9ECParameters;
    }

    static int[] interface(int[] a) {
        int[] nArray = new int[3];
        if (a.length == 1) {
            nArray[0] = a[0];
            return nArray;
        }
        if (a.length != 3) {
            throw new IllegalArgumentException(LRULinkedHashMap.do("\u007fT\u0013\fM3\u0015\u0004\u001d\u0016\u001e\u0010\u001a\u001d\u0019@\r\b\u0013]\r\u0012^N\u001a\u001f\u0012\u001aY[7\"}$>1\u001a\u000f\u0005\t\u0017\u001c"));
        }
        if (a[0] < a[1] && a[0] < a[2]) {
            nArray[0] = a[0];
            if (a[1] < a[2]) {
                int[] nArray2 = nArray;
                nArray2[1] = a[1];
                nArray[2] = a[2];
                return nArray2;
            }
            nArray[1] = a[2];
            nArray[2] = a[1];
            return nArray;
        }
        if (a[1] < a[2]) {
            nArray[0] = a[1];
            if (a[0] < a[2]) {
                int[] nArray3 = nArray;
                nArray3[1] = a[0];
                nArray[2] = a[2];
                return nArray3;
            }
            nArray[1] = a[2];
            nArray[2] = a[0];
            return nArray;
        }
        nArray[0] = a[2];
        if (a[0] < a[1]) {
            int[] nArray4 = nArray;
            nArray4[1] = a[0];
            nArray[2] = a[1];
            return nArray4;
        }
        nArray[1] = a[1];
        nArray[2] = a[0];
        return nArray;
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey a) throws InvalidKeyException {
        if (a instanceof ECPrivateKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)a;
            ECParameterSpec eCParameterSpec = eCPrivateKey.getParameters();
            if (eCParameterSpec == null) {
                eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
            }
            return new ECPrivateKeyParameters(eCPrivateKey.getD(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        throw new InvalidKeyException(LRULinkedHashMap.do("\u0018\u0010\u0004G\u0018F\u001e\u0019\u0018\u0019DS\u001d\b]2s\u001a+#4!*5\u000f@\u001c\u0018\u000bV"));
    }

    public ECUtil() {
        ECUtil a;
    }

    public static DERObjectIdentifier getNamedCurveOid(String a) {
        DERObjectIdentifier dERObjectIdentifier = X962NamedCurves.getOID(a);
        if (dERObjectIdentifier == null) {
            dERObjectIdentifier = SECNamedCurves.getOID(a);
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = NISTNamedCurves.getOID(a);
            }
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = TeleTrusTNamedCurves.getOID(a);
            }
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = ECGOST3410NamedCurves.getOID(a);
            }
        }
        return dERObjectIdentifier;
    }

    public static String getCurveName(DERObjectIdentifier a) {
        String string = X962NamedCurves.getName(a);
        if (string == null) {
            string = SECNamedCurves.getName(a);
            if (string == null) {
                string = NISTNamedCurves.getName(a);
            }
            if (string == null) {
                string = TeleTrusTNamedCurves.getName(a);
            }
            if (string == null) {
                string = ECGOST3410NamedCurves.getName(a);
            }
        }
        return string;
    }
}

