/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1.x509;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Encodable;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1EncodableVector;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Sequence;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1TaggedObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEREncodable;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERNull;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERSequence;
import com.jxdinfo.hussar.core.cache.CacheEntry;
import com.jxdinfo.hussar.core.qr.QrImage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlgorithmIdentifier
extends ASN1Encodable {
    private boolean G;
    private DEREncodable k;
    private DERObjectIdentifier else;

    public ASN1ObjectIdentifier getAlgorithm() {
        AlgorithmIdentifier a;
        return new ASN1ObjectIdentifier(a.else.getId());
    }

    public static AlgorithmIdentifier getInstance(Object a) {
        if (a == null || a instanceof AlgorithmIdentifier) {
            return (AlgorithmIdentifier)a;
        }
        if (a instanceof DERObjectIdentifier) {
            return new AlgorithmIdentifier((DERObjectIdentifier)a);
        }
        if (a instanceof String) {
            return new AlgorithmIdentifier((String)a);
        }
        if (a instanceof ASN1Sequence) {
            return new AlgorithmIdentifier((ASN1Sequence)a);
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, CacheEntry.volatile("\u0014}\u0017a\u000f}\u000b\u000e.a\u0006g\u000e}Fz\u0012.\u0007`\rz\u000ep\u0014/Z")).append(a.getClass().getName()).toString());
    }

    public DEREncodable getParameters() {
        AlgorithmIdentifier a;
        return a.k;
    }

    public AlgorithmIdentifier(String a) {
        AlgorithmIdentifier a2;
        a2.G = false;
        AlgorithmIdentifier algorithmIdentifier = a2;
        a2.else = new DERObjectIdentifier(a);
    }

    public DERObjectIdentifier getObjectId() {
        AlgorithmIdentifier a;
        return a.else;
    }

    public AlgorithmIdentifier(DERObjectIdentifier a) {
        AlgorithmIdentifier a2;
        AlgorithmIdentifier algorithmIdentifier = a2;
        algorithmIdentifier.G = false;
        algorithmIdentifier.else = a;
    }

    public static AlgorithmIdentifier getInstance(ASN1TaggedObject a, boolean a2) {
        return AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(a, a2));
    }

    @Override
    public DERObject toASN1Object() {
        AlgorithmIdentifier a;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        AlgorithmIdentifier algorithmIdentifier = a;
        aSN1EncodableVector.add(algorithmIdentifier.else);
        if (algorithmIdentifier.G) {
            if (a.k != null) {
                aSN1EncodableVector.add(a.k);
            } else {
                aSN1EncodableVector.add(DERNull.INSTANCE);
            }
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public AlgorithmIdentifier(DERObjectIdentifier a, DEREncodable a2) {
        AlgorithmIdentifier a3;
        AlgorithmIdentifier algorithmIdentifier = a3;
        AlgorithmIdentifier algorithmIdentifier2 = a3;
        algorithmIdentifier2.G = false;
        algorithmIdentifier2.G = true;
        algorithmIdentifier.else = a;
        algorithmIdentifier.k = a2;
    }

    public AlgorithmIdentifier(ASN1Sequence a) {
        AlgorithmIdentifier a2;
        a2.G = false;
        if (a.size() < 1 || a.size() > 2) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, QrImage.else("_OT\u000fBAKKEM^I\u0012PTUT\u0002\u0006")).append(a.size()).toString());
        }
        a2.else = DERObjectIdentifier.getInstance(a.getObjectAt(0));
        if (a.size() == 2) {
            AlgorithmIdentifier algorithmIdentifier = a2;
            algorithmIdentifier.G = true;
            algorithmIdentifier.k = a.getObjectAt(1);
            return;
        }
        a2.k = null;
    }
}

