/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Object;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1OctetString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1TaggedObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEROutputStream;
import com.jxdinfo.hussar.core.feign.TicketRequestBody;
import com.jxdinfo.hussar.core.util.ResKit;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DERBoolean
extends ASN1Object {
    byte char;
    public static final DERBoolean TRUE;
    public static final DERBoolean FALSE;

    @Override
    protected boolean asn1Equals(DERObject a) {
        DERBoolean a2;
        if (a == null || !(a instanceof DERBoolean)) {
            return false;
        }
        return a2.char == ((DERBoolean)a).char;
    }

    public static DERBoolean getInstance(boolean a) {
        if (a) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    void encode(DEROutputStream a) throws IOException {
        DERBoolean a2;
        byte[] byArray = new byte[]{a2.char};
        a.short(1, byArray);
    }

    public static DERBoolean getInstance(ASN1TaggedObject a, boolean a2) {
        DERObject dERObject = a.getObject();
        if (a2 || dERObject instanceof DERBoolean) {
            return DERBoolean.getInstance(dERObject);
        }
        return new DERBoolean(((ASN1OctetString)dERObject).getOctets());
    }

    public boolean isTrue() {
        DERBoolean a;
        return a.char != 0;
    }

    public DERBoolean(byte[] a) {
        DERBoolean a2;
        if (a.length != 1) {
            throw new IllegalArgumentException(TicketRequestBody.new("\u0013 \fw\u0013+\u001d#\u001b7S~D}F\u0014=Y0\u000f9\u001b\u007fbR1\u000b$\u0014y\u00113\\;\u0007"));
        }
        a2.char = a[0];
    }

    static {
        FALSE = new DERBoolean(false);
        TRUE = new DERBoolean(true);
    }

    public String toString() {
        DERBoolean a;
        if (a.char != 0) {
            return ResKit.enum("&\u0016.\b");
        }
        return TicketRequestBody.new(">\u001c0\u00016");
    }

    @Override
    public int hashCode() {
        DERBoolean a;
        return a.char;
    }

    public static DERBoolean getInstance(Object a) {
        if (a == null || a instanceof DERBoolean) {
            return (DERBoolean)a;
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, ResKit.enum(",\u001c*\u001c(\u001c'R+\u0019'\u001c,\u001c~<\rR#\n-!0\u000e?\u0013*\u001c,Co")).append(a.getClass().getName()).toString());
    }

    public DERBoolean(boolean a) {
        DERBoolean a2;
        a2.char = (byte)(a ? -1 : 0);
    }
}

