/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Boolean;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1EncodableVector;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Enumerated;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Exception;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1GeneralizedTime;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Integer;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1StreamParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1UTCTime;
import com.jxdinfo.hussar.core.bouncycastle.asn1.AUx;
import com.jxdinfo.hussar.core.bouncycastle.asn1.AuX;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERApplicationSpecificParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERConstructedOctetString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BEROctetStringParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERSequenceParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERSetParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERTaggedObjectParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.COn;
import com.jxdinfo.hussar.core.bouncycastle.asn1.CoN;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERApplicationSpecific;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERBMPString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERBitString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERExternal;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERExternalParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERGeneralString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERIA5String;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERNull;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERNumericString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEROctetString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERPrintableString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERT61String;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERTags;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERUTF8String;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERUniversalString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERUnknownTag;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERVisibleString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.LazyDERSequence;
import com.jxdinfo.hussar.core.bouncycastle.util.io.Streams;
import com.jxdinfo.hussar.core.cache.CacheEntry;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ASN1InputStream
extends FilterInputStream
implements DERTags {
    private final boolean k;
    private final int public;

    public ASN1InputStream(InputStream a, int a2, boolean a3) {
        ASN1InputStream a4;
        ASN1InputStream aSN1InputStream = a4;
        super(a);
        aSN1InputStream.public = a2;
        aSN1InputStream.k = a3;
    }

    ASN1EncodableVector switch(COn a) throws IOException {
        return new ASN1InputStream(a).interface();
    }

    protected int readLength() throws IOException {
        ASN1InputStream a;
        ASN1InputStream aSN1InputStream = a;
        return ASN1InputStream.interface(aSN1InputStream, aSN1InputStream.public);
    }

    public DERObject readObject() throws IOException {
        ASN1InputStream a;
        int n = a.read();
        if (n <= 0) {
            if (n == 0) {
                throw new IOException(CacheEntry.volatile("L'C^9Q8]#2\u0019K/mKx\u001e?\u001e|\u0012@>}\bfZo\ft\u0002o\u0017"));
            }
            return null;
        }
        int n2 = ASN1InputStream.short(a, n);
        boolean bl = (n & 0x20) != 0;
        int n3 = a.readLength();
        if (n3 < 0) {
            if (!bl) {
                throw new IOException(ToolUtil.else("mLx_sZ0\u0011eR#I{V&\u00136XAeJhWl(\u0011\\?{VcIaJjE\u0003`jAmQ{GtEx_"));
            }
            ASN1InputStream aSN1InputStream = a;
            AuX auX2 = new AuX(aSN1InputStream, aSN1InputStream.public);
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(auX2, a.public);
            if ((n & 0x40) != 0) {
                return new BERApplicationSpecificParser(n2, aSN1StreamParser).getLoadedObject();
            }
            if ((n & 0x80) != 0) {
                return new BERTaggedObjectParser(true, n2, aSN1StreamParser).getLoadedObject();
            }
            switch (n2) {
                case 4: {
                    return new BEROctetStringParser(aSN1StreamParser).getLoadedObject();
                }
                case 16: {
                    return new BERSequenceParser(aSN1StreamParser).getLoadedObject();
                }
                case 17: {
                    return new BERSetParser(aSN1StreamParser).getLoadedObject();
                }
                case 8: {
                    return new DERExternalParser(aSN1StreamParser).getLoadedObject();
                }
            }
            throw new IOException(CacheEntry.volatile("S'_5F18\u0019l\u0004[Fx\u001ax\u0018p\b\u0014>}\u001fz\u000fl\u0019c\u001bo\u0001"));
        }
        try {
            return a.buildObject(n, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception(ToolUtil.else("{.\u0015KjnLeB%PpPFdi\u0002fAaVrCx_"), illegalArgumentException);
        }
    }

    static int extends(InputStream a) {
        if (a instanceof AUx) {
            return ((AUx)a).long();
        }
        if (a instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)a).available();
        }
        return Integer.MAX_VALUE;
    }

    protected DERObject buildObject(int a, int a2, int a32) throws IOException {
        ASN1InputStream a4;
        boolean bl = (a & 0x20) != 0;
        COn a32 = new COn(a4, a32);
        if ((a & 0x40) != 0) {
            return new DERApplicationSpecific(bl, a2, a32.static());
        }
        if ((a & 0x80) != 0) {
            return new ASN1StreamParser(a32).void(bl, a2);
        }
        if (bl) {
            switch (a2) {
                case 4: {
                    return new BERConstructedOctetString(a4.switch((COn)a32).transient);
                }
                case 16: {
                    while (false) {
                    }
                    if (a4.k) {
                        return new LazyDERSequence(a32.static());
                    }
                    return CoN.case(a4.switch(a32));
                }
                case 17: {
                    return CoN.public(a4.switch(a32), false);
                }
                case 8: {
                    return new DERExternal(a4.switch(a32));
                }
            }
            return new DERUnknownTag(true, a2, a32.static());
        }
        return ASN1InputStream.static(a2, a32.static());
    }

    static int short(InputStream a, int a2) throws IOException {
        if ((a2 &= 0x1F) == 31) {
            a2 = 0;
            int n = a.read();
            if ((n & 0x7F) == 0) {
                throw new IOException(CacheEntry.volatile("p\u0013y\u0016w\u001d=CbIg\u000f{\u00037Ti\u000b\u0006 Z-H*?]\u000e)`\u0001\u007fXf\u001ct\\Z.~\u001ep\b\"\u000bi\u001cd\u0001"));
            }
            int n2 = n;
            while (n2 >= 0 && (n & 0x80) != 0) {
                a2 |= n & 0x7F;
                a2 <<= 7;
                n2 = a.read();
            }
            if (n < 0) {
                throw new EOFException(ToolUtil.else("@q^a\u0001Vjp\\ OkPmFF%pCe\u0004cR}Bx\u0015"));
            }
            a2 |= n & 0x7F;
        }
        return a2;
    }

    protected void readFully(byte[] a) throws IOException {
        ASN1InputStream a2;
        if (Streams.readFully(a2, a) != a.length) {
            throw new EOFException(ToolUtil.else("}\u000e!~\u001d_tLpPl$\u0015\\{>Qn\u0006hJ`FO`$Md\u0004zQ{R~O"));
        }
    }

    public ASN1InputStream(InputStream a) {
        ASN1InputStream a2;
        InputStream inputStream = a;
        a2(inputStream, ASN1InputStream.extends(inputStream));
    }

    /*
     * Enabled aggressive block sorting
     */
    static DERObject static(int a, byte[] a2) {
        switch (a) {
            case 3: {
                return DERBitString.new(a2);
            }
            case 30: {
                return new DERBMPString(a2);
            }
            case 1: {
                return new ASN1Boolean(a2);
            }
            case 10: {
                return new ASN1Enumerated(a2);
            }
            case 24: {
                return new ASN1GeneralizedTime(a2);
            }
            case 27: {
                return new DERGeneralString(a2);
            }
            case 22: {
                return new DERIA5String(a2);
            }
            case 2: {
                return new ASN1Integer(a2);
            }
            case 5: {
                return DERNull.INSTANCE;
            }
            case 18: {
                return new DERNumericString(a2);
            }
            case 6: {
                return new ASN1ObjectIdentifier(a2);
            }
            case 4: {
                return new DEROctetString(a2);
            }
            case 19: {
                return new DERPrintableString(a2);
            }
            case 20: {
                return new DERT61String(a2);
            }
            case 28: {
                return new DERUniversalString(a2);
            }
            case 23: {
                return new ASN1UTCTime(a2);
            }
            case 12: {
                return new DERUTF8String(a2);
            }
            case 26: {
                return new DERVisibleString(a2);
            }
        }
        return new DERUnknownTag(false, a, a2);
    }

    public ASN1InputStream(byte[] a) {
        a2(new ByteArrayInputStream(a), a.length);
        ASN1InputStream a2;
    }

    public ASN1InputStream(byte[] a, boolean a2) {
        a3(new ByteArrayInputStream(a), a.length, a2);
        ASN1InputStream a3;
    }

    static int interface(InputStream a, int a2) throws IOException {
        int n = a.read();
        if (n < 0) {
            throw new EOFException(CacheEntry.volatile("c\u0006r{O)#WJa~\u000er\u00162\u0011v\u0012S/{\\p\u0002r\be\u001do\u0001"));
        }
        if (n == 128) {
            return -1;
        }
        if (n > 127) {
            int n2;
            int n3 = n & 0x7F;
            if (n3 > 4) {
                throw new IOException(new StringBuilder().insert(0, ToolUtil.else("uRq%R}/\u0000Mw>UoT`\u0003pJBk$\u0016\"FlGtD'\u001b")).append(n3).toString());
            }
            n = 0;
            int n4 = n2 = 0;
            while (n4 < n3) {
                int n5 = a.read();
                if (n5 < 0) {
                    throw new EOFException(CacheEntry.volatile("\u0013vhao\tb\u0016v]a\u0019U?z\u0012rZn\bh\u000e~\r"));
                }
                n = (n << 8) + n5;
                n4 = ++n2;
            }
            if (n < 0) {
                throw new IOException(ToolUtil.else("rXqWkH5\u0002:XBcQ`_uaJ\u0019q{_aRlUa\u0002O`jEvL5U~Bs_"));
            }
            if (n >= a2) {
                throw new IOException(CacheEntry.volatile("\u0007m\u001f;Sv\u001dq\u001f)\u0015\"K,GKi\u0019{F3\"\u0019A')\u0004x\r|\u0019`\\X>}\u001ba\u0012\"\u000bi\u001cd\u0001"));
            }
        }
        return n;
    }

    ASN1EncodableVector interface() throws IOException {
        DERObject dERObject;
        ASN1InputStream a;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1InputStream aSN1InputStream = a;
        while ((dERObject = aSN1InputStream.readObject()) != null) {
            aSN1InputStream = a;
            aSN1EncodableVector.add(dERObject);
        }
        return aSN1EncodableVector;
    }

    public ASN1InputStream(InputStream a, int a2) {
        a3(a, a2, false);
        ASN1InputStream a3;
    }
}

