/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.auto.common.MultiSetMap;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CoN;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.NUl;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.NuL;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.auX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.con;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.support.ClassKit;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    ECFieldElement M;
    protected CoN preCompInfo;
    ECFieldElement G;
    ECCurve d;
    protected con multiplier;
    protected boolean withCompression;
    private static X9IntegerConverter interface = new X9IntegerConverter();

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.M.equals(((ECPoint)a).M) && a2.G.equals(((ECPoint)a).G);
    }

    public abstract ECPoint twice();

    public boolean isInfinity() {
        ECPoint a;
        return a.M == null && a.G == null;
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.M.hashCode() ^ a.G.hashCode();
    }

    public ECCurve getCurve() {
        ECPoint a;
        return a.d;
    }

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.d = a;
        eCPoint.M = a2;
        eCPoint.G = a3;
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public abstract ECPoint subtract(ECPoint var1);

    public ECFieldElement getX() {
        ECPoint a;
        return a.M;
    }

    synchronized void final() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new auX();
        }
    }

    public ECFieldElement getY() {
        ECPoint a;
        return a.G;
    }

    void interface(CoN a) {
        a.preCompInfo = a;
    }

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint negate();

    public abstract byte[] getEncoded();

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(HussarException.void("]+je/}E\u0017F\u0015P\u001f`(q ph{3o%v' (}rk*{7t#c:"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.d.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.final();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.case(eCPoint2, a, eCPoint2.preCompInfo);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.void(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.void(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.M.equals(f2m)) {
                if (a2.G.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.d.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.G.add((ECFieldElement)object).divide(a2.M.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.M).add(f2m).add(a2.d.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.M.add(f2m)).add(f2m).add(a2.G);
            return new F2m(a2.d, f2m, (ECFieldElement)object, a2.withCompression);
        }

        @Override
        synchronized void final() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.d).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new NuL();
                    return;
                }
                a.multiplier = new NUl();
            }
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.M.toBigInteger().signum() == 0) {
                return a.d.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.M.add(f2m.G.divide(a.M));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.d.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.d.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.M.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.d, f2m3, eCFieldElement, a.withCompression);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(MultiSetMap.false("PE?\u001di\u001ehGk\u0015}\u001d1\u00105\u0004{X~0\\5_'\u0000\u0019s\u001ft\u0018p\u0013w\u0017=&\u0016O7\u0012q"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.M, f2m.G);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.M, f2m2.d.getA());
                }
            }
            a5.withCompression = a4;
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        private static /* synthetic */ void void(ECPoint a, ECPoint a2) {
            if (!a.d.equals(a2.d)) {
                throw new IllegalArgumentException(ClassKit.return("(V\fFXW\u001eGT\u0011\n\u0006\u001aD@K\u0014F\u001a\u0016\u0010C\u0012\bY\u0010#x2('z\u0015\u0004\u001fGZD\u0004[U\u000brbTY\nS\u0000I\tE\u001eV\u0015K"));
            }
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = interface.getByteLength(a.M);
            byte[] byArray = interface.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = interface.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.d, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = interface.getByteLength(a.M);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = interface.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = interface.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = interface.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.d, fp.M, a.G.negate(), a.withCompression);
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.M.equals(a.M)) {
                if (a2.G.equals(a.G)) {
                    return a2.twice();
                }
                return a2.d.getInfinity();
            }
            ECFieldElement eCFieldElement = a.G.subtract(a2.G).divide(a.M.subtract(a2.M));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.M).subtract(a.M);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.M.subtract(eCFieldElement2)).subtract(a2.G);
            return new Fp(a2.d, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.G.toBigInteger().signum() == 0) {
                return a.d.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.d.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.d.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.M.square().multiply(eCFieldElement2).add(a.d.super).divide(a.G.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.M.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.M.subtract(eCFieldElement2)).subtract(a.G);
            return new Fp(a.d, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(ECNamedCurveSpec.synchronized("_ir9,ub5xng<q<xe{r5<1T_S\u0015AJ~txqnk k#r\\Ehj"));
            }
            a5.withCompression = a4;
        }

        @Override
        synchronized void final() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new NUl();
            }
        }
    }
}

