/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.asn1.OIDTokenizer;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nul;
import com.jxdinfo.hussar.core.support.PageKit;
import com.jxdinfo.hussar.core.util.ResKit;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract String getFieldName();

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement invert();

    public ECFieldElement() {
        ECFieldElement a;
    }

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement negate();

    public abstract ECFieldElement sqrt();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement square();

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract int getFieldSize();

    public abstract ECFieldElement add(ECFieldElement var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private int B;
        private int g;
        private int I;
        public static final int GNB = 1;
        public static final int PPB = 3;
        private int M;
        private nul G;
        public static final int TPB = 2;
        private int d;
        private int super;

        @Override
        public int getFieldSize() {
            F2m a;
            return a.I;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.G.static(((F2m)object).G, a2.I);
            int[] nArray = new int[3];
            nArray[0] = a2.g;
            nArray[1] = a2.B;
            nArray[2] = a2.super;
            ((nul)object).try(a2.I, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.I, f2m.g, f2m2.B, f2m2.super, (nul)object);
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            nul nul2 = (nul)a2.G.clone();
            F2m f2m = (F2m)a;
            nul2.assert(f2m.G, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.I, f2m2.g, f2m3.B, f2m3.super, nul2);
        }

        @Override
        public String getFieldName() {
            return ResKit.static("wuT");
        }

        public int getK3() {
            F2m a;
            return a.super;
        }

        public int getM() {
            F2m a;
            return a.I;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(ResKit.static("6\u000bn0\u0007\"A=J>H>Z3L"));
        }

        public int getK2() {
            F2m a;
            return a.B;
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            nul nul2 = (nul)a.G.clone();
            nul nul3 = new nul(a.M);
            F2m f2m = a;
            nul nul4 = nul3;
            nul4.float(a.I);
            nul4.float(0);
            nul3.float(f2m.g);
            if (f2m.d == 3) {
                nul nul5 = nul3;
                nul5.float(a.B);
                nul5.float(a.super);
            }
            nul nul6 = new nul(a.M);
            nul6.float(0);
            nul nul7 = new nul(a.M);
            nul nul8 = nul2;
            while (!nul8.float()) {
                int n = nul2.boolean() - nul3.boolean();
                if (n < 0) {
                    nul nul9 = nul2;
                    nul2 = nul3;
                    nul3 = nul9;
                    nul nul10 = nul6;
                    nul6 = nul7;
                    nul7 = nul10;
                    n = -n;
                }
                int n2 = n >> 5;
                nul nul11 = nul3.this(n &= 0x1F);
                nul nul12 = nul2;
                nul8 = nul12;
                nul12.assert(nul11, n2);
                nul nul13 = nul7.this(n);
                nul6.assert(nul13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.I, f2m2.g, f2m3.B, f2m3.super, nul7);
        }

        public int getRepresentation() {
            F2m a;
            return a.d;
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.M = a + 31 >> 5;
            F2m f2m = a6;
            a6.G = new nul(a5, a6.M);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.d = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(ResKit.static(",\u000bl_#[rX\u0006\u007f0\u001d\"Pr\f.GlF#T8\bwQ"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(ResKit.static("'\u0000vEs\u000b\u0010:r\u000bo]\u007f\u0012,P>\u0012?]7F<R"));
                }
                a6.d = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(ResKit.static("?\u0019:S:]cX\u0007{~\u0000 E>\u0002.\u0015\"W,T\"Aj\u0007"));
            }
            F2m f2m2 = a6;
            a6.I = a;
            f2m2.g = a2;
            f2m2.B = a3;
            a6.super = a4;
        }

        public int hashCode() {
            F2m a;
            return a.G.hashCode() ^ a.I ^ a.g ^ a.B ^ a.super;
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.I == f2m.I && a2.g == f2m.g && a2.B == f2m.B && a2.super == f2m.super && a2.d == f2m.d && a2.G.equals(f2m.G);
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, nul a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.M = a + 31 >> 5;
            f2m3.G = a5;
            f2m2.I = a;
            f2m2.g = a2;
            f2m.B = a3;
            f2m.super = a4;
            if (a3 == 0 && a4 == 0) {
                a6.d = 2;
                return;
            }
            a6.d = 3;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            nul nul2 = f2m.G.char(f2m.I);
            int[] nArray = new int[3];
            nArray[0] = a.g;
            nArray[1] = a.B;
            nArray[2] = a.super;
            nul2.try(a.I, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.I, f2m2.g, f2m3.B, f2m3.super, nul2);
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(ResKit.static("~\u000e|\"Tg\\#T*\\\"F%\bg\n\u0001:~\u0001;\u0011#P>\\gP/L=V\ny.FgV(\u0010\u0003{!p+\\#|#T*\\\"FxncB"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.I != f2m2.I || f2m.g != f2m2.g || f2m.B != f2m2.B || f2m.super != f2m2.super) {
                throw new IllegalArgumentException(ResKit.static("\u007f&T+]lW:Mk\u001d\nncN.C$\u001f$[3\u0019$S,Z\u0001t?FgV(\u00102P\u00029=Q*\\oW.\\ VvncB"));
            }
            if (f2m.d != f2m2.d) {
                throw new IllegalArgumentException(ResKit.static("V\u000fzDu-\u00153Q+\u0010 Q\u0002u*\u0010\"U*\\\"W8AvIt\u001dDt\u007f\u001aoT-Z'Q)M2\u001f!V\u0017:\"[$V<B#[\u00139<U7K*B\"W8S\"A>A"));
            }
        }

        public int getK1() {
            F2m a;
            return a.g;
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.G.null();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger d;
        BigInteger native;

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.native;
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.d.equals(fp.d) && a2.native.equals(fp.native);
        }

        private static /* synthetic */ BigInteger[] boolean(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.d.testBit(0)) {
                throw new RuntimeException(OIDTokenizer.this("\u00112\u0000v\n#Py|\u0007\u000f<"));
            }
            if (a.d.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.d, fp.native.modPow(a.d.shiftRight(2).add(ECConstants.ONE), a.d));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.d.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.native.modPow(bigInteger2, a.d).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.native;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.d);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.d.bitLength(), random)).compareTo(a.d) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.d).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.boolean(a.d, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.d).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.d);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.d, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.d, fp.native.subtract(a.toBigInteger()).mod(a2.d));
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.d, fp.native.add(a.toBigInteger()).mod(a2.d));
        }

        @Override
        public String getFieldName() {
            return PageKit.strictfp(" o");
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.d, fp.native.multiply(a.native).mod(a.d));
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.d, fp.native.multiply(a.toBigInteger().modInverse(a2.d)).mod(a2.d));
        }

        /*
         * WARNING - void declaration
         */
        public Fp(BigInteger bigInteger, BigInteger bigInteger2) {
            void a;
            void a2;
            Fp a3;
            a3.native = a2;
            if (a3.native.compareTo((BigInteger)a) >= 0) {
                throw new IllegalArgumentException(OIDTokenizer.this("']/\u001a0\u000b\u0016q\u000b2\u0019t\u0012=-\u001a\u0013t\u00163W3\u00168\u00182N)Ry1\u001b\u0004<"));
            }
            a3.d = a;
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.d, fp.native.modInverse(a.d));
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.d.bitLength();
        }

        public int hashCode() {
            Fp a;
            return a.d.hashCode() ^ a.native.hashCode();
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.d, fp.native.multiply(a.toBigInteger()).mod(a2.d));
        }

        public BigInteger getQ() {
            Fp a;
            return a.d;
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.d, fp.native.negate().mod(a.d));
        }
    }
}

