/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec;

import com.jxdinfo.hussar.core.auto.common.Sets;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.nist.NISTNamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.sec.SECNamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X962NamedCurves;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9ECParameters;
import com.jxdinfo.hussar.core.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.jxdinfo.hussar.core.bouncycastle.crypto.params.ECDomainParameters;
import com.jxdinfo.hussar.core.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.jxdinfo.hussar.core.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.jxdinfo.hussar.core.bouncycastle.jce.interfaces.ECPrivateKey;
import com.jxdinfo.hussar.core.bouncycastle.jce.interfaces.ECPublicKey;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.JCEECPublicKey;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.ProviderUtil;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import com.jxdinfo.hussar.core.bouncycastle.jce.spec.ECParameterSpec;
import com.jxdinfo.hussar.core.support.exception.ToolBoxException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ECUtil {
    public ECUtil() {
        ECUtil a;
    }

    static int[] finally(int[] a) {
        int[] nArray = new int[3];
        if (a.length == 1) {
            nArray[0] = a[0];
            return nArray;
        }
        if (a.length != 3) {
            throw new IllegalArgumentException(Sets.null("k/\u0007wYH\u0001\u007f\tm\nk\u000ef\r;\u0019s\u0007&\u0019iJ5\u000ed\u0006aM #Yi_*J\u000et\u0011r\u0003g"));
        }
        if (a[0] < a[1] && a[0] < a[2]) {
            nArray[0] = a[0];
            if (a[1] < a[2]) {
                int[] nArray2 = nArray;
                nArray2[1] = a[1];
                nArray[2] = a[2];
                return nArray2;
            }
            nArray[1] = a[2];
            nArray[2] = a[1];
            return nArray;
        }
        if (a[1] < a[2]) {
            nArray[0] = a[1];
            if (a[0] < a[2]) {
                int[] nArray3 = nArray;
                nArray3[1] = a[0];
                nArray[2] = a[2];
                return nArray3;
            }
            nArray[1] = a[2];
            nArray[2] = a[0];
            return nArray;
        }
        nArray[0] = a[2];
        if (a[0] < a[1]) {
            int[] nArray4 = nArray;
            nArray4[1] = a[0];
            nArray[2] = a[1];
            return nArray4;
        }
        nArray[1] = a[1];
        nArray[2] = a[0];
        return nArray;
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey a) throws InvalidKeyException {
        if (a instanceof ECPrivateKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)a;
            ECParameterSpec eCParameterSpec = eCPrivateKey.getParameters();
            if (eCParameterSpec == null) {
                eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
            }
            return new ECPrivateKeyParameters(eCPrivateKey.getD(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        throw new InvalidKeyException(Sets.null("\fk\u0010<\f=\nb\fbP(\tsIIga?X Z>N\u001b;\bc\u001f-"));
    }

    public static DERObjectIdentifier getNamedCurveOid(String a) {
        DERObjectIdentifier dERObjectIdentifier = X962NamedCurves.getOID(a);
        if (dERObjectIdentifier == null) {
            dERObjectIdentifier = SECNamedCurves.getOID(a);
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = NISTNamedCurves.getOID(a);
            }
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = TeleTrusTNamedCurves.getOID(a);
            }
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = ECGOST3410NamedCurves.getOID(a);
            }
        }
        return dERObjectIdentifier;
    }

    public static String getCurveName(DERObjectIdentifier a) {
        String string = X962NamedCurves.getName(a);
        if (string == null) {
            string = SECNamedCurves.getName(a);
            if (string == null) {
                string = NISTNamedCurves.getName(a);
            }
            if (string == null) {
                string = TeleTrusTNamedCurves.getName(a);
            }
            if (string == null) {
                string = ECGOST3410NamedCurves.getName(a);
            }
        }
        return string;
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey a) throws InvalidKeyException {
        if (a instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)a;
            ECParameterSpec eCParameterSpec = eCPublicKey.getParameters();
            if (eCParameterSpec == null) {
                eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
                return new ECPublicKeyParameters(((JCEECPublicKey)eCPublicKey).engineGetQ(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
            }
            return new ECPublicKeyParameters(eCPublicKey.getQ(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        if (a instanceof java.security.interfaces.ECPublicKey) {
            java.security.interfaces.ECPublicKey eCPublicKey = (java.security.interfaces.ECPublicKey)a;
            ECParameterSpec eCParameterSpec = EC5Util.convertSpec(eCPublicKey.getParams(), false);
            return new ECPublicKeyParameters(EC5Util.convertPoint(eCPublicKey.getParams(), eCPublicKey.getW(), false), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        throw new InvalidKeyException(ToolBoxException.private("-l1r6nbh,nk2'k1+@\u0005N]\u001dI\u0012T<<)d>*"));
    }

    public static X9ECParameters getNamedCurveByOid(DERObjectIdentifier a) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(a);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByOID(a);
            if (x9ECParameters == null) {
                x9ECParameters = NISTNamedCurves.getByOID(a);
            }
            if (x9ECParameters == null) {
                x9ECParameters = TeleTrusTNamedCurves.getByOID(a);
            }
        }
        return x9ECParameters;
    }
}

