/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1.x509;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Encodable;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1EncodableVector;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Sequence;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1TaggedObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEREncodable;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERNull;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERSequence;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import com.jxdinfo.hussar.core.util.Checker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlgorithmIdentifier
extends ASN1Encodable {
    private DERObjectIdentifier G;
    private boolean d;
    private DEREncodable short;

    public DEREncodable getParameters() {
        AlgorithmIdentifier a;
        return a.short;
    }

    public AlgorithmIdentifier(ASN1Sequence a) {
        AlgorithmIdentifier a2;
        a2.d = false;
        if (a.size() < 1 || a.size() > 2) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, Checker.const("\"\u0014)T?\u001a6\u00108\u0016#\u0012o\u000b)\u000e)Y{")).append(a.size()).toString());
        }
        a2.G = DERObjectIdentifier.getInstance(a.getObjectAt(0));
        if (a.size() == 2) {
            AlgorithmIdentifier algorithmIdentifier = a2;
            algorithmIdentifier.d = true;
            algorithmIdentifier.short = a.getObjectAt(1);
            return;
        }
        a2.short = null;
    }

    public static AlgorithmIdentifier getInstance(Object a) {
        if (a == null || a instanceof AlgorithmIdentifier) {
            return (AlgorithmIdentifier)a;
        }
        if (a instanceof DERObjectIdentifier) {
            return new AlgorithmIdentifier((DERObjectIdentifier)a);
        }
        if (a instanceof String) {
            return new AlgorithmIdentifier((String)a);
        }
        if (a instanceof ASN1Sequence) {
            return new AlgorithmIdentifier((ASN1Sequence)a);
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, EC5Util.instanceof("\n]\u0018J\u000bF\u001f\u0013\u001c@\bz<LXL\u000b\u0002\u0004V\u0014L\u0017G\f\tS")).append(a.getClass().getName()).toString());
    }

    public DERObjectIdentifier getObjectId() {
        AlgorithmIdentifier a;
        return a.G;
    }

    @Override
    public DERObject toASN1Object() {
        AlgorithmIdentifier a;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        AlgorithmIdentifier algorithmIdentifier = a;
        aSN1EncodableVector.add(algorithmIdentifier.G);
        if (algorithmIdentifier.d) {
            if (a.short != null) {
                aSN1EncodableVector.add(a.short);
            } else {
                aSN1EncodableVector.add(DERNull.INSTANCE);
            }
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public static AlgorithmIdentifier getInstance(ASN1TaggedObject a, boolean a2) {
        return AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(a, a2));
    }

    public ASN1ObjectIdentifier getAlgorithm() {
        AlgorithmIdentifier a;
        return new ASN1ObjectIdentifier(a.G.getId());
    }

    public AlgorithmIdentifier(String a) {
        AlgorithmIdentifier a2;
        a2.d = false;
        AlgorithmIdentifier algorithmIdentifier = a2;
        a2.G = new DERObjectIdentifier(a);
    }

    public AlgorithmIdentifier(DERObjectIdentifier a, DEREncodable a2) {
        AlgorithmIdentifier a3;
        AlgorithmIdentifier algorithmIdentifier = a3;
        AlgorithmIdentifier algorithmIdentifier2 = a3;
        algorithmIdentifier2.d = false;
        algorithmIdentifier2.d = true;
        algorithmIdentifier.G = a;
        algorithmIdentifier.short = a2;
    }

    public AlgorithmIdentifier(DERObjectIdentifier a) {
        AlgorithmIdentifier a2;
        AlgorithmIdentifier algorithmIdentifier = a2;
        algorithmIdentifier.d = false;
        algorithmIdentifier.G = a;
    }
}

