/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.config;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="hussar.security")
public class IgnoreUrlsConfig {
    public static final String PREFIX = "hussar.security";
    private List<String> ignoreUrls = new ArrayList<String>();
    private static List<String> ignoreUrlsDefaultList = new ArrayList<String>();

    public void setIgnoreUrls(List<String> list) {
        this.ignoreUrls = list;
    }

    public List<String> getIgnoreUrls() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (ObjectUtils.isEmpty(this.ignoreUrls)) {
            arrayList.addAll(ignoreUrlsDefaultList);
            return arrayList.stream().distinct().collect(Collectors.toList());
        }
        arrayList.addAll(this.ignoreUrls);
        arrayList.addAll(ignoreUrlsDefaultList);
        return arrayList.stream().distinct().collect(Collectors.toList());
    }

    static {
        ignoreUrlsDefaultList.add("/oauth2/authorize/**");
        ignoreUrlsDefaultList.add("/oauth2/token/**");
        ignoreUrlsDefaultList.add("/oauth2/doLogin/**");
        ignoreUrlsDefaultList.add("/oauth2/doConfirm/**");
        ignoreUrlsDefaultList.add("/oauth2/refresh/**");
        ignoreUrlsDefaultList.add("/oauth2/client_token/**");
        ignoreUrlsDefaultList.add("/error");
        ignoreUrlsDefaultList.add("/doc.html");
        ignoreUrlsDefaultList.add("favicon.ico");
        ignoreUrlsDefaultList.add("/v2/api-docs-ext/**");
        ignoreUrlsDefaultList.add("/v2/api-docs/**");
        ignoreUrlsDefaultList.add("/webjars/**");
        ignoreUrlsDefaultList.add("/swagger-resources/**");
        ignoreUrlsDefaultList.add("/swagger-ui.html");
        ignoreUrlsDefaultList.add("/swagger-resources/configuration/ui/**");
        ignoreUrlsDefaultList.add("/swagger-resources/configuration/security/**");
        ignoreUrlsDefaultList.add("/swagger-resources/**");
        ignoreUrlsDefaultList.add("/swagger/**");
        ignoreUrlsDefaultList.add("/static/**");
        ignoreUrlsDefaultList.add("/auditLogCloud/save");
        ignoreUrlsDefaultList.add("/auditLogCloud/update");
        ignoreUrlsDefaultList.add("/auditLogCloud/saveAuditLogDataChanges");
        ignoreUrlsDefaultList.add("/license/**");
        ignoreUrlsDefaultList.add("/qrcode/getPicture");
        ignoreUrlsDefaultList.add("/license/**");
        ignoreUrlsDefaultList.add("/security");
        ignoreUrlsDefaultList.add("/kaptcha");
        ignoreUrlsDefaultList.add("/login");
        ignoreUrlsDefaultList.add("/logout");
        ignoreUrlsDefaultList.add("/");
        ignoreUrlsDefaultList.add("/global/423");
        ignoreUrlsDefaultList.add("/redis/**");
        ignoreUrlsDefaultList.add("/static/**");
        ignoreUrlsDefaultList.add("/resource/checkResource");
        ignoreUrlsDefaultList.add("/exception/**");
        ignoreUrlsDefaultList.add("/user/reChecking");
        ignoreUrlsDefaultList.add("/userFront/reChecking");
        ignoreUrlsDefaultList.add("/casonline/check");
        ignoreUrlsDefaultList.add("/resourceFront/checkResource");
        ignoreUrlsDefaultList.add("/frontLogin/**");
        ignoreUrlsDefaultList.add("/oauth2/**");
        ignoreUrlsDefaultList.add("/resourceFront/getResources");
        ignoreUrlsDefaultList.add("/frontMenu/**");
        ignoreUrlsDefaultList.add("/licenseFront/**");
        ignoreUrlsDefaultList.add("/getBackPwd/**");
        ignoreUrlsDefaultList.add("/getBackPwdFront/**");
        ignoreUrlsDefaultList.add("/vue/baseData/getBaseData");
        ignoreUrlsDefaultList.add("/error");
        ignoreUrlsDefaultList.add("/druid/**");
        ignoreUrlsDefaultList.add("/casSyncMessageFront/**");
        ignoreUrlsDefaultList.add("/monitor");
        ignoreUrlsDefaultList.add("/redisFront/**");
        ignoreUrlsDefaultList.add("/ehcacheFront/**");
        ignoreUrlsDefaultList.add("/homePage/**");
        ignoreUrlsDefaultList.add("/unify/cas/**");
        ignoreUrlsDefaultList.add("/themeConfig/**");
    }
}

