/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AuX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CON;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.NuL;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aUX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.cON;
import com.jxdinfo.hussar.core.support.ClassKit;
import com.jxdinfo.hussar.core.support.PageKit;
import com.jxdinfo.hussar.core.util.ClassUtil;
import com.jxdinfo.hussar.core.util.SqlUtil;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    ECCurve H;
    protected boolean withCompression;
    protected cON multiplier;
    ECFieldElement b;
    private static X9IntegerConverter k = new X9IntegerConverter();
    protected NuL preCompInfo;
    ECFieldElement import;

    public abstract ECPoint twice();

    void extends(NuL a) {
        a.preCompInfo = a;
    }

    public boolean isInfinity() {
        ECPoint a;
        return a.import == null && a.b == null;
    }

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.H = a;
        eCPoint.import = a2;
        eCPoint.b = a3;
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.import.hashCode() ^ a.b.hashCode();
    }

    public ECFieldElement getX() {
        ECPoint a;
        return a.import;
    }

    public abstract byte[] getEncoded();

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(SqlUtil.native("V)nh-vo4f<v0e$4lyhn/.mD\u001c\r\f[]o'`%t*l<"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.H.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.final();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.do(eCPoint2, a, eCPoint2.preCompInfo);
    }

    public abstract ECPoint negate();

    public ECFieldElement getY() {
        ECPoint a;
        return a.b;
    }

    public abstract ECPoint add(ECPoint var1);

    synchronized void final() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new CON();
        }
    }

    public abstract ECPoint subtract(ECPoint var1);

    public ECCurve getCurve() {
        ECPoint a;
        return a.H;
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.import.equals(((ECPoint)a).import) && a2.b.equals(((ECPoint)a).b);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.goto(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = k.getByteLength(a.import);
            byte[] byArray = k.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = k.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        private static /* synthetic */ void goto(ECPoint a, ECPoint a2) {
            if (!a.H.equals(a2.H)) {
                throw new IllegalArgumentException(PageKit.catch("?T\u0006YPJ\u001dQ\u000e^\u0014\r\u0010[VHU\u0012^G\u0013U\u0002\r\u0018DO\u0001\u0013\u001c\u0013[SW4yp{'m\u0019RZ_\u000f\u0017\u0014XU\t'~B\u001f\u001bP"));
            }
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.H, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        @Override
        synchronized void final() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.H).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new aUX();
                    return;
                }
                a.multiplier = new AuX();
            }
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.goto(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.import.toBigInteger().signum() == 0) {
                return a.H.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.import.add(f2m.b.divide(a.import));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.H.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.H.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.import.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.H, f2m3, eCFieldElement, a.withCompression);
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.import.equals(f2m)) {
                if (a2.b.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.H.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.b.add((ECFieldElement)object).divide(a2.import.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.import).add(f2m).add(a2.H.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.import.add(f2m)).add(f2m).add(a2.b);
            return new F2m(a2.H, f2m, (ECFieldElement)object, a2.withCompression);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(ClassKit.private("3\u0010\\\rOO\u000fhr ~}g\u0004\u0017\u0010Y\u0006\u0016\u001fEL\u0010/>Z\u0006\u0005XT\n\u0010BC_\u0017\u0011\u0017Y_\n"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.import, f2m.b);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.import, f2m2.H.getA());
                }
            }
            a5.withCompression = a4;
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        synchronized void final() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new AuX();
            }
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.b.toBigInteger().signum() == 0) {
                return a.H.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.H.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.H.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.import.square().multiply(eCFieldElement2).add(a.H.k).divide(a.b.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.import.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.import.subtract(eCFieldElement2)).subtract(a.b);
            return new Fp(a.H, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = k.getByteLength(a.import);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = k.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = k.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = k.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(ClassUtil.true("p\u001b]K\u0003\u0007MGW\u001cHN^NW\u0017T\u0000\u001aN\u001e&p!:3e\f[\n^\u001cDRDQ].j\u001aE"));
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.H, fp.import, a.b.negate(), a.withCompression);
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.import.equals(a.import)) {
                if (a2.b.equals(a.b)) {
                    return a2.twice();
                }
                return a2.H.getInfinity();
            }
            ECFieldElement eCFieldElement = a.b.subtract(a2.b).divide(a.import.subtract(a2.import));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.import).subtract(a.import);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.import.subtract(eCFieldElement2)).subtract(a2.b);
            return new Fp(a2.H, eCFieldElement2, eCFieldElement3);
        }
    }
}

