/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.jce.ECGOST3410NamedCurveTable;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AUX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.support.DateTime;
import com.jxdinfo.hussar.core.support.PageKit;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract int getFieldSize();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement negate();

    public abstract String getFieldName();

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement sqrt();

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement square();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private int a;
        private int F;
        private AUX J;
        private int H;
        private int b;
        private int k;
        public static final int GNB = 1;
        private int transient;
        public static final int PPB = 3;
        public static final int TPB = 2;

        @Override
        public ECFieldElement invert() {
            F2m a;
            AUX aUX2 = (AUX)a.J.clone();
            AUX aUX3 = new AUX(a.b);
            F2m f2m = a;
            AUX aUX4 = aUX3;
            aUX4.synchronized(a.k);
            aUX4.synchronized(0);
            aUX3.synchronized(f2m.a);
            if (f2m.transient == 3) {
                AUX aUX5 = aUX3;
                aUX5.synchronized(a.F);
                aUX5.synchronized(a.H);
            }
            AUX aUX6 = new AUX(a.b);
            aUX6.synchronized(0);
            AUX aUX7 = new AUX(a.b);
            AUX aUX8 = aUX2;
            while (!aUX8.else()) {
                int n = aUX2.strictfp() - aUX3.strictfp();
                if (n < 0) {
                    AUX aUX9 = aUX2;
                    aUX2 = aUX3;
                    aUX3 = aUX9;
                    AUX aUX10 = aUX6;
                    aUX6 = aUX7;
                    aUX7 = aUX10;
                    n = -n;
                }
                int n2 = n >> 5;
                AUX aUX11 = aUX3.throws(n &= 0x1F);
                AUX aUX12 = aUX2;
                aUX8 = aUX12;
                aUX12.case(aUX11, n2);
                AUX aUX13 = aUX7.throws(n);
                aUX6.case(aUX13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.k, f2m2.a, f2m3.F, f2m3.H, aUX7);
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.k;
        }

        public int getK2() {
            F2m a;
            return a.F;
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.J.synchronized();
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.b = a + 31 >> 5;
            F2m f2m = a6;
            a6.J = new AUX(a5, a6.b);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.transient = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(HussarException.short("\t:Jm>R\u0016(\tdCz\u0006`\ff\u001fb\n4 CRv\b:"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(ECGOST3410NamedCurveTable.void("\u0003@R\u0005WK4zVKK\u001d[R\b\u0010\u001aR\u001b\u001d\u0013\u0006\u0018\u0012"));
                }
                a6.transient = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(HussarException.short("\u001a(\u001ca'T\u0007(\b`\rg\u0004u@h\u001f0D%/CH?\u0015l"));
            }
            F2m f2m2 = a6;
            a6.k = a;
            f2m2.a = a2;
            f2m2.F = a3;
            a6.H = a4;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            AUX aUX2 = f2m.J.byte(f2m.k);
            int[] nArray = new int[3];
            nArray[0] = a.a;
            nArray[1] = a.F;
            nArray[2] = a.H;
            aUX2.if(a.k, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.k, f2m2.a, f2m3.F, f2m3.H, aUX2);
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.k == f2m.k && a2.a == f2m.a && a2.F == f2m.F && a2.H == f2m.H && a2.transient == f2m.transient && a2.J.equals(f2m.J);
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            AUX aUX2 = (AUX)a2.J.clone();
            F2m f2m = (F2m)a;
            aUX2.case(f2m.J, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.k, f2m2.a, f2m3.F, f2m3.H, aUX2);
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(ECGOST3410NamedCurveTable.void("v/.\u0014G\u0006\u0001\u0019\n\u001a\b\u001a\u001a\u0017\f"));
        }

        public int getRepresentation() {
            F2m a;
            return a.transient;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.J.interface(((F2m)object).J, a2.k);
            int[] nArray = new int[3];
            nArray[0] = a2.a;
            nArray[1] = a2.F;
            nArray[2] = a2.H;
            ((AUX)object).if(a2.k, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.k, f2m.a, f2m2.F, f2m2.H, (AUX)object);
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(HussarException.short("V\u000bm\u0007e\u0000/\u000fl\u0002`\u0014d\u0015,A8\u000e!\u0003hTj)N9OhK\t~\u001f`\fk\u000fskN\u0004(.B%`\u000em\u0004O\u0016uG%&V\u0012\u0010Qd"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.k != f2m2.k || f2m.a != f2m2.a || f2m.F != f2m2.F || f2m.H != f2m2.H) {
                throw new IllegalArgumentException(ECGOST3410NamedCurveTable.void("?\u0002\u0014\u000f\u001dH\u0017\u001e\rO]..G\u000e\n\u0003\u0000_\u0000\u001b\u0017Y\u0000\u0013\b\u001a%4\u001b\u0006C\u0016\fP\u0016\u0010&y\u0019\u0011\u000e\u001cK\u0017\n\u001c\u0004\u0016R.G\u0002"));
            }
            if (f2m.transient != f2m2.transient) {
                throw new IllegalArgumentException(HussarException.short("E\u0003bWr\u000b'\u001bm\u00187\u001cy\u0007d\u000f!E&\u0006d\nk\u000ecFmR/Ko\u0002s\u0000/'D B&V\u0014-\u0003`\u0011(\u0003n(N\u0010z\u000eb\u0017)\u0019d\u0010x\u001fcO.<CH?\fg"));
            }
        }

        public int getK1() {
            F2m a;
            return a.a;
        }

        public int hashCode() {
            F2m a;
            return a.J.hashCode() ^ a.k ^ a.a ^ a.F ^ a.H;
        }

        public int getK3() {
            F2m a;
            return a.H;
        }

        public int getM() {
            F2m a;
            return a.k;
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, AUX a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.b = a + 31 >> 5;
            f2m3.J = a5;
            f2m2.k = a;
            f2m2.a = a2;
            f2m.F = a3;
            f2m.H = a4;
            if (a3 == 0 && a4 == 0) {
                a6.transient = 2;
                return;
            }
            a6.transient = 3;
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        @Override
        public String getFieldName() {
            return ECGOST3410NamedCurveTable.void("7Q\u0014");
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger k;
        BigInteger super;

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.super, fp.k.subtract(a.toBigInteger()).mod(a2.super));
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.super, fp.k.multiply(a.k).mod(a.super));
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.super.bitLength();
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.super.testBit(0)) {
                throw new RuntimeException(DateTime.transient("F\fWH]\u001d\u0007G+9X\u0002"));
            }
            if (a.super.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.super, fp.k.modPow(a.super.shiftRight(2).add(ECConstants.ONE), a.super));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.super.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.k.modPow(bigInteger2, a.super).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.k;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.super);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.super.bitLength(), random)).compareTo(a.super) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.super).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.interface(a.super, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.super).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.super);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.super, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.super, fp.k.negate().mod(a.super));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.super, fp.k.multiply(a.toBigInteger()).mod(a2.super));
        }

        @Override
        public String getFieldName() {
            return PageKit.catch("%Y");
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.k;
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.k = a2;
            if (a3.k.compareTo(a) >= 0) {
                throw new IllegalArgumentException(DateTime.transient("pcx$g5AO\\\fNJE\u0003z$DJA\r\u0000\rA\u0006O\f\u0019\u0017\u0005Gf%S\u0002"));
            }
            a3.super = a;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.super, fp.k.add(a.toBigInteger()).mod(a2.super));
        }

        private static /* synthetic */ BigInteger[] interface(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        public int hashCode() {
            Fp a;
            return a.super.hashCode() ^ a.k.hashCode();
        }

        public BigInteger getQ() {
            Fp a;
            return a.super;
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.super, fp.k.modInverse(a.super));
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.super.equals(fp.super) && a2.k.equals(fp.k);
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.super, fp.k.multiply(a.toBigInteger().modInverse(a2.super)).mod(a2.super));
        }
    }
}

