/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.CoreFlag;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECPoint;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.Prn;
import com.jxdinfo.hussar.core.bouncycastle.util.Strings;
import com.jxdinfo.hussar.core.cache.CacheEntry;
import com.jxdinfo.hussar.core.util.Checker;
import java.math.BigInteger;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECCurve {
    ECFieldElement k;
    ECFieldElement interface;

    public ECFieldElement getA() {
        ECCurve a;
        return a.k;
    }

    public abstract ECPoint getInfinity();

    public abstract ECPoint createPoint(BigInteger var1, BigInteger var2, boolean var3);

    public ECFieldElement getB() {
        ECCurve a;
        return a.interface;
    }

    public abstract int getFieldSize();

    public ECCurve() {
        ECCurve a;
    }

    public abstract ECFieldElement fromBigInteger(BigInteger var1);

    public abstract ECPoint decodePoint(byte[] var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECCurve {
        private BigInteger K;
        private BigInteger I;
        private int a;
        private byte F;
        private int J;
        private BigInteger[] H;
        private ECPoint.F2m b;
        private int k;
        private int final;

        @Override
        public int getFieldSize() {
            F2m a;
            return a.k;
        }

        @Override
        public ECFieldElement fromBigInteger(BigInteger a) {
            F2m a2;
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new ECFieldElement.F2m(f2m.k, f2m.J, f2m2.a, f2m2.final, a);
        }

        public boolean isKoblitz() {
            F2m a;
            return a.K != null && a.I != null && (a.k.toBigInteger().equals(ECConstants.ZERO) || a.k.toBigInteger().equals(ECConstants.ONE)) && a.interface.toBigInteger().equals(ECConstants.ONE);
        }

        synchronized BigInteger[] true() {
            F2m a;
            if (a.H == null) {
                a.H = Prn.new(a);
            }
            return a.H;
        }

        public int hashCode() {
            F2m a;
            return a.k.hashCode() ^ a.interface.hashCode() ^ a.k ^ a.J ^ a.a ^ a.final;
        }

        public int getK3() {
            F2m a;
            return a.final;
        }

        public int getM() {
            F2m a;
            return a.k;
        }

        private /* synthetic */ ECPoint volatile(byte[] a, int a2) {
            F2m a3;
            F2m f2m = a3;
            F2m f2m2 = a3;
            ECFieldElement.F2m f2m3 = new ECFieldElement.F2m(f2m.k, f2m.J, f2m2.a, f2m2.final, new BigInteger(1, a));
            ECFieldElement eCFieldElement = null;
            if (((ECFieldElement)f2m3).toBigInteger().equals(ECConstants.ZERO)) {
                int n;
                eCFieldElement = (ECFieldElement.F2m)a3.interface;
                int n2 = n = 0;
                while (n2 < a3.k - 1) {
                    eCFieldElement = ((ECFieldElement)eCFieldElement).square();
                    n2 = ++n;
                }
            } else {
                ECFieldElement eCFieldElement2 = ((ECFieldElement)f2m3).add((ECFieldElement)a3.k).add(a3.interface.multiply(((ECFieldElement)f2m3).square().invert()));
                if ((eCFieldElement2 = a3.synchronized(eCFieldElement2)) == null) {
                    throw new RuntimeException(Strings.catch("V\r(`P\u001c,\ng^eFa\u000buIvC|K`X\u007fMq"));
                }
                int n = 0;
                if (eCFieldElement2.toBigInteger().testBit(0)) {
                    n = 1;
                }
                if (n != a2) {
                    F2m f2m4 = a3;
                    F2m f2m5 = a3;
                    eCFieldElement2 = eCFieldElement2.add(new ECFieldElement.F2m(f2m4.k, f2m4.J, f2m5.a, f2m5.final, ECConstants.ONE));
                }
                eCFieldElement = ((ECFieldElement)f2m3).multiply(eCFieldElement2);
            }
            return new ECPoint.F2m(a3, f2m3, eCFieldElement);
        }

        public BigInteger getH() {
            F2m a;
            return a.I;
        }

        private /* synthetic */ ECFieldElement synchronized(ECFieldElement a) {
            F2m a2;
            F2m f2m = a2;
            F2m f2m2 = a2;
            ECFieldElement.F2m f2m3 = new ECFieldElement.F2m(f2m.k, f2m.J, f2m2.a, f2m2.final, ECConstants.ZERO);
            if (a.toBigInteger().equals(ECConstants.ZERO)) {
                return f2m3;
            }
            ECFieldElement eCFieldElement = null;
            ECFieldElement eCFieldElement2 = f2m3;
            Random random = new Random();
            do {
                int n;
                F2m f2m4 = a2;
                F2m f2m5 = a2;
                ECFieldElement.F2m f2m6 = new ECFieldElement.F2m(f2m4.k, f2m4.J, f2m5.a, f2m5.final, new BigInteger(a2.k, random));
                eCFieldElement = f2m3;
                ECFieldElement eCFieldElement3 = a;
                int n2 = n = 1;
                while (n2 <= a2.k - 1) {
                    ECFieldElement eCFieldElement4 = eCFieldElement3.square();
                    eCFieldElement = ((ECFieldElement)eCFieldElement).square().add(eCFieldElement4.multiply(f2m6));
                    eCFieldElement3 = eCFieldElement4.add(a);
                    n2 = ++n;
                }
                if (eCFieldElement3.toBigInteger().equals(ECConstants.ZERO)) continue;
                return null;
            } while (((ECFieldElement)(eCFieldElement2 = ((ECFieldElement)eCFieldElement).square().add(eCFieldElement))).toBigInteger().equals(ECConstants.ZERO));
            return eCFieldElement;
        }

        public BigInteger getN() {
            F2m a;
            return a.K;
        }

        public F2m(int a, int a2, BigInteger a3, BigInteger a4, BigInteger a5, BigInteger a6) {
            a7(a, a2, 0, 0, a3, a4, a5, a6);
            F2m a7;
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5, BigInteger a6, BigInteger a7, BigInteger a8) {
            F2m a9;
            F2m f2m = a9;
            F2m f2m2 = a9;
            F2m f2m3 = a9;
            F2m f2m4 = a9;
            f2m4.F = 0;
            f2m4.H = null;
            f2m3.k = a;
            f2m3.J = a2;
            f2m2.a = a3;
            f2m2.final = a4;
            f2m.K = a7;
            f2m.I = a8;
            if (a2 == 0) {
                throw new IllegalArgumentException(Strings.catch("A&[+[`]4Lv\u00130Yt"));
            }
            if (a3 == 0) {
                if (a4 != 0) {
                    throw new IllegalArgumentException(Checker.try("}j]2\u000e,\u000fI/\u000bjZn\u0010;\u0018wh^\u00137Qe"));
                }
            } else {
                if (a3 <= a2) {
                    throw new IllegalArgumentException(Strings.catch("#\u00187\u00163]g\tvK3\r.\u0012u"));
                }
                if (a4 <= a3) {
                    throw new IllegalArgumentException(Checker.try("&]j\u0007;\n)\u0018~?^\u0010*\u001ag"));
                }
            }
            F2m f2m5 = a9;
            f2m5.k = (int)a9.fromBigInteger(a5);
            f2m5.interface = a9.fromBigInteger(a6);
            F2m f2m6 = a9;
            a9.b = new ECPoint.F2m(a9, null, null);
        }

        public boolean isTrinomial() {
            F2m a;
            return a.a == 0 && a.final == 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public ECPoint decodePoint(byte[] a) {
            ECPoint eCPoint = null;
            switch (a[0]) {
                case 0: {
                    F2m a2;
                    if (a.length <= 1) return a2.getInfinity();
                    throw new RuntimeException(Strings.catch("jpT~HpL5SqKqc\nM{M|M}]i"));
                }
                case 2: 
                case 3: {
                    F2m a2;
                    byte[] byArray = new byte[a.length - 1];
                    System.arraycopy(a, 1, byArray, 0, byArray.length);
                    if (a[0] != 2) return a2.volatile(byArray, 1);
                    return a2.volatile(byArray, 0);
                }
                case 4: 
                case 6: 
                case 7: {
                    F2m a2;
                    byte[] byArray = new byte[(a.length - 1) / 2];
                    byte[] byArray2 = new byte[(a.length - 1) / 2];
                    System.arraycopy(a, 1, byArray, 0, byArray.length);
                    System.arraycopy(a, byArray.length + 1, byArray2, 0, byArray2.length);
                    F2m f2m = a2;
                    F2m f2m2 = a2;
                    F2m f2m3 = a2;
                    F2m f2m4 = a2;
                    F2m f2m5 = a2;
                    return new ECPoint.F2m(f2m2, new ECFieldElement.F2m(f2m2.k, f2m3.J, f2m3.a, a2.final, new BigInteger(1, byArray)), new ECFieldElement.F2m(f2m4.k, f2m4.J, f2m5.a, f2m5.final, new BigInteger(1, byArray2)), false);
                }
            }
            throw new RuntimeException(new StringBuilder().insert(0, Checker.try("\u0012\\`8\u00116\u001f\u007f\u000b\u0006$\u0000>J+\u0017>Wx3\u0010I*A-")).append(Integer.toString(a[0], 16)).toString());
        }

        public int getK2() {
            F2m a;
            return a.a;
        }

        @Override
        public ECPoint createPoint(BigInteger a, BigInteger a2, boolean a3) {
            F2m a4;
            F2m f2m = a4;
            return new ECPoint.F2m(f2m, a4.fromBigInteger(a), f2m.fromBigInteger(a2), a3);
        }

        @Override
        public ECPoint getInfinity() {
            F2m a;
            return a.b;
        }

        public F2m(int a, int a2, BigInteger a3, BigInteger a4) {
            a5(a, a2, 0, 0, a3, a4, null, null);
            F2m a5;
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.k == f2m.k && a2.J == f2m.J && a2.a == f2m.a && a2.final == f2m.final && a2.k.equals(f2m.k) && a2.interface.equals(f2m.interface);
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5, BigInteger a6) {
            a7(a, a2, a3, a4, a5, a6, null, null);
            F2m a7;
        }

        synchronized byte strictfp() {
            F2m a;
            if (a.F == 0) {
                a.F = Prn.abstract(a);
            }
            return a.F;
        }

        public int getK1() {
            F2m a;
            return a.J;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECCurve {
        BigInteger k;
        ECPoint.Fp char;

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public ECPoint decodePoint(byte[] a) {
            ECFieldElement eCFieldElement;
            ECFieldElement.Fp fp;
            Fp a2;
            ECPoint eCPoint = null;
            switch (a[0]) {
                case 0: {
                    if (a.length <= 1) return a2.getInfinity();
                    throw new RuntimeException(CoreFlag.float("\u000f\r1\u0003-\r)H6\f.\f\u0006w(\u0006(\u0001(\u00008\u0014"));
                }
                case 2: 
                case 3: {
                    int n;
                    int n2 = a[0] & 1;
                    byte[] byArray = new byte[a.length - 1];
                    System.arraycopy(a, 1, byArray, 0, byArray.length);
                    fp = new ECFieldElement.Fp(a2.k, new BigInteger(1, byArray));
                    eCFieldElement = ((ECFieldElement)fp).multiply(((ECFieldElement)fp).square().add((ECFieldElement)((Object)a2.k))).add(a2.interface).sqrt();
                    if (eCFieldElement == null) {
                        throw new RuntimeException(CacheEntry.double("wXN\u001a\u0019yz6hyqNZ\u0007JL@@L\u0014\f`tJE"));
                    }
                    int n3 = n = eCFieldElement.toBigInteger().testBit(0) ? 1 : 0;
                    if (n == n2) {
                        return new ECPoint.Fp(a2, fp, eCFieldElement, true);
                    }
                }
                Fp fp2 = a2;
                return new ECPoint.Fp(a2, fp, new ECFieldElement.Fp(fp2.k, fp2.k.subtract(eCFieldElement.toBigInteger())), true);
                case 4: 
                case 6: 
                case 7: {
                    byte[] byArray = new byte[(a.length - 1) / 2];
                    byte[] byArray2 = new byte[(a.length - 1) / 2];
                    System.arraycopy(a, 1, byArray, 0, byArray.length);
                    System.arraycopy(a, byArray.length + 1, byArray2, 0, byArray2.length);
                    Fp fp3 = a2;
                    return new ECPoint.Fp(fp3, new ECFieldElement.Fp(fp3.k, new BigInteger(1, byArray)), new ECFieldElement.Fp(a2.k, new BigInteger(1, byArray2)));
                }
            }
            throw new RuntimeException(new StringBuilder().insert(0, CoreFlag.float("\b<\u0001'\u000f.\u0006a\u0014\"\u0001(\u0017g\u0007\u001c4\"\f\"\u0000+If\u000b")).append(Integer.toString(a[0], 16)).toString());
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.k.equals(fp.k) && ((Object)a2.k).equals(fp.k) && a2.interface.equals(fp.interface);
        }

        public int hashCode() {
            Fp a;
            return ((Object)a.k).hashCode() ^ a.interface.hashCode() ^ a.k.hashCode();
        }

        @Override
        public ECPoint createPoint(BigInteger a, BigInteger a2, boolean a3) {
            Fp a4;
            Fp fp = a4;
            return new ECPoint.Fp(fp, a4.fromBigInteger(a), fp.fromBigInteger(a2), a3);
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.k.bitLength();
        }

        @Override
        public ECPoint getInfinity() {
            Fp a;
            return a.char;
        }

        public BigInteger getQ() {
            Fp a;
            return a.k;
        }

        public Fp(BigInteger a, BigInteger a2, BigInteger a3) {
            Fp a4;
            Fp fp = a4;
            a4.k = a;
            fp.k = fp.fromBigInteger(a2);
            fp.interface = fp.fromBigInteger(a3);
            Fp fp2 = a4;
            a4.char = new ECPoint.Fp(a4, null, null);
        }

        @Override
        public ECFieldElement fromBigInteger(BigInteger a) {
            Fp a2;
            return new ECFieldElement.Fp(a2.k, a);
        }
    }
}

