/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1.x9;

import com.jxdinfo.hussar.core.auto.common.Sets;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Encodable;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1EncodableVector;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1OctetString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Sequence;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERInteger;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERSequence;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9Curve;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9ECPoint;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9FieldID;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class X9ECParameters
extends ASN1Encodable
implements X9ObjectIdentifiers {
    private BigInteger a;
    private ECCurve F;
    private BigInteger J;
    private X9FieldID H;
    private static final BigInteger b = BigInteger.valueOf(1L);
    private ECPoint k;
    private byte[] void;

    public X9ECParameters(ECCurve a, ECPoint a2, BigInteger a3) {
        a4(a, a2, a3, b, null);
        X9ECParameters a4;
    }

    public X9ECParameters(ECCurve a, ECPoint a2, BigInteger a3, BigInteger a4, byte[] a5) {
        X9ECParameters a6;
        X9ECParameters x9ECParameters = a6;
        X9ECParameters x9ECParameters2 = a6;
        a6.F = a;
        x9ECParameters2.k = a2;
        x9ECParameters2.J = a3;
        x9ECParameters.a = a4;
        x9ECParameters.void = a5;
        if (a instanceof ECCurve.Fp) {
            X9ECParameters x9ECParameters3 = a6;
            x9ECParameters3.H = new X9FieldID(((ECCurve.Fp)a).getQ());
            return;
        }
        if (a instanceof ECCurve.F2m) {
            a = (ECCurve.F2m)a;
            a6.H = new X9FieldID(((ECCurve.F2m)a).getM(), ((ECCurve.F2m)a).getK1(), ((ECCurve.F2m)a).getK2(), ((ECCurve.F2m)a).getK3());
        }
    }

    public X9ECParameters(ASN1Sequence a) {
        X9ECParameters a2;
        if (!(a.getObjectAt(0) instanceof DERInteger) || !((DERInteger)a.getObjectAt(0)).getValue().equals(b)) {
            throw new IllegalArgumentException(Sets.for("\u0010*`\n\u00133k#v,bRT\u000f\u000e*\u0004;r&X\u0015I\u001b\\\u0015K\u0012\\"));
        }
        X9Curve x9Curve = new X9Curve(new X9FieldID((ASN1Sequence)a.getObjectAt(1)), (ASN1Sequence)a.getObjectAt(2));
        a2.F = x9Curve.getCurve();
        X9ECParameters x9ECParameters = a2;
        a2.k = new X9ECPoint(a2.F, (ASN1OctetString)a.getObjectAt(3)).getPoint();
        a2.J = ((DERInteger)a.getObjectAt(4)).getValue();
        a2.void = x9Curve.getSeed();
        if (a.size() == 6) {
            a2.a = ((DERInteger)a.getObjectAt(5)).getValue();
        }
    }

    @Override
    public DERObject toASN1Object() {
        X9ECParameters a;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector4 = aSN1EncodableVector;
        aSN1EncodableVector3.add(new DERInteger(1));
        aSN1EncodableVector2.add(a.H);
        X9ECParameters x9ECParameters = a;
        aSN1EncodableVector3.add(new X9Curve(x9ECParameters.F, x9ECParameters.void));
        aSN1EncodableVector2.add(new X9ECPoint(a.k));
        aSN1EncodableVector2.add(new DERInteger(a.J));
        if (a.a != null) {
            aSN1EncodableVector.add(new DERInteger(a.a));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public ECCurve getCurve() {
        X9ECParameters a;
        return a.F;
    }

    public BigInteger getN() {
        X9ECParameters a;
        return a.J;
    }

    public BigInteger getH() {
        X9ECParameters a;
        if (a.a == null) {
            return b;
        }
        return a.a;
    }

    public ECPoint getG() {
        X9ECParameters a;
        return a.k;
    }

    public X9ECParameters(ECCurve a, ECPoint a2, BigInteger a3, BigInteger a4) {
        a5(a, a2, a3, a4, null);
        X9ECParameters a5;
    }

    public byte[] getSeed() {
        X9ECParameters a;
        return a.void;
    }
}

