/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.util;

import com.jxdinfo.hussar.CoreVersion;
import com.jxdinfo.hussar.core.Contact;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.HussarExceptionEnum;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ResourceUtils;
import com.jxdinfo.hussar.core.util.SecurityUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.InflaterInputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileUtil {
    private static Logger D = LoggerFactory.getLogger(FileUtil.class);
    private static String L;
    private static final char[] h;
    public static final byte[] BOM;
    private static String finally;

    public static void check() {
        if (!ResourceUtils.checkVersion() || !FileUtil.checkVersion()) {
            SecurityUtil.exitSystem(DateUtil.case("\u63eb\u6743\u9af2\u8bc4\u594a\u8d2f\uff75\u68c1\u6d34\u523c\u5377\u88a1\u4f9a\u653b\u0002"), false);
        }
    }

    public static boolean deleteDir(File a) {
        if (a.isDirectory()) {
            int n;
            String[] stringArray = a.list();
            int n2 = n = 0;
            while (n2 < stringArray.length) {
                if (!FileUtil.deleteDir(new File(a, stringArray[n]))) {
                    return false;
                }
                n2 = ++n;
            }
        }
        return a.delete();
    }

    protected static boolean checkVersion() {
        return FileUtil.else().equals(FileUtil.byte()) || Contact.package("!^=J/").equals(FileUtil.byte());
    }

    public static boolean writeText(File a, String a22, String a3, boolean a4) {
        try {
            a22 = ((String)a22).getBytes(a3);
            if (a3.equalsIgnoreCase("UTF-8") && a4) {
                a22 = ArrayUtils.addAll((byte[])BOM, (byte[])a22);
            }
            FileUtil.writeByte(a, (byte[])a22);
        }
        catch (Exception a22) {
            return false;
        }
        return true;
    }

    public static byte[] getByte(InflaterInputStream a) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            byArray = null;
            int n = 0;
            InflaterInputStream inflaterInputStream = a;
            while ((n = inflaterInputStream.read(byArray2, 0, 1024)) != -1) {
                inflaterInputStream = a;
                byteArrayOutputStream.write(byArray2, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byArray = byteArrayOutputStream2.toByteArray();
        byteArrayOutputStream2.close();
        return byArray;
    }

    public static boolean writeText(File a, String a2, String a3) {
        return FileUtil.writeText(a, a2, a3, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toByteArray(String a) {
        byte[] byArray;
        Comparable<File> comparable = new File(a);
        if (!((File)comparable).exists()) {
            D.error(new StringBuilder().insert(0, Contact.package("\u65e7\u4ee6\u6759\u627d\u525b\uff1a")).append(a).toString());
            throw new HussarException(HussarExceptionEnum.FILE_NOT_FOUND);
        }
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream((File)comparable);
            abstractInterruptibleChannel = fileInputStream.getChannel();
            AbstractInterruptibleChannel abstractInterruptibleChannel2 = abstractInterruptibleChannel;
            comparable = ByteBuffer.allocate((int)((FileChannel)abstractInterruptibleChannel).size());
            while (abstractInterruptibleChannel2.read((ByteBuffer)comparable) > 0) {
                abstractInterruptibleChannel2 = abstractInterruptibleChannel;
            }
        }
        catch (IOException iOException) {
            try {
                throw new HussarException(HussarExceptionEnum.FILE_READING_ERROR);
            }
            catch (Throwable throwable) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (IOException iOException2) {
                    throw new HussarException(HussarExceptionEnum.FILE_READING_ERROR);
                }
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException3) {
                    throw new HussarException(HussarExceptionEnum.FILE_READING_ERROR);
                }
            }
        }
        {
            byArray = ((ByteBuffer)comparable).array();
        }
        try {
            abstractInterruptibleChannel.close();
        }
        catch (IOException iOException) {
            throw new HussarException(HussarExceptionEnum.FILE_READING_ERROR);
        }
        try {
            fileInputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            throw new HussarException(HussarExceptionEnum.FILE_READING_ERROR);
        }
    }

    public FileUtil() {
        FileUtil a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFromInputStream(InputStream a) throws IOException {
        try {
            int n;
            Object object = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n2 = n = a.read(byArray);
            while (n2 != -1) {
                ((ByteArrayOutputStream)object).write(byArray, 0, n);
                n2 = a.read(byArray);
            }
            ByteArrayOutputStream byteArrayOutputStream = object;
            byteArrayOutputStream.flush();
            object = byteArrayOutputStream.toByteArray();
            return object;
        }
        finally {
            if (a != null) {
                a.close();
            }
        }
    }

    public static boolean writeByte(String a, byte[] a2) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(a));
            bufferedOutputStream.write(a2);
            bufferedOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean writeByte(File a, byte[] a2) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(a));
            bufferedOutputStream.write(a2);
            bufferedOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static final /* synthetic */ String int(byte[] a) {
        int n;
        int n2 = a.length;
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        int n4 = n = 0;
        while (n4 < n2) {
            byte by = a[n];
            cArray[n3++] = h[by >>> 4 & 0xF];
            cArray[n3++] = h[by & 0xF];
            n4 = ++n;
        }
        return new String(cArray);
    }

    private static synchronized /* synthetic */ String else() {
        if (finally == null) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                Iterator<String> iterator;
                Iterator<String> iterator2 = iterator = ResourceUtils.className.iterator();
                while (iterator2.hasNext()) {
                    Object object = iterator.next();
                    object = FileUtil.class.getClassLoader().getResourceAsStream((String)object);
                    iterator2 = iterator;
                    stringBuffer.append(FileUtil.md5((InputStream)object));
                    ((InputStream)object).close();
                }
            }
            catch (IOException iOException) {
                return "";
            }
            finally = stringBuffer.toString();
        }
        return finally;
    }

    private static synchronized /* synthetic */ String byte() {
        if (L == null) {
            InputStream inputStream;
            Properties properties;
            block4: {
                properties = new Properties();
                inputStream = CoreVersion.class.getClassLoader().getResourceAsStream(DateUtil.case("h\u001ab\u000b3\bi\u000b"));
                if (inputStream != null) break block4;
                return null;
            }
            try {
                properties.load(inputStream);
                L = properties.getProperty(Contact.package("}\u0012~"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return L;
    }

    public static boolean writeText(File a, String a2) {
        return FileUtil.writeText(a, a2, "UTF-8");
    }

    protected static final String md5(InputStream a) throws IOException {
        MessageDigest messageDigest;
        try {
            int n = 8192;
            byte[] byArray = new byte[8192];
            messageDigest = MessageDigest.getInstance(DateUtil.case(">\u0018\u0017"));
            int n2 = -1;
            InputStream inputStream = a;
            while ((n2 = inputStream.read(byArray, 0, n)) != -1) {
                inputStream = a;
                messageDigest.update(byArray, 0, n2);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        return FileUtil.int(messageDigest.digest());
    }

    static {
        byte[] byArray = new byte[3];
        byArray[0] = -17;
        byArray[1] = -69;
        byArray[2] = -65;
        BOM = byArray;
        char[] cArray = new char[16];
        cArray[0] = 48;
        cArray[1] = 49;
        cArray[2] = 50;
        cArray[3] = 51;
        cArray[4] = 52;
        cArray[5] = 53;
        cArray[6] = 54;
        cArray[7] = 55;
        cArray[8] = 56;
        cArray[9] = 57;
        cArray[10] = 97;
        cArray[11] = 98;
        cArray[12] = 99;
        cArray[13] = 100;
        cArray[14] = 101;
        cArray[15] = 102;
        h = cArray;
        finally = null;
        L = null;
    }
}

