/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.auto.common.TypeHelper;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9ECParametersHolder;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AUx;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.Nul;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.Prn;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aUX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.prn;
import com.jxdinfo.hussar.core.exception.HussarCoreExceptionHandler;
import com.jxdinfo.hussar.core.support.CollectionKit;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    ECFieldElement D;
    protected boolean withCompression;
    protected prn preCompInfo;
    ECFieldElement L;
    private static X9IntegerConverter h = new X9IntegerConverter();
    ECCurve this;
    protected Prn multiplier;

    public abstract ECPoint negate();

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    synchronized void assert() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new AUx();
        }
    }

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.this = a;
        eCPoint.D = a2;
        eCPoint.L = a3;
    }

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint twice();

    public ECFieldElement getX() {
        ECPoint a;
        return a.D;
    }

    public boolean isInfinity() {
        ECPoint a;
        return a.D == null && a.L == null;
    }

    public ECFieldElement getY() {
        ECPoint a;
        return a.L;
    }

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.D.equals(((ECPoint)a).D) && a2.L.equals(((ECPoint)a).L);
    }

    public ECCurve getCurve() {
        ECPoint a;
        return a.this;
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(TypeHelper.assert("s\fKM\bSJ\u0011C\u0019S\u0015@\u0001\u0011I\\MK\n\u000bHa9()~xJ\u0002E\u0000Q\u000fI\u0019"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.this.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.assert();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.float(eCPoint2, a, eCPoint2.preCompInfo);
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.D.hashCode() ^ a.L.hashCode();
    }

    public abstract ECPoint add(ECPoint var1);

    public abstract byte[] getEncoded();

    void protected(prn a) {
        a.preCompInfo = a;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.volatile(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(CollectionKit.int("\u000e\u000eaV7U6\f5^#Vo[kO%\u0013 {\u0002~\u0001l^R-T*S.X)\\cmH\u0004iY/"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.D, f2m.L);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.D, f2m2.this.getA());
                }
            }
            a5.withCompression = a4;
        }

        @Override
        synchronized void assert() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.this).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new aUX();
                    return;
                }
                a.multiplier = new Nul();
            }
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.D.toBigInteger().signum() == 0) {
                return a.this.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.D.add(f2m.L.divide(a.D));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.this.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.this.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.D.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.this, f2m3, eCFieldElement, a.withCompression);
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = h.getByteLength(a.D);
            byte[] byArray = h.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = h.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        private static /* synthetic */ void volatile(ECPoint a, ECPoint a2) {
            if (!a.this.equals(a2.this)) {
                throw new IllegalArgumentException(HussarCoreExceptionHandler.throws(">x^,\u001e)D%Y$\u00026U3\u001c/\u0019s:\u000e}\u0016jHS\"D'TvH-\u0015<{\u001bMkV1L*\u00108AtM,I8D0P _9"));
            }
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.this, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.D.equals(f2m)) {
                if (a2.L.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.this.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.L.add((ECFieldElement)object).divide(a2.D.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.D).add(f2m).add(a2.this.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.D.add(f2m)).add(f2m).add(a2.L);
            return new F2m(a2.this, f2m, (ECFieldElement)object, a2.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.volatile(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.L.toBigInteger().signum() == 0) {
                return a.this.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.this.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.this.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.D.square().multiply(eCFieldElement2).add(extends).divide(a.L.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.D.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.D.subtract(eCFieldElement2)).subtract(a.L);
            return new Fp(a.this, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(X9ECParametersHolder.interface("\u00013cc=j6kmN\f\u0006\u0000S\\~+iem+t4%(F\u0006p1<~x6++\u007fe\u007f-7~"));
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }

        @Override
        synchronized void assert() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new Nul();
            }
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.this, fp.D, a.L.negate(), a.withCompression);
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.D.equals(a.D)) {
                if (a2.L.equals(a.L)) {
                    return a2.twice();
                }
                return a2.this.getInfinity();
            }
            ECFieldElement eCFieldElement = a.L.subtract(a2.L).divide(a.D.subtract(a2.D));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.D).subtract(a.D);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.D.subtract(eCFieldElement2)).subtract(a2.L);
            return new Fp(a2.this, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = h.getByteLength(a.D);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = h.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = h.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = h.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }
    }
}

