/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.jce.spec.ECParameterSpec;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CON;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.support.ObjectKit;
import com.jxdinfo.hussar.core.util.CRC32Util;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement square();

    public abstract ECFieldElement sqrt();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract BigInteger toBigInteger();

    public abstract int getFieldSize();

    public abstract ECFieldElement invert();

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract String getFieldName();

    public abstract ECFieldElement negate();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private int G;
        private CON B;
        public static final int GNB = 1;
        private int K;
        public static final int PPB = 3;
        public static final int TPB = 2;
        private int D;
        private int L;
        private int h;
        private int if;

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            CON cON2 = (CON)a2.B.clone();
            F2m f2m = (F2m)a;
            cON2.do(f2m.B, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.if, f2m2.h, f2m3.G, f2m3.L, cON2);
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.D = a + 31 >> 5;
            F2m f2m = a6;
            a6.B = new CON(a5, a6.D);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.K = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(CRC32Util.protected("\f~O);\u0016\u0013l\f F>\u0003$\t\"\u001a&\u000fp%\u0007W2\r~"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(ObjectKit.implements("\u0019\u0015sk\u000f\\\u0007\u0006\u0019KSJ\u0019_\u0005R@G$mE\u001f[\u001e"));
                }
                a6.K = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(CRC32Util.protected("\u001fl\u0019%\"\u0010\u0002l\r$\b#\u00011E,\u001atAa*\u0007M{\u0010("));
            }
            F2m f2m2 = a6;
            a6.if = a;
            f2m2.h = a2;
            f2m2.G = a3;
            a6.L = a4;
        }

        public int hashCode() {
            F2m a;
            return a.B.hashCode() ^ a.if ^ a.h ^ a.G ^ a.L;
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        public int getK3() {
            F2m a;
            return a.L;
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            CON cON2 = (CON)a.B.clone();
            CON cON3 = new CON(a.D);
            F2m f2m = a;
            CON cON4 = cON3;
            cON4.while(a.if);
            cON4.while(0);
            cON3.while(f2m.h);
            if (f2m.K == 3) {
                CON cON5 = cON3;
                cON5.while(a.G);
                cON5.while(a.L);
            }
            CON cON6 = new CON(a.D);
            cON6.while(0);
            CON cON7 = new CON(a.D);
            CON cON8 = cON2;
            while (!cON8.true()) {
                int n = cON2.switch() - cON3.switch();
                if (n < 0) {
                    CON cON9 = cON2;
                    cON2 = cON3;
                    cON3 = cON9;
                    CON cON10 = cON6;
                    cON6 = cON7;
                    cON7 = cON10;
                    n = -n;
                }
                int n2 = n >> 5;
                CON cON11 = cON3.synchronized(n &= 0x1F);
                CON cON12 = cON2;
                cON8 = cON12;
                cON12.do(cON11, n2);
                CON cON13 = cON7.synchronized(n);
                cON6.do(cON13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.if, f2m2.h, f2m3.G, f2m3.L, cON7);
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(CRC32Util.protected("\u0012\u000e)\u0002!\u0005k\n(\u0007$\u0011 \u0010hD|\u000be\u0006,Q.,\n<\u000bm\u000f\f:\u001a$\t/\n7n\n\u0001l+\u0006 $\u000b)\u0001\u000b\u00131Ba#\u0012\u0017TT "));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.if != f2m2.if || f2m.h != f2m2.h || f2m.G != f2m2.G || f2m.L != f2m2.L) {
                throw new IllegalArgumentException(ObjectKit.implements("+\u0012K\u001bFBR\u0012NU\b\u001dR\u0006\u0000Y\u001f6&;o$%\u001aF\u0016K\u001fA\u0006Tsi\u001c\u000f\u0007N\u001e\u000e\u0000G\u0015HBQ[\u0002<a\u00047IC"));
            }
            if (f2m.K != f2m2.K) {
                throw new IllegalArgumentException(CRC32Util.protected("\u0001\u0006&R6\u000ec\u001e)\u001ds\u0019=\u0002 \ne@b\u0003 \u000f/\u000b'C)WkN+\u00077\u0005k\"\u0000%\u0006#\u0012\u0011i\u0006$\u0014l\u0006*-\n\u0015>\u000b&\u0012m\u001c \u0015<\u001a'Jj9\u0007M{\t#"));
            }
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, CON a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.D = a + 31 >> 5;
            f2m3.B = a5;
            f2m2.if = a;
            f2m2.h = a2;
            f2m.G = a3;
            f2m.L = a4;
            if (a3 == 0 && a4 == 0) {
                a6.K = 2;
                return;
            }
            a6.K = 3;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.B.continue();
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(ObjectKit.implements("`\u001cRXD\u000fG^\u0002=`J\u0005\u001eJ"));
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.if == f2m.if && a2.h == f2m.h && a2.G == f2m.G && a2.L == f2m.L && a2.K == f2m.K && a2.B.equals(f2m.B);
        }

        public int getK1() {
            F2m a;
            return a.h;
        }

        public int getRepresentation() {
            F2m a;
            return a.K;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            CON cON2 = f2m.B.super(f2m.if);
            int[] nArray = new int[3];
            nArray[0] = a.h;
            nArray[1] = a.G;
            nArray[2] = a.L;
            cON2.false(a.if, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.if, f2m2.h, f2m3.G, f2m3.L, cON2);
        }

        @Override
        public String getFieldName() {
            return ObjectKit.implements("7IC");
        }

        public int getK2() {
            F2m a;
            return a.G;
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.if;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.B.import(((F2m)object).B, a2.if);
            int[] nArray = new int[3];
            nArray[0] = a2.h;
            nArray[1] = a2.G;
            nArray[2] = a2.L;
            ((CON)object).false(a2.if, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.if, f2m.h, f2m2.G, f2m2.L, (CON)object);
        }

        public int getM() {
            F2m a;
            return a.if;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger h;
        BigInteger float;

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.float, fp.h.multiply(a.toBigInteger()).mod(a2.float));
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.h = a2;
            if (a3.h.compareTo(a) >= 0) {
                throw new IllegalArgumentException(ECParameterSpec.interface("\u000eh\u0006/\u0019>?D\"\u00070A;\b\u0004/:A?\u0006~\u0006?\r1\u0007g\u001c{L\u0018.-\t"));
            }
            a3.float = a;
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.float, fp.h.multiply(a.h).mod(a.float));
        }

        private static /* synthetic */ BigInteger[] volatile(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.h;
        }

        public int hashCode() {
            Fp a;
            return a.float.hashCode() ^ a.h.hashCode();
        }

        public BigInteger getQ() {
            Fp a;
            return a.float;
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.float.equals(fp.float) && a2.h.equals(fp.h);
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.float, fp.h.add(a.toBigInteger()).mod(a2.float));
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.float, fp.h.multiply(a.toBigInteger().modInverse(a2.float)).mod(a2.float));
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.float, fp.h.modInverse(a.float));
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.float.testBit(0)) {
                throw new RuntimeException(ECParameterSpec.interface("8\u0007)C#\u0016yLU2&\t"));
            }
            if (a.float.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.float, fp.h.modPow(a.float.shiftRight(2).add(ECConstants.ONE), a.float));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.float.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.h.modPow(bigInteger2, a.float).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.h;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.float);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.float.bitLength(), random)).compareTo(a.float) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.float).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.volatile(a.float, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.float).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.float);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.float, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public String getFieldName() {
            return CRC32Util.protected("= ");
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.float.bitLength();
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.float, fp.h.negate().mod(a.float));
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.float, fp.h.subtract(a.toBigInteger()).mod(a2.float));
        }
    }
}

