/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AuX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CoN;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.NUL;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nuL;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.prn;
import com.jxdinfo.hussar.core.cache.LRULinkedHashMap;
import com.jxdinfo.hussar.core.encrypt.file.exceptioin.FileEncryptException;
import com.jxdinfo.hussar.core.qr.QrImage;
import com.jxdinfo.hussar.core.support.WafKit;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    ECFieldElement A;
    protected CoN multiplier;
    protected AuX preCompInfo;
    protected boolean withCompression;
    private static X9IntegerConverter L = new X9IntegerConverter();
    ECCurve d;
    ECFieldElement import;

    public boolean isInfinity() {
        ECPoint a;
        return a.import == null && a.A == null;
    }

    void abstract(AuX a) {
        a.preCompInfo = a;
    }

    public abstract ECPoint twice();

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint negate();

    public ECFieldElement getY() {
        ECPoint a;
        return a.A;
    }

    public abstract byte[] getEncoded();

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.import.equals(((ECPoint)a).import) && a2.A.equals(((ECPoint)a).A);
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.import.hashCode() ^ a.A.hashCode();
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(LRULinkedHashMap.char("%U\u001d\u0014^\n\u001cH\u0015@\u0005L\u0016XG\u0010\n\u0014\u001dS]\u00117`~p(!\u001c[\u0013Y\u0007V\u001f@"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.d.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.public();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.break(eCPoint2, a, eCPoint2.preCompInfo);
    }

    synchronized void public() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new nuL();
        }
    }

    public ECCurve getCurve() {
        ECPoint a;
        return a.d;
    }

    public abstract ECPoint add(ECPoint var1);

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.d = a;
        eCPoint.import = a2;
        eCPoint.A = a3;
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public ECFieldElement getX() {
        ECPoint a;
        return a.import;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        @Override
        synchronized void public() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.d).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new NUL();
                    return;
                }
                a.multiplier = new prn();
            }
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.d, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.import.equals(f2m)) {
                if (a2.A.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.d.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.A.add((ECFieldElement)object).divide(a2.import.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.import).add(f2m).add(a2.d.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.import.add(f2m)).add(f2m).add(a2.A);
            return new F2m(a2.d, f2m, (ECFieldElement)object, a2.withCompression);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(WafKit.byte("\\=3eefd?gmqe=h9|w rHPMS_\fa\u007fgx`|k{o1^\u001a7;j}"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.import, f2m.A);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.import, f2m2.d.getA());
                }
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.import.toBigInteger().signum() == 0) {
                return a.d.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.import.add(f2m.A.divide(a.import));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.d.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.d.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.import.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.d, f2m3, eCFieldElement, a.withCompression);
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = L.getByteLength(a.import);
            byte[] byArray = L.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = L.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.throw(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.throw(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        private static /* synthetic */ void throw(ECPoint a, ECPoint a2) {
            if (!a.d.equals(a2.d)) {
                throw new IllegalArgumentException(QrImage.private("2|\tsLsH!\n\u007f\u001b'\u0012|AzO-Lp\u000bhBh/V8S<\u0016\u0005h\u000e/\u0005m]sI&*D\u001b;\u0016+\u000eg\u0003z\tu\u0005}\u001bu"));
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        synchronized void public() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new prn();
            }
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = L.getByteLength(a.import);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = L.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = L.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = L.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.import.equals(a.import)) {
                if (a2.A.equals(a.A)) {
                    return a2.twice();
                }
                return a2.d.getInfinity();
            }
            ECFieldElement eCFieldElement = a.A.subtract(a2.A).divide(a.import.subtract(a2.import));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.import).subtract(a.import);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.import.subtract(eCFieldElement2)).subtract(a2.A);
            return new Fp(a2.d, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.d, fp.import, a.A.negate(), a.withCompression);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(FileEncryptException.while("\u000eP#\u0000}L3\f)W6\u0005 \u0005)\\*Kd\u0005`m\u000ejDx\u001bG%A W:\u0019:\u001a#e\u0014Q;"));
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.A.toBigInteger().signum() == 0) {
                return a.d.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.d.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.d.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.import.square().multiply(eCFieldElement2).add(a.d.d).divide(a.A.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.import.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.import.subtract(eCFieldElement2)).subtract(a.A);
            return new Fp(a.d, eCFieldElement2, eCFieldElement4, a.withCompression);
        }
    }
}

