/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AUX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.cache.LRULinkedHashMap;
import com.jxdinfo.hussar.core.support.ClassKit;
import com.jxdinfo.hussar.core.support.ObjectKit;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract String getFieldName();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement square();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement add(ECFieldElement var1);

    public ECFieldElement() {
        ECFieldElement a;
    }

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement sqrt();

    public abstract ECFieldElement negate();

    public abstract int getFieldSize();

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement divide(ECFieldElement var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private int a;
        public static final int PPB = 3;
        public static final int TPB = 2;
        public static final int GNB = 1;
        private int j;
        private int f;
        private AUX A;
        private int L;
        private int d;
        private int public;

        public int getK1() {
            F2m a;
            return a.a;
        }

        public int getRepresentation() {
            F2m a;
            return a.d;
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(ObjectKit.case("0?\u0002{\u0014,\u0017}R\u001e0iU=\u001a"));
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.j;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            AUX aUX2 = f2m.A.false(f2m.j);
            int[] nArray = new int[3];
            nArray[0] = a.a;
            nArray[1] = a.f;
            nArray[2] = a.L;
            aUX2.finally(a.j, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.j, f2m2.a, f2m3.f, f2m3.L, aUX2);
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        public int hashCode() {
            F2m a;
            return a.A.hashCode() ^ a.j ^ a.a ^ a.f ^ a.L;
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            AUX aUX2 = (AUX)a.A.clone();
            AUX aUX3 = new AUX(a.public);
            F2m f2m = a;
            AUX aUX4 = aUX3;
            aUX4.assert(a.j);
            aUX4.assert(0);
            aUX3.assert(f2m.a);
            if (f2m.d == 3) {
                AUX aUX5 = aUX3;
                aUX5.assert(a.f);
                aUX5.assert(a.L);
            }
            AUX aUX6 = new AUX(a.public);
            aUX6.assert(0);
            AUX aUX7 = new AUX(a.public);
            AUX aUX8 = aUX2;
            while (!aUX8.default()) {
                int n = aUX2.throw() - aUX3.throw();
                if (n < 0) {
                    AUX aUX9 = aUX2;
                    aUX2 = aUX3;
                    aUX3 = aUX9;
                    AUX aUX10 = aUX6;
                    aUX6 = aUX7;
                    aUX7 = aUX10;
                    n = -n;
                }
                int n2 = n >> 5;
                AUX aUX11 = aUX3.char(n &= 0x1F);
                AUX aUX12 = aUX2;
                aUX8 = aUX12;
                aUX12.try(aUX11, n2);
                AUX aUX13 = aUX7.char(n);
                aUX6.try(aUX13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.j, f2m2.a, f2m3.f, f2m3.L, aUX7);
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.A.instanceof();
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.A.boolean(((F2m)object).A, a2.j);
            int[] nArray = new int[3];
            nArray[0] = a2.a;
            nArray[1] = a2.f;
            nArray[2] = a2.L;
            ((AUX)object).finally(a2.j, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.j, f2m.a, f2m2.f, f2m2.L, (AUX)object);
        }

        public int getK3() {
            F2m a;
            return a.L;
        }

        public int getK2() {
            F2m a;
            return a.f;
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.public = a + 31 >> 5;
            F2m f2m = a6;
            a6.A = new AUX(a5, a6.public);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.d = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(ClassKit.while("\u000b<Kh\u0004lUo!H\u0017*\u0005gU;\tpKq\u0004c\u001f?Pf"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(ObjectKit.case(":EP;,\f$V:\u001bp\u001a:\u000f&\u0002c\u0017\u0007=fOxN"));
                }
                a6.d = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(ClassKit.while("\u0018.\u001dd\u001djDo LY7\u0007r\u00195\t\"\u0005`\u000bc\u0005vM0"));
            }
            F2m f2m2 = a6;
            a6.j = a;
            f2m2.a = a2;
            f2m2.f = a3;
            a6.L = a4;
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, AUX a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.public = a + 31 >> 5;
            f2m3.A = a5;
            f2m2.j = a;
            f2m2.a = a2;
            f2m.f = a3;
            f2m.L = a4;
            if (a3 == 0 && a4 == 0) {
                a6.d = 2;
                return;
            }
            a6.d = 3;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        public int getM() {
            F2m a;
            return a.j;
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.j == f2m.j && a2.a == f2m.a && a2.f == f2m.f && a2.L == f2m.L && a2.d == f2m.d && a2.A.equals(f2m.A);
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        @Override
        public String getFieldName() {
            return ObjectKit.case("gj\u0013");
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            AUX aUX2 = (AUX)a2.A.clone();
            F2m f2m = (F2m)a;
            aUX2.try(f2m.A, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.j, f2m2.a, f2m3.f, f2m3.L, aUX2);
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(ClassKit.while("I)K\u0005c@k\u0004c\rk\u0005q\u0002?@=&\rY6\u001c&\u0004g\u0019k@g\b{\u001aa-N\tq@a\u000f'$L\u0006G\fk\u0004K\u0004c\rk\u0005q_YDu"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.j != f2m2.j || f2m.a != f2m2.a || f2m.f != f2m2.f || f2m.L != f2m2.L) {
                throw new IllegalArgumentException(ObjectKit.case("{1\u001b8\u0016a\u00021\u001evX>\u0002%PzO\u0015v\u0018?\u0007u9\u00165\u001b<\u0011%\u0004P9?_$\u001e=^#\u00176\u0018a\u0001xR\u001f1'gj\u0013"));
            }
            if (f2m.d != f2m2.d) {
                throw new IllegalArgumentException(ClassKit.while("a(McB\n\"\u0014f\f'\u0007f%B\r'\u0005b\rk\u0005`\u001fvQ~S*cCX-Hc\nm\u0000f\u000ez\u0015(\u0006a0\r\u0005l\u0003a\u001bu\u0004l4\u000e\u001bb\u0010|\ru\u0005`\u001fd\u0005v\u0019v"));
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger d;
        BigInteger strictfp;

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.strictfp.testBit(0)) {
                throw new RuntimeException(EC5Util.new("\u0017r;\u000b(G OmP.["));
            }
            if (a.strictfp.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.strictfp, fp.d.modPow(a.strictfp.shiftRight(2).add(ECConstants.ONE), a.strictfp));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.strictfp.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.d.modPow(bigInteger2, a.strictfp).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.d;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.strictfp);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.strictfp.bitLength(), random)).compareTo(a.strictfp) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.strictfp).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.else(a.strictfp, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.strictfp).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.strictfp);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.strictfp, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.strictfp.bitLength();
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.d = a2;
            if (a3.d.compareTo(a) >= 0) {
                throw new IllegalArgumentException(EC5Util.new("#\u001f\f\u007f?B?\u001e&Y5\u001e=T9H~_\u0010soMj\u0002:VqP:W&Jo\u0011"));
            }
            a3.strictfp = a;
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.strictfp.equals(fp.strictfp) && a2.d.equals(fp.d);
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.strictfp, fp.d.modInverse(a.strictfp));
        }

        @Override
        public String getFieldName() {
            return LRULinkedHashMap.char("+Q");
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.d;
        }

        private static /* synthetic */ BigInteger[] else(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.strictfp, fp.d.multiply(a.d).mod(a.strictfp));
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.strictfp, fp.d.add(a.toBigInteger()).mod(a2.strictfp));
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.strictfp, fp.d.negate().mod(a.strictfp));
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.strictfp, fp.d.subtract(a.toBigInteger()).mod(a2.strictfp));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.strictfp, fp.d.multiply(a.toBigInteger()).mod(a2.strictfp));
        }

        public BigInteger getQ() {
            Fp a;
            return a.strictfp;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.strictfp, fp.d.multiply(a.toBigInteger().modInverse(a2.strictfp)).mod(a2.strictfp));
        }

        public int hashCode() {
            Fp a;
            return a.strictfp.hashCode() ^ a.d.hashCode();
        }
    }
}

