/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1;

import com.jxdinfo.hussar.core.banner.EmbeddedContainerUtils;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Object;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1OctetString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1TaggedObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEROutputStream;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERString;
import com.jxdinfo.hussar.core.support.exception.CoreExceptionHandler;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DERNumericString
extends ASN1Object
implements DERString {
    String strictfp;

    public DERNumericString(byte[] a) {
        int n;
        DERNumericString a2;
        char[] cArray = new char[a.length];
        int n2 = n = 0;
        while (n2 != cArray.length) {
            int n3 = n++;
            cArray[n3] = (char)(a[n3] & 0xFF);
            n2 = n;
        }
        a2.strictfp = new String(cArray);
    }

    @Override
    void encode(DEROutputStream a) throws IOException {
        DERNumericString a2;
        a.switch(18, a2.getOctets());
    }

    public byte[] getOctets() {
        int n;
        DERNumericString a;
        char[] cArray = a.strictfp.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n2 = n = 0;
        while (n2 != cArray.length) {
            int n3 = n++;
            byArray[n3] = (byte)cArray[n3];
            n2 = n;
        }
        return byArray;
    }

    @Override
    public String getString() {
        DERNumericString a;
        return a.strictfp;
    }

    public String toString() {
        DERNumericString a;
        return a.strictfp;
    }

    public static DERNumericString getInstance(Object a) {
        if (a == null || a instanceof DERNumericString) {
            return (DERNumericString)a;
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, EmbeddedContainerUtils.transient("(g,y0a'\u001b\u001fA\u0002N\u0003HWN\u0002\r\u0001x\"s\u001fO\u0003F\u0002C\u000e\u0013B")).append(a.getClass().getName()).toString());
    }

    public static DERNumericString getInstance(ASN1TaggedObject a, boolean a2) {
        DERObject dERObject = a.getObject();
        if (a2 || dERObject instanceof DERNumericString) {
            return DERNumericString.getInstance(dERObject);
        }
        return new DERNumericString(ASN1OctetString.getInstance(dERObject).getOctets());
    }

    public DERNumericString(String a, boolean a2) {
        DERNumericString a3;
        if (a2 && !DERNumericString.isNumericString(a)) {
            throw new IllegalArgumentException(CoreExceptionHandler.case("R\t9~$q}b.s\u000eG\u000bP\u0019\u0016\u0014M\n_\u000bQ0 \u0018O\u001cS\u0007Y\u0015X\u001aG"));
        }
        a3.strictfp = a;
    }

    @Override
    boolean asn1Equals(DERObject a) {
        DERNumericString a2;
        if (!(a instanceof DERNumericString)) {
            return false;
        }
        a = (DERNumericString)a;
        return a2.getString().equals(((DERNumericString)a).getString());
    }

    @Override
    public int hashCode() {
        DERNumericString a;
        return a.getString().hashCode();
    }

    public static boolean isNumericString(String a) {
        int n;
        int n2 = n = a.length() - 1;
        while (n2 >= 0) {
            char c = a.charAt(n);
            if (c > '\u007f') {
                return false;
            }
            if (('0' > c || c > '9') && c != ' ') {
                return false;
            }
            n2 = --n;
        }
        return true;
    }

    public DERNumericString(String a) {
        a2(a, false);
        DERNumericString a2;
    }
}

