/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Boolean;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1EncodableVector;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Enumerated;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Exception;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1GeneralizedTime;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Integer;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1StreamParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1UTCTime;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERApplicationSpecificParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERConstructedOctetString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BEROctetStringParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERSequenceParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERSetParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERTaggedObjectParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.CoN;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERApplicationSpecific;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERBMPString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERBitString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERExternal;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERExternalParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERGeneralString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERIA5String;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERNull;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERNumericString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEROctetString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERPrintableString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERT61String;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERTags;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERUTF8String;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERUniversalString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERUnknownTag;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERVisibleString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.LazyDERSequence;
import com.jxdinfo.hussar.core.bouncycastle.asn1.NUL;
import com.jxdinfo.hussar.core.bouncycastle.asn1.Prn;
import com.jxdinfo.hussar.core.bouncycastle.asn1.coN;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import com.jxdinfo.hussar.core.bouncycastle.util.io.Streams;
import com.jxdinfo.hussar.core.util.FileLoader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ASN1InputStream
extends FilterInputStream
implements DERTags {
    private final boolean d;
    private final int throws;

    protected DERObject buildObject(int a, int a2, int a32) throws IOException {
        ASN1InputStream a4;
        boolean bl = (a & 0x20) != 0;
        Prn a32 = new Prn(a4, a32);
        if ((a & 0x40) != 0) {
            return new DERApplicationSpecific(bl, a2, a32.strictfp());
        }
        if ((a & 0x80) != 0) {
            return new ASN1StreamParser(a32).double(bl, a2);
        }
        if (bl) {
            switch (a2) {
                case 4: {
                    return new BERConstructedOctetString(a4.true((Prn)a32).assert);
                }
                case 16: {
                    while (false) {
                    }
                    if (a4.d) {
                        return new LazyDERSequence(a32.strictfp());
                    }
                    return NUL.new(a4.true(a32));
                }
                case 17: {
                    return NUL.finally(a4.true(a32), false);
                }
                case 8: {
                    return new DERExternal(a4.true(a32));
                }
            }
            return new DERUnknownTag(true, a2, a32.strictfp());
        }
        return ASN1InputStream.private(a2, a32.strictfp());
    }

    public ASN1InputStream(InputStream a) {
        ASN1InputStream a2;
        InputStream inputStream = a;
        a2(inputStream, ASN1InputStream.true(inputStream));
    }

    static int native(InputStream a, int a2) throws IOException {
        if ((a2 &= 0x1F) == 31) {
            a2 = 0;
            int n = a.read();
            if ((n & 0x7F) == 0) {
                throw new IOException(FileLoader.switch("\t\u0003GA_\\1&3q98GV,&JAT\u001b\u001f\u0001\u0011\u001a>5P\u001e\u001f\u0017\tG\u0011\u0002\u000eO\u0004\u0019\b\u0001\u0015\u0004M\r\u001d\u0001\u000f\u0003"));
            }
            int n2 = n;
            while (n2 >= 0 && (n & 0x80) != 0) {
                a2 |= n & 0x7F;
                a2 <<= 7;
                n2 = a.read();
            }
            if (n < 0) {
                throw new EOFException(EC5Util.new("k\u0004iLn$Z#MzW0I;R4\u0015*[,\u000f S%X?\u0010"));
            }
            a2 |= n & 0x7F;
        }
        return a2;
    }

    public DERObject readObject() throws IOException {
        ASN1InputStream a;
        int n = a.read();
        if (n <= 0) {
            if (n == 0) {
                throw new IOException(FileLoader.switch("\u000394\b\u0006\u0013\u0013\u0015\u0002\u0001C\f\u0001\u0012]\u000e\u0001H\u0000\u000f\b?(\b\u0014\u001dH\f\u0006\u0015\n\u0015\u0004"));
            }
            return null;
        }
        int n2 = ASN1InputStream.native(a, n);
        boolean bl = (n & 0x20) != 0;
        int n3 = a.readLength();
        if (n3 < 0) {
            if (!bl) {
                throw new IOException(EC5Util.new("\u0005f\u0015ph\u0003\u0018{%PoG/@,[\u0004(;]$D3J7L7\u0016(G9Q:S5XPq3Z:D4J9J.K"));
            }
            ASN1InputStream aSN1InputStream = a;
            coN coN2 = new coN(aSN1InputStream, aSN1InputStream.throws);
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(coN2, a.throws);
            if ((n & 0x40) != 0) {
                return new BERApplicationSpecificParser(n2, aSN1StreamParser).getLoadedObject();
            }
            if ((n & 0x80) != 0) {
                return new BERTaggedObjectParser(true, n2, aSN1StreamParser).getLoadedObject();
            }
            switch (n2) {
                case 4: {
                    return new BEROctetStringParser(aSN1StreamParser).getLoadedObject();
                }
                case 16: {
                    return new BERSequenceParser(aSN1StreamParser).getLoadedObject();
                }
                case 17: {
                    return new BERSetParser(aSN1StreamParser).getLoadedObject();
                }
                case 8: {
                    return new DERExternalParser(aSN1StreamParser).getLoadedObject();
                }
            }
            throw new IOException(FileLoader.switch("\u0005\u0018\u001d\u001e\u000e\u0010\u000bC+*$P\u000e\u0005\u000f\u0006\u0003\u0012k(\b\u0003\u0001\u001d\u000f\u0013\u0002\u0013\u0015\u0012"));
        }
        try {
            return a.buildObject(n, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception(EC5Util.new("]1H C=]?Z~I/M\u0015u0\u00191T.[?L.K"), illegalArgumentException);
        }
    }

    static int true(InputStream a) {
        if (a instanceof CoN) {
            return ((CoN)a).short();
        }
        if (a instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)a).available();
        }
        return Integer.MAX_VALUE;
    }

    public ASN1InputStream(InputStream a, int a2) {
        a3(a, a2, false);
        ASN1InputStream a3;
    }

    public ASN1InputStream(byte[] a) {
        a2(new ByteArrayInputStream(a), a.length);
        ASN1InputStream a2;
    }

    public ASN1InputStream(byte[] a, boolean a2) {
        a3(new ByteArrayInputStream(a), a.length, a2);
        ASN1InputStream a3;
    }

    ASN1EncodableVector case() throws IOException {
        DERObject dERObject;
        ASN1InputStream a;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1InputStream aSN1InputStream = a;
        while ((dERObject = aSN1InputStream.readObject()) != null) {
            aSN1InputStream = a;
            aSN1EncodableVector.add(dERObject);
        }
        return aSN1EncodableVector;
    }

    protected void readFully(byte[] a) throws IOException {
        ASN1InputStream a2;
        if (Streams.readFully(a2, a) != a.length) {
            throw new EOFException(EC5Util.new("n\u0005hkJ\u0002k$Z#]?L;^r_#\t7W:^7ZYr,\u000e<U9R%V"));
        }
    }

    public ASN1InputStream(InputStream a, int a2, boolean a3) {
        ASN1InputStream a4;
        ASN1InputStream aSN1InputStream = a4;
        super(a);
        aSN1InputStream.throws = a2;
        aSN1InputStream.d = a3;
    }

    static int extends(InputStream a, int a2) throws IOException {
        int n = a.read();
        if (n < 0) {
            throw new EOFException(FileLoader.switch("486V1>\u0005\u0018\u0012P\u0016\u000f\u0000\rI\u0003\u0004\t\u001b\u000e\u0018V\u0004\u001f\u001a\t\u0003\u0012\u0012\u0015"));
        }
        if (n == 128) {
            return -1;
        }
        if (n > 127) {
            int n2;
            int n3 = n & 0x7F;
            if (n3 > 4) {
                throw new IOException(new StringBuilder().insert(0, EC5Util.new("\u000ek\u0019\u000f\u0000m%H9AzS1H7\u0016.V&Mk\u001bz\\(A>Lv\b")).append(n3).toString());
            }
            n = 0;
            int n4 = n2 = 0;
            while (n4 < n3) {
                int n5 = a.read();
                if (n5 < 0) {
                    throw new EOFException(FileLoader.switch("590P\u0007\b\u0010\r\rO\u0013\u0002\u001d\u001e\u0019\u0018\u0006G\u0006\t\u000e\u0001\u0003\u0019"));
                }
                n = (n << 8) + n5;
                n4 = ++n2;
            }
            if (n < 0) {
                throw new IOException(EC5Util.new("\u0012z|\u0018\u0003b%P+\u000b9Z9J\rek\u0002mG?Y?N;@?\u001e+F%H.VqS4J\"L"));
            }
            if (n >= a2) {
                throw new IOException(FileLoader.switch("O*1%$:8PWm8\u001e\u001e\u0011\u0013\u001cW]V8$\u0004V\u0019\u0016A\u0005\n\u0016\u0007\u000b\u0012G\u0010\u001f\u001e\u0011\u0015\u000fJ\n\u000f\u0013\u0019\u0015"));
            }
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    static DERObject private(int a, byte[] a2) {
        switch (a) {
            case 3: {
                return DERBitString.volatile(a2);
            }
            case 30: {
                return new DERBMPString(a2);
            }
            case 1: {
                return new ASN1Boolean(a2);
            }
            case 10: {
                return new ASN1Enumerated(a2);
            }
            case 24: {
                return new ASN1GeneralizedTime(a2);
            }
            case 27: {
                return new DERGeneralString(a2);
            }
            case 22: {
                return new DERIA5String(a2);
            }
            case 2: {
                return new ASN1Integer(a2);
            }
            case 5: {
                return DERNull.INSTANCE;
            }
            case 18: {
                return new DERNumericString(a2);
            }
            case 6: {
                return new ASN1ObjectIdentifier(a2);
            }
            case 4: {
                return new DEROctetString(a2);
            }
            case 19: {
                return new DERPrintableString(a2);
            }
            case 20: {
                return new DERT61String(a2);
            }
            case 28: {
                return new DERUniversalString(a2);
            }
            case 23: {
                return new ASN1UTCTime(a2);
            }
            case 12: {
                return new DERUTF8String(a2);
            }
            case 26: {
                return new DERVisibleString(a2);
            }
        }
        return new DERUnknownTag(false, a, a2);
    }

    protected int readLength() throws IOException {
        ASN1InputStream a;
        ASN1InputStream aSN1InputStream = a;
        return ASN1InputStream.extends(aSN1InputStream, aSN1InputStream.throws);
    }

    ASN1EncodableVector true(Prn a) throws IOException {
        return new ASN1InputStream(a).case();
    }
}

