/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AuX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.auX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.cOn;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.coN;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nUl;
import com.jxdinfo.hussar.core.encrypt.file.util.StrKit;
import com.jxdinfo.hussar.core.support.exception.CoreExceptionHandler;
import com.jxdinfo.hussar.core.util.NumUtil;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    protected auX multiplier;
    protected AuX preCompInfo;
    ECFieldElement h;
    ECCurve F;
    ECFieldElement G;
    private static X9IntegerConverter transient = new X9IntegerConverter();
    protected boolean withCompression;

    public ECFieldElement getX() {
        ECPoint a;
        return a.G;
    }

    public abstract byte[] getEncoded();

    public abstract ECPoint negate();

    synchronized void synchronized() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new nUl();
        }
    }

    public abstract ECPoint add(ECPoint var1);

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.G.equals(((ECPoint)a).G) && a2.h.equals(((ECPoint)a).h);
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(CoreExceptionHandler.class("\u001d_*\u0011o\t\u0005c\u0006a\u0010k \\1T0\u001c;G/Q6S`\\=\u0006+^;C4W#N"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.F.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.synchronized();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.char(eCPoint2, a, eCPoint2.preCompInfo);
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.G.hashCode() ^ a.h.hashCode();
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public abstract ECPoint twice();

    void float(AuX a) {
        a.preCompInfo = a;
    }

    public boolean isInfinity() {
        ECPoint a;
        return a.G == null && a.h == null;
    }

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.F = a;
        eCPoint.G = a2;
        eCPoint.h = a3;
    }

    public abstract ECPoint subtract(ECPoint var1);

    public ECCurve getCurve() {
        ECPoint a;
        return a.F;
    }

    public ECFieldElement getY() {
        ECPoint a;
        return a.h;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.interface(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.F, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.G.equals(f2m)) {
                if (a2.h.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.F.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.h.add((ECFieldElement)object).divide(a2.G.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.G).add(f2m).add(a2.F.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.G.add(f2m)).add(f2m).add(a2.h);
            return new F2m(a2.F, f2m, (ECFieldElement)object, a2.withCompression);
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = transient.getByteLength(a.G);
            byte[] byArray = transient.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = transient.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.interface(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(NumUtil.public("-oB7\u00144\u0015m\u0016?\u00007L:H.\u0006r\u0003\u001a!\u001f\"\r}3\u000e5\t2\r9\n=@\fkeJ8\f"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.G, f2m.h);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.G, f2m2.F.getA());
                }
            }
            a5.withCompression = a4;
        }

        private static /* synthetic */ void interface(ECPoint a, ECPoint a2) {
            if (!a.F.equals(a2.F)) {
                throw new IllegalArgumentException(StrKit.while("\u000b\u001a$\u0001}\u001d.\u0018iC?\\%\u0014'C\u00049J)\u0018$#V#\u00055\u00018Mn\\\u0001\u007fyNd\u0015$\u0014\"\u0013}\u0002>\\(\u001e-\u000b:\u0019)\u000e)\u0018"));
            }
        }

        @Override
        synchronized void synchronized() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.F).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new coN();
                    return;
                }
                a.multiplier = new cOn();
            }
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.G.toBigInteger().signum() == 0) {
                return a.F.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.G.add(f2m.h.divide(a.G));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.F.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.F.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.G.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.F, f2m3, eCFieldElement, a.withCompression);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = transient.getByteLength(a.G);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = transient.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = transient.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = transient.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(com.jxdinfo.hussar.core.support.StrKit.long("Yvt&*jd*~qa#w#~z}m3#7KYL\u0013^Largwqm?m<tCCwl"));
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.F, fp.G, a.h.negate(), a.withCompression);
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.h.toBigInteger().signum() == 0) {
                return a.F.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.F.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.F.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.G.square().multiply(eCFieldElement2).add(a.F.G).divide(a.h.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.G.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.G.subtract(eCFieldElement2)).subtract(a.h);
            return new Fp(a.F, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        @Override
        synchronized void synchronized() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new cOn();
            }
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.G.equals(a.G)) {
                if (a2.h.equals(a.h)) {
                    return a2.twice();
                }
                return a2.F.getInfinity();
            }
            ECFieldElement eCFieldElement = a.h.subtract(a2.h).divide(a.G.subtract(a2.G));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.G).subtract(a.G);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.G.subtract(eCFieldElement2)).subtract(a2.h);
            return new Fp(a2.F, eCFieldElement2, eCFieldElement3);
        }
    }
}

