/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.auto.common.TypeHelper;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nUL;
import com.jxdinfo.hussar.core.encrypt.file.util.StrKit;
import com.jxdinfo.hussar.core.util.ClassUtil;
import com.jxdinfo.hussar.core.util.CookieUtils;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract int getFieldSize();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement invert();

    public abstract BigInteger toBigInteger();

    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract ECFieldElement square();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract String getFieldName();

    public abstract ECFieldElement negate();

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement sqrt();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private int f;
        private int B;
        private int b;
        private int h;
        private int F;
        private nUL G;
        public static final int PPB = 3;
        private int short;
        public static final int GNB = 1;
        public static final int TPB = 2;

        public int getRepresentation() {
            F2m a;
            return a.B;
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, nUL a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.h = a + 31 >> 5;
            f2m3.G = a5;
            f2m2.short = a;
            f2m2.f = a2;
            f2m.b = a3;
            f2m.F = a4;
            if (a3 == 0 && a4 == 0) {
                a6.B = 2;
                return;
            }
            a6.B = 3;
        }

        public int hashCode() {
            F2m a;
            return a.G.hashCode() ^ a.short ^ a.f ^ a.b ^ a.F;
        }

        @Override
        public String getFieldName() {
            return StrKit.while("2~\u0011");
        }

        public int getK2() {
            F2m a;
            return a.b;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.G.assert(((F2m)object).G, a2.short);
            int[] nArray = new int[3];
            nArray[0] = a2.f;
            nArray[1] = a2.b;
            nArray[2] = a2.F;
            ((nUL)object).public(a2.short, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.short, f2m.f, f2m2.b, f2m2.F, (nUL)object);
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.short;
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(StrKit.while("s\u0000+;B)\u00046\u000f5\r5\u001f8\t"));
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            nUL nUL2 = (nUL)a2.G.clone();
            F2m f2m = (F2m)a;
            nUL2.while(f2m.G, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.short, f2m2.f, f2m3.b, f2m3.F, nUL2);
        }

        public int getK3() {
            F2m a;
            return a.F;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            nUL nUL2 = f2m.G.void(f2m.short);
            int[] nArray = new int[3];
            nArray[0] = a.f;
            nArray[1] = a.b;
            nArray[2] = a.F;
            nUL2.public(a.short, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.short, f2m2.f, f2m3.b, f2m3.F, nUL2);
        }

        public int getK1() {
            F2m a;
            return a.f;
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        public int getM() {
            F2m a;
            return a.short;
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(ClassUtil.static("GnEBm\u0007eCmJeB\u007fE1\u00073a\u0003\u001e8[(Ci^e\u0007iOu]oj@N\u007f\u0007oH)cBAIKeCECmJeB\u007f\u0018W\u0003{"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.short != f2m2.short || f2m.f != f2m2.f || f2m.b != f2m2.b || f2m.F != f2m2.F) {
                throw new IllegalArgumentException(StrKit.while(":-\u0011 \u0018g\u00121\b`X\u0001+h\u000b%\u0006/Z/\u001e8\\/\u0016'\u001f\n14\u0003l\u0013#U9\u0015\t|6\u0014!\u0019d\u0012%\u0019+\u0013}+h\u0007"));
            }
            if (f2m.B != f2m2.B) {
                throw new IllegalArgumentException(ClassUtil.static("ooC$LM,ShK)@hbLJ)BlJeBnXx\u0016p\u0014$$M\u001f#\u000fmMcGhItR&Aow\u0003BbDo\\{Cbs\u0000\\lWrJ{BnXjBx^x"));
            }
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.h = a + 31 >> 5;
            F2m f2m = a6;
            a6.G = new nUL(a5, a6.h);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.B = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(ClassUtil.static("L2\ffCb\u0012afFP$Bi\u00125N~\f\u007fCmX1\u0017h"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(StrKit.while(",E}\u0000xN\u001b\u007fyNd\u0018tW'\u00155W4\u0018<\u00037\u0017"));
                }
                a6.B = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(ClassUtil.static("_ ZjZd\u0003agB\u001e9@|^;N,BnLmBx\n>"));
            }
            F2m f2m2 = a6;
            a6.short = a;
            f2m2.f = a2;
            f2m2.b = a3;
            a6.F = a4;
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.short == f2m.short && a2.f == f2m.f && a2.b == f2m.b && a2.F == f2m.F && a2.B == f2m.B && a2.G.equals(f2m.G);
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            nUL nUL2 = (nUL)a.G.clone();
            nUL nUL3 = new nUL(a.h);
            F2m f2m = a;
            nUL nUL4 = nUL3;
            nUL4.new(a.short);
            nUL4.new(0);
            nUL3.new(f2m.f);
            if (f2m.B == 3) {
                nUL nUL5 = nUL3;
                nUL5.new(a.b);
                nUL5.new(a.F);
            }
            nUL nUL6 = new nUL(a.h);
            nUL6.new(0);
            nUL nUL7 = new nUL(a.h);
            nUL nUL8 = nUL2;
            while (!nUL8.int()) {
                int n = nUL2.class() - nUL3.class();
                if (n < 0) {
                    nUL nUL9 = nUL2;
                    nUL2 = nUL3;
                    nUL3 = nUL9;
                    nUL nUL10 = nUL6;
                    nUL6 = nUL7;
                    nUL7 = nUL10;
                    n = -n;
                }
                int n2 = n >> 5;
                nUL nUL11 = nUL3.native(n &= 0x1F);
                nUL nUL12 = nUL2;
                nUL8 = nUL12;
                nUL12.while(nUL11, n2);
                nUL nUL13 = nUL7.native(n);
                nUL6.while(nUL13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.short, f2m2.f, f2m3.b, f2m3.F, nUL7);
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.G.for();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger G;
        BigInteger continue;

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.G, fp.continue.add(a.toBigInteger()).mod(a2.G));
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.G, fp.continue.negate().mod(a.G));
        }

        public BigInteger getQ() {
            Fp a;
            return a.G;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.G, fp.continue.multiply(a.toBigInteger().modInverse(a2.G)).mod(a2.G));
        }

        public int hashCode() {
            Fp a;
            return a.G.hashCode() ^ a.continue.hashCode();
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.G.testBit(0)) {
                throw new RuntimeException(TypeHelper.short(".D?\u00005Uo\u000fCq0J"));
            }
            if (a.G.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.G, fp.continue.modPow(a.G.shiftRight(2).add(ECConstants.ONE), a.G));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.G.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.continue.modPow(bigInteger2, a.G).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.continue;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.G);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.G.bitLength(), random)).compareTo(a.G) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.G).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.final(a.G, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.G).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.G);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.G, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        private static /* synthetic */ BigInteger[] final(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public String getFieldName() {
            return CookieUtils.private("@S");
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.G.equals(fp.G) && a2.continue.equals(fp.continue);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.G, fp.continue.multiply(a.toBigInteger()).mod(a2.G));
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.G, fp.continue.modInverse(a.G));
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.G, fp.continue.subtract(a.toBigInteger()).mod(a2.G));
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.G, fp.continue.multiply(a.continue).mod(a.G));
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.continue;
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.continue = a2;
            if (a3.continue.compareTo(a) >= 0) {
                throw new IllegalArgumentException(TypeHelper.short("\u0018+\u0010l\u000f})\u00074D&\u0002-K\u0012l,\u0002)EhE)N'Dq_m\u000f\u000em;J"));
            }
            a3.G = a;
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.G.bitLength();
        }
    }
}

