/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1.x509;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Encodable;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1EncodableVector;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Sequence;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1TaggedObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEREncodable;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERNull;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERSequence;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.util.LicenseInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlgorithmIdentifier
extends ASN1Encodable {
    private boolean F;
    private DEREncodable G;
    private DERObjectIdentifier strictfp;

    public static AlgorithmIdentifier getInstance(ASN1TaggedObject a, boolean a2) {
        return AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(a, a2));
    }

    @Override
    public DERObject toASN1Object() {
        AlgorithmIdentifier a;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        AlgorithmIdentifier algorithmIdentifier = a;
        aSN1EncodableVector.add(algorithmIdentifier.strictfp);
        if (algorithmIdentifier.F) {
            if (a.G != null) {
                aSN1EncodableVector.add(a.G);
            } else {
                aSN1EncodableVector.add(DERNull.INSTANCE);
            }
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public ASN1ObjectIdentifier getAlgorithm() {
        AlgorithmIdentifier a;
        return new ASN1ObjectIdentifier(a.strictfp.getId());
    }

    public DERObjectIdentifier getObjectId() {
        AlgorithmIdentifier a;
        return a.strictfp;
    }

    public static AlgorithmIdentifier getInstance(Object a) {
        if (a == null || a instanceof AlgorithmIdentifier) {
            return (AlgorithmIdentifier)a;
        }
        if (a instanceof DERObjectIdentifier) {
            return new AlgorithmIdentifier((DERObjectIdentifier)a);
        }
        if (a instanceof String) {
            return new AlgorithmIdentifier((String)a);
        }
        if (a instanceof ASN1Sequence) {
            return new AlgorithmIdentifier((ASN1Sequence)a);
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, X9IntegerConverter.return("\u001d}\u001ea\u0006}\u0002\u000e'a\u000fg\u0007}Oz\u001b.\u000e`\u0004z\u0007p\u001d/S")).append(a.getClass().getName()).toString());
    }

    public AlgorithmIdentifier(ASN1Sequence a) {
        AlgorithmIdentifier a2;
        a2.F = false;
        if (a.size() < 1 || a.size() > 2) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, LicenseInfo.return("-j&*0d9n7h,l`u&p&'t")).append(a.size()).toString());
        }
        a2.strictfp = DERObjectIdentifier.getInstance(a.getObjectAt(0));
        if (a.size() == 2) {
            AlgorithmIdentifier algorithmIdentifier = a2;
            algorithmIdentifier.F = true;
            algorithmIdentifier.G = a.getObjectAt(1);
            return;
        }
        a2.G = null;
    }

    public AlgorithmIdentifier(DERObjectIdentifier a) {
        AlgorithmIdentifier a2;
        AlgorithmIdentifier algorithmIdentifier = a2;
        algorithmIdentifier.F = false;
        algorithmIdentifier.strictfp = a;
    }

    public AlgorithmIdentifier(DERObjectIdentifier a, DEREncodable a2) {
        AlgorithmIdentifier a3;
        AlgorithmIdentifier algorithmIdentifier = a3;
        AlgorithmIdentifier algorithmIdentifier2 = a3;
        algorithmIdentifier2.F = false;
        algorithmIdentifier2.F = true;
        algorithmIdentifier.strictfp = a;
        algorithmIdentifier.G = a2;
    }

    public DEREncodable getParameters() {
        AlgorithmIdentifier a;
        return a.G;
    }

    public AlgorithmIdentifier(String a) {
        AlgorithmIdentifier a2;
        a2.F = false;
        AlgorithmIdentifier algorithmIdentifier = a2;
        a2.strictfp = new DERObjectIdentifier(a);
    }
}

