/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.banner;

import com.jxdinfo.hussar.core.banner.AbstractHussarBanner;
import java.io.InputStream;
import java.util.Formatter;
import java.util.Properties;
import org.springframework.core.env.Environment;

public class HussarTongWebBanner
extends AbstractHussarBanner {
    @Override
    protected void injectEnvironmentInfoIntoBanner(Formatter formatter, Environment environment, Class<?> clazz) {
        formatter.format("TongWeb Version: %s%n", this.getVersion());
        formatter.format("%s%n", LINE_SEPARATOR);
    }

    @Override
    protected boolean check() {
        try {
            this.getClass().getClassLoader().loadClass("com.tongweb.container.util.ServerInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public int getOrder() {
        return 4;
    }

    private String getVersion() {
        String string = null;
        try {
            Properties properties = new Properties();
            InputStream inputStream = this.getClass().getResourceAsStream("/com/tongweb/container/util/ServerInfo.properties");
            properties.load(inputStream);
            string = properties.getProperty("server.info");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null || string.equals("PRODUCT_VERSION")) {
            string = "TongWeb/7.0.0";
        }
        return string;
    }
}

