/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AUX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.COn;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.Con;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.aUX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nuL;
import com.jxdinfo.hussar.core.support.ObjectKit;
import com.jxdinfo.hussar.core.support.StrKit;
import com.jxdinfo.hussar.core.util.FileLoader;
import com.jxdinfo.hussar.core.util.NumUtil;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    ECFieldElement d;
    protected COn preCompInfo;
    ECFieldElement I;
    protected boolean withCompression;
    ECCurve M;
    private static X9IntegerConverter public = new X9IntegerConverter();
    protected Con multiplier;

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.d.equals(((ECPoint)a).d) && a2.I.equals(((ECPoint)a).I);
    }

    public abstract ECPoint negate();

    public ECFieldElement getX() {
        ECPoint a;
        return a.d;
    }

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.M = a;
        eCPoint.d = a2;
        eCPoint.I = a3;
    }

    public abstract ECPoint subtract(ECPoint var1);

    public boolean isInfinity() {
        ECPoint a;
        if (a.d == null && a.I == null) {
            return true;
        }
        return false;
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public abstract ECPoint add(ECPoint var1);

    public ECCurve getCurve() {
        ECPoint a;
        return a.M;
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(NumUtil.private("Zzm4(,BFADWNgyvqw9|bhtqv'yz#l{|fsrdk"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.M.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.else();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.false(eCPoint2, a, eCPoint2.preCompInfo);
    }

    synchronized void else() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new nuL();
        }
    }

    public ECFieldElement getY() {
        ECPoint a;
        return a.I;
    }

    void synchronized(COn a) {
        a.preCompInfo = a;
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.d.hashCode() ^ a.I.hashCode();
    }

    public abstract byte[] getEncoded();

    public abstract ECPoint twice();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = public.getByteLength(a.d);
            byte[] byArray = public.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = public.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.assert(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(StrKit.interface("\u0013A|\u0019*\u001a+C(\u0011>\u0019r\u0014v\u00008\\=4\u001f1\u001c#C\u001d0\u001b7\u001c3\u00174\u0013~\"UKt\u00162"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.d, f2m.I);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.d, f2m2.M.getA());
                }
            }
            a5.withCompression = a4;
        }

        @Override
        synchronized void else() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.M).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new AUX();
                    return;
                }
                a.multiplier = new aUX();
            }
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.assert(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        private static /* synthetic */ void assert(ECPoint a, ECPoint a2) {
            if (!a.M.equals(a2.M)) {
                throw new IllegalArgumentException(FileLoader.implements("\u0003Y)G.\u0005\"_/N'\u000f'].\u0001-[cKo\u0018\u0000>\u0000m\u0002}*\u0014*S \u00156J$\u001e\u0002yw\rmY3\u001a ]1\\7_1]1K"));
            }
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.M, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.d.toBigInteger().signum() == 0) {
                return a.M.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.d.add(f2m.I.divide(a.d));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.M.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.M.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.d.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.M, f2m3, eCFieldElement, a.withCompression);
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.d.equals(f2m)) {
                if (a2.I.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.M.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.I.add((ECFieldElement)object).divide(a2.d.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.d).add(f2m).add(a2.M.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.d.add(f2m)).add(f2m).add(a2.I);
            return new F2m(a2.M, f2m, (ECFieldElement)object, a2.withCompression);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        synchronized void else() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new aUX();
            }
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.M, fp.d, a.I.negate(), a.withCompression);
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.I.toBigInteger().signum() == 0) {
                return a.M.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.M.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.M.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.d.square().multiply(eCFieldElement2).add(a.M.transient).divide(a.I.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.d.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.d.subtract(eCFieldElement2)).subtract(a.I);
            return new Fp(a.M, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.d.equals(a.d)) {
                if (a2.I.equals(a.I)) {
                    return a2.twice();
                }
                return a2.M.getInfinity();
            }
            ECFieldElement eCFieldElement = a.I.subtract(a2.I).divide(a.d.subtract(a2.d));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.d).subtract(a.d);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.d.subtract(eCFieldElement2)).subtract(a2.I);
            return new Fp(a2.M, eCFieldElement2, eCFieldElement3);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(ObjectKit.new("is\u000b#U*^+\u0005\u000edFh\u00134>C)\r-C4\\e@\u0006n0Y|\u00168^kC?\r?Ew\u0016"));
            }
            a5.withCompression = a4;
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = public.getByteLength(a.d);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = public.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = public.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = public.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }
    }
}

