/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.banner.EmbeddedContainerUtils;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.ECUtil;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.NUl;
import com.jxdinfo.hussar.core.support.ObjectKit;
import com.jxdinfo.hussar.core.util.PingYinUtil;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement square();

    public abstract ECFieldElement negate();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement sqrt();

    public abstract ECFieldElement add(ECFieldElement var1);

    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract int getFieldSize();

    public abstract String getFieldName();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private int g;
        private NUl j;
        public static final int GNB = 1;
        private int E;
        private int d;
        private int I;
        public static final int PPB = 3;
        private int M;
        public static final int TPB = 2;
        private int default;

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            NUl nUl2 = f2m.j.byte(f2m.E);
            int[] nArray = new int[3];
            nArray[0] = a.g;
            nArray[1] = a.default;
            nArray[2] = a.I;
            nUl2.for(a.E, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.E, f2m2.g, f2m3.default, f2m3.I, nUl2);
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            NUl nUl2 = (NUl)a.j.clone();
            NUl nUl3 = new NUl(a.d);
            F2m f2m = a;
            NUl nUl4 = nUl3;
            nUl4.package(a.E);
            nUl4.package(0);
            nUl3.package(f2m.g);
            if (f2m.M == 3) {
                NUl nUl5 = nUl3;
                nUl5.package(a.default);
                nUl5.package(a.I);
            }
            NUl nUl6 = new NUl(a.d);
            nUl6.package(0);
            NUl nUl7 = new NUl(a.d);
            NUl nUl8 = nUl2;
            while (!nUl8.transient()) {
                int n = nUl2.float() - nUl3.float();
                if (n < 0) {
                    NUl nUl9 = nUl2;
                    nUl2 = nUl3;
                    nUl3 = nUl9;
                    NUl nUl10 = nUl6;
                    nUl6 = nUl7;
                    nUl7 = nUl10;
                    n = -n;
                }
                int n2 = n >> 5;
                NUl nUl11 = nUl3.for(n &= 0x1F);
                NUl nUl12 = nUl2;
                nUl8 = nUl12;
                nUl12.transient(nUl11, n2);
                NUl nUl13 = nUl7.for(n);
                nUl6.transient(nUl13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.E, f2m2.g, f2m3.default, f2m3.I, nUl7);
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        public int hashCode() {
            F2m a;
            return a.j.hashCode() ^ a.E ^ a.g ^ a.default ^ a.I;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        public int getK3() {
            F2m a;
            return a.I;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.j.synchronized(((F2m)object).j, a2.E);
            int[] nArray = new int[3];
            nArray[0] = a2.g;
            nArray[1] = a2.default;
            nArray[2] = a2.I;
            ((NUl)object).for(a2.E, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.E, f2m.g, f2m2.default, f2m2.I, (NUl)object);
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(ECUtil.default("\u0017xOC&Q`NkMiM{@m"));
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.d = a + 31 >> 5;
            F2m f2m = a6;
            a6.j = new NUl(a5, a6.d);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.M = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(EmbeddedContainerUtils.default("P\u0006\u0013QgnO\u0014PX\u001aF_\\UZF^S\by\u007f\u000bJQ\u0006"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(ECUtil.default("T!\u0005d\u0000*c\u001b\u0001*\u001c|\f3_qM3L|DgOs"));
                }
                a6.M = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(EmbeddedContainerUtils.default("C\u0014E]~h^\u0014Q\\T[]I\u0019TF\f\u001d\u0019v\u007f\u0011\u0003LP"));
            }
            F2m f2m2 = a6;
            a6.E = a;
            f2m2.g = a2;
            f2m2.default = a3;
            a6.I = a4;
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.E;
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(EmbeddedContainerUtils.default("jRQ^YY\u0013VP[\\MXL\u0010\u0018\u0004W\u001dZT\rVpr`s1wPBF\\UWVO2r]\u0014w~|\\WQ]sOI\u001e\u0019\u007fjK,\bX"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.E != f2m2.E || f2m.g != f2m2.g || f2m.default != f2m2.default || f2m.I != f2m2.I) {
                throw new IllegalArgumentException(ECUtil.default("^UuX|\u001fvIl\u0018<yO\u0010o]bW>Wz@8Wr_{rULg\u0014w[1Aqq\u0018NpY}\u001cv]}Sw\u0005O\u0010c"));
            }
            if (f2m.M != f2m2.M) {
                throw new IllegalArgumentException(EmbeddedContainerUtils.default("yZ^\u000eNR\u001bBQA\u000bEE^XV\u001d\u001c\u001a_XSWW_\u001fQ\u000b\u0013\u0012S[OY\u0013~xy~\u007fjM\u0011Z\\H\u0014ZRqrIFW^N\u0015@XIDF_\u0016\u0012e\u007f\u0011\u0003U["));
            }
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.j.null();
        }

        public int getK1() {
            F2m a;
            return a.g;
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.E == f2m.E && a2.g == f2m.g && a2.default == f2m.default && a2.I == f2m.I && a2.M == f2m.M && a2.j.equals(f2m.j);
        }

        public int getK2() {
            F2m a;
            return a.default;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            NUl nUl2 = (NUl)a2.j.clone();
            F2m f2m = (F2m)a;
            nUl2.transient(f2m.j, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.E, f2m2.g, f2m3.default, f2m3.I, nUl2);
        }

        public int getRepresentation() {
            F2m a;
            return a.M;
        }

        public int getM() {
            F2m a;
            return a.E;
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, NUl a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.d = a + 31 >> 5;
            f2m3.j = a5;
            f2m2.E = a;
            f2m2.g = a2;
            f2m.default = a3;
            f2m.I = a4;
            if (a3 == 0 && a4 == 0) {
                a6.M = 2;
                return;
            }
            a6.M = 3;
        }

        @Override
        public String getFieldName() {
            return ECUtil.default("V\u0006u");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger M;
        BigInteger package;

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.M, fp.package.negate().mod(a.M));
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.package;
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.package = a2;
            if (a3.package.compareTo(a) >= 0) {
                throw new IllegalArgumentException(PingYinUtil.short("ApI7V&p\\m\u001f\u007fYt\u0010K7uYp\u001e1\u001ep\u0015~\u001f(\u00044TW6b\u0011"));
            }
            a3.M = a;
        }

        public int hashCode() {
            Fp a;
            return a.M.hashCode() ^ a.package.hashCode();
        }

        public BigInteger getQ() {
            Fp a;
            return a.M;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.M, fp.package.add(a.toBigInteger()).mod(a2.M));
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.M.bitLength();
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.M, fp.package.multiply(a.toBigInteger().modInverse(a2.M)).mod(a2.M));
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.M, fp.package.multiply(a.package).mod(a.M));
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.M, fp.package.subtract(a.toBigInteger()).mod(a2.M));
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.M.equals(fp.M) && a2.package.equals(fp.package);
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.M, fp.package.modInverse(a.M));
        }

        private static /* synthetic */ BigInteger[] short(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.M.testBit(0)) {
                throw new RuntimeException(PingYinUtil.short("w\u001ff[l\u000e6T\u001a*i\u0011"));
            }
            if (a.M.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.M, fp.package.modPow(a.M.shiftRight(2).add(ECConstants.ONE), a.M));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.M.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.package.modPow(bigInteger2, a.M).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.package;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.M);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.M.bitLength(), random)).compareTo(a.M) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.M).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.short(a.M, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.M).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.M);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.M, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.M, fp.package.multiply(a.toBigInteger()).mod(a2.M));
        }

        @Override
        public String getFieldName() {
            return ObjectKit.new("\u0006Q");
        }
    }
}

