/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.config;

import com.jxdinfo.hussar.core.config.HussarConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.HttpConstraintElement;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.Servlet;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Servlet.class, Server.class, Loader.class, WebAppContext.class})
public class JettyServletWebServerFactoryConfig {
    @Autowired
    private HussarConfig hussarConfig;

    @Bean
    @ConditionalOnClass(value={Servlet.class, Server.class, Loader.class, WebAppContext.class})
    WebServerFactoryCustomizer<JettyServletWebServerFactory> acoolyWebServerFactoryCustomizer() {
        return jettyServletWebServerFactory -> jettyServletWebServerFactory.addServerCustomizers(new JettyServerCustomizer[]{server -> {
            Object object2;
            ServletSecurityElement servletSecurityElement;
            HttpConstraintElement httpConstraintElement = new HttpConstraintElement(ServletSecurity.EmptyRoleSemantic.PERMIT);
            HttpMethodConstraintElement httpMethodConstraintElement = new HttpMethodConstraintElement(HttpMethod.POST.name(), httpConstraintElement);
            HttpMethodConstraintElement httpMethodConstraintElement2 = new HttpMethodConstraintElement(HttpMethod.GET.name(), httpConstraintElement);
            HashSet<HttpMethodConstraintElement> hashSet = new HashSet<HttpMethodConstraintElement>();
            hashSet.add(httpMethodConstraintElement2);
            hashSet.add(httpMethodConstraintElement);
            if (this.hussarConfig != null && (servletSecurityElement = this.hussarConfig.getAllowHttpMethods()) != null) {
                for (Object object2 : servletSecurityElement) {
                    if (!this.checkMethodNames(hashSet, (String)object2)) continue;
                    hashSet.add(new HttpMethodConstraintElement((String)object2, httpConstraintElement));
                }
            }
            servletSecurityElement = new ServletSecurityElement(hashSet);
            List list = ConstraintSecurityHandler.createConstraintsWithMappingsForPath((String)"allow", (String)"/*", (ServletSecurityElement)servletSecurityElement);
            object2 = new ConstraintSecurityHandler();
            object2.setDenyUncoveredHttpMethods(true);
            object2.setConstraintMappings(list);
            server.insertHandler((HandlerWrapper)object2);
        }});
    }

    private boolean checkMethodNames(Collection<HttpMethodConstraintElement> collection, String string) {
        for (HttpMethodConstraintElement httpMethodConstraintElement : collection) {
            String string2 = httpMethodConstraintElement.getMethodName();
            if (!string2.equals(string)) continue;
            return false;
        }
        return true;
    }
}

