/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1StreamParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.NUL;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.Prn;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.cOn;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nUL;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.prn;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.support.ClassKit;
import com.jxdinfo.hussar.core.support.exception.CoreExceptionHandler;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    protected boolean withCompression;
    protected cOn preCompInfo;
    ECFieldElement G;
    ECFieldElement b;
    private static X9IntegerConverter k = new X9IntegerConverter();
    ECCurve volatile;
    protected Prn multiplier;

    public abstract ECPoint negate();

    public ECFieldElement getY() {
        ECPoint a;
        return a.b;
    }

    public boolean isInfinity() {
        ECPoint a;
        return a.G == null && a.b == null;
    }

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint twice();

    synchronized void enum() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new prn();
        }
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public ECFieldElement getX() {
        ECPoint a;
        return a.G;
    }

    public abstract ECPoint add(ECPoint var1);

    void switch(cOn a) {
        a.preCompInfo = a;
    }

    public ECCurve getCurve() {
        ECPoint a;
        return a.volatile;
    }

    public abstract byte[] getEncoded();

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.G.hashCode() ^ a.b.hashCode();
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(CoreExceptionHandler.char("Y\u000eaO\"Q`\u0013i\u001by\u0017j\u0003;KvOa\b!JK;\u0002+Tz`\u0000o\u0002{\rc\u001b"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.volatile.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.enum();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.extends(eCPoint2, a, eCPoint2.preCompInfo);
    }

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.G.equals(((ECPoint)a).G) && a2.b.equals(((ECPoint)a).b);
    }

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.volatile = a;
        eCPoint.G = a2;
        eCPoint.b = a3;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.G.toBigInteger().signum() == 0) {
                return a.volatile.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.G.add(f2m.b.divide(a.G));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.volatile.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.volatile.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.G.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.volatile, f2m3, eCFieldElement, a.withCompression);
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.G.equals(f2m)) {
                if (a2.b.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.volatile.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.b.add((ECFieldElement)object).divide(a2.G.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.G).add(f2m).add(a2.volatile.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.G.add(f2m)).add(f2m).add(a2.b);
            return new F2m(a2.volatile, f2m, (ECFieldElement)object, a2.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.char(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        @Override
        synchronized void enum() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.volatile).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new nUL();
                    return;
                }
                a.multiplier = new NUL();
            }
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.char(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.volatile, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        private static /* synthetic */ void char(ECPoint a, ECPoint a2) {
            if (!a.volatile.equals(a2.volatile)) {
                throw new IllegalArgumentException(ClassKit.throw("N)w$!7l,\u007f#epa&'5$o/:b(spi9>|bab&\"*E\u0004\u0001\u0006V\u0010h/+\"~je%$tV\u00033bj-"));
            }
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(HussarException.class("\u0004KkVx\u001483E{I&P_ Kn]!Dr\u0017't\t\u00011^o\u000f=Ku\u0018hL&Ln\u0004="));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.G, f2m.b);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.G, f2m2.volatile.getA());
                }
            }
            a5.withCompression = a4;
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = k.getByteLength(a.G);
            byte[] byArray = k.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = k.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        /*
         * WARNING - void declaration
         */
        @Override
        public ECPoint subtract(ECPoint eCPoint) {
            Fp a;
            void a2;
            if (a2.isInfinity()) {
                return a;
            }
            return a.add(a2.negate());
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.b.toBigInteger().signum() == 0) {
                return a.volatile.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.volatile.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.volatile.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.G.square().multiply(eCFieldElement2).add(a.volatile.k).divide(a.b.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.G.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.G.subtract(eCFieldElement2)).subtract(a.b);
            return new Fp(a.volatile, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(ASN1StreamParser.volatile("qL\u0013\u001cM\u0015F\u0014\u001d1|yp,,\u0001[\u0016\u0015\u0012[\u000bDZX9v\u000fAC\u000e\u0007FT[\u0000\u0015\u0000]H\u000e"));
            }
            a5.withCompression = a4;
        }

        @Override
        synchronized void enum() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new NUL();
            }
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.G.equals(a.G)) {
                if (a2.b.equals(a.b)) {
                    return a2.twice();
                }
                return a2.volatile.getInfinity();
            }
            ECFieldElement eCFieldElement = a.b.subtract(a2.b).divide(a.G.subtract(a2.G));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.G).subtract(a.G);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.G.subtract(eCFieldElement2)).subtract(a2.b);
            return new Fp(a2.volatile, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.volatile, fp.G, a.b.negate(), a.withCompression);
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = k.getByteLength(a.G);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = k.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = k.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = k.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }
    }
}

