/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.HussarCoreAutoConfiguration;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.ECUtil;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CON;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.encrypt.file.util.StrKit;
import com.jxdinfo.hussar.core.feign.TicketRequestBody;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement add(ECFieldElement var1);

    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract String getFieldName();

    public abstract int getFieldSize();

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement invert();

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement square();

    public abstract ECFieldElement negate();

    public abstract ECFieldElement sqrt();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private CON C;
        private int D;
        public static final int PPB = 3;
        private int K;
        public static final int GNB = 1;
        private int G;
        public static final int TPB = 2;
        private int b;
        private int k;
        private int return;

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            CON cON2 = (CON)a2.C.clone();
            F2m f2m = (F2m)a;
            cON2.byte(f2m.C, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.k, f2m2.G, f2m3.b, f2m3.K, cON2);
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            CON cON2 = f2m.C.try(f2m.k);
            int[] nArray = new int[3];
            nArray[0] = a.G;
            nArray[1] = a.b;
            nArray[2] = a.K;
            cON2.break(a.k, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.k, f2m2.G, f2m3.b, f2m3.K, cON2);
        }

        public int getM() {
            F2m a;
            return a.k;
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.k == f2m.k && a2.G == f2m.G && a2.b == f2m.b && a2.K == f2m.K && a2.D == f2m.D && a2.C.equals(f2m.C);
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(HussarCoreAutoConfiguration.private("5\u00007,\u001fi\u0017-\u001f$\u0017,\r+CiA\u000fqpJ5Z-\u001b0\u0017i\u001b!\u00073\u001d\u00042 \ri\u001d&[\r0/;%\u0017-7-\u001f$\u0017,\rv%m\t"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.k != f2m2.k || f2m.G != f2m2.G || f2m.b != f2m2.b || f2m.K != f2m2.K) {
                throw new IllegalArgumentException(StrKit.public("\u0014(?%6b<4&ev\u0004\u0005m% (*t*0=r*8\"1\u000f\u001f1-i=&{<;\fR3:$7a< 7.=x\u0005m)"));
            }
            if (f2m.D != f2m2.D) {
                throw new IllegalArgumentException(HussarCoreAutoConfiguration.private("\u001d\u00011J>#^=\u001a%[.\u001a\f>$[,\u001e$\u0017,\u001c6\nx\u0002zVJ?qQa\u001f#\u0011)\u001a'\u0006<T/\u001d\u0019q,\u0010*\u001d2\t-\u0010\u001dr2\u001e9\u0000$\t,\u001c6\u0018,\n0\n"));
            }
        }

        public int getRepresentation() {
            F2m a;
            return a.D;
        }

        public int hashCode() {
            F2m a;
            return a.C.hashCode() ^ a.k ^ a.G ^ a.b ^ a.K;
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.C.short();
        }

        public int getK3() {
            F2m a;
            return a.K;
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.return = a + 31 >> 5;
            F2m f2m = a6;
            a6.C = new CON(a5, a6.return);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.D = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(HussarCoreAutoConfiguration.private("\"@b\u0014-\u0010|\u0013\b4>V,\u001b|G \fb\r-\u001f6Cy\u001a"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(StrKit.public(")kx.}`\u001eQ|`a6qy\";0y169-29"));
                }
                a6.D = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(HussarCoreAutoConfiguration.private("1R4\u00184\u0016m\u0013\t0pK.\u000e0I ^,\u001c\"\u001f,\ndL"));
            }
            F2m f2m2 = a6;
            a6.k = a;
            f2m2.G = a2;
            f2m2.b = a3;
            a6.K = a4;
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(StrKit.public("]\u0005\u0005>l,*3!0#01='"));
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            CON cON2 = (CON)a.C.clone();
            CON cON3 = new CON(a.return);
            F2m f2m = a;
            CON cON4 = cON3;
            cON4.else(a.k);
            cON4.else(0);
            cON3.else(f2m.G);
            if (f2m.D == 3) {
                CON cON5 = cON3;
                cON5.else(a.b);
                cON5.else(a.K);
            }
            CON cON6 = new CON(a.return);
            cON6.else(0);
            CON cON7 = new CON(a.return);
            CON cON8 = cON2;
            while (!cON8.false()) {
                int n = cON2.double() - cON3.double();
                if (n < 0) {
                    CON cON9 = cON2;
                    cON2 = cON3;
                    cON3 = cON9;
                    CON cON10 = cON6;
                    cON6 = cON7;
                    cON7 = cON10;
                    n = -n;
                }
                int n2 = n >> 5;
                CON cON11 = cON3.false(n &= 0x1F);
                CON cON12 = cON2;
                cON8 = cON12;
                cON12.byte(cON11, n2);
                CON cON13 = cON7.false(n);
                cON6.byte(cON13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.k, f2m2.G, f2m3.b, f2m3.K, cON7);
        }

        @Override
        public String getFieldName() {
            return StrKit.public("\u001c{?");
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.C.instanceof(((F2m)object).C, a2.k);
            int[] nArray = new int[3];
            nArray[0] = a2.G;
            nArray[1] = a2.b;
            nArray[2] = a2.K;
            ((CON)object).break(a2.k, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.k, f2m.G, f2m2.b, f2m2.K, (CON)object);
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.k;
        }

        public int getK2() {
            F2m a;
            return a.b;
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, CON a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.return = a + 31 >> 5;
            f2m3.C = a5;
            f2m2.k = a;
            f2m2.G = a2;
            f2m.b = a3;
            f2m.K = a4;
            if (a3 == 0 && a4 == 0) {
                a6.D = 2;
                return;
            }
            a6.D = 3;
        }

        public int getK1() {
            F2m a;
            return a.G;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger k;
        BigInteger interface;

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.interface, fp.k.negate().mod(a.interface));
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.k = a2;
            if (a3.k.compareTo(a) >= 0) {
                throw new IllegalArgumentException(TicketRequestBody.char("#S+\u00144\u0005\u0012\u007f\u000f<\u001dz\u00163)\u0014\u0017z\u0012=S=\u00126\u001c<J'Vw5\u0015\u00002"));
            }
            a3.interface = a;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.interface, fp.k.multiply(a.toBigInteger().modInverse(a2.interface)).mod(a2.interface));
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.interface.testBit(0)) {
                throw new RuntimeException(TicketRequestBody.char("\u0015<\u0004x\u000e-Twx\t\u000b2"));
            }
            if (a.interface.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.interface, fp.k.modPow(a.interface.shiftRight(2).add(ECConstants.ONE), a.interface));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.interface.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.k.modPow(bigInteger2, a.interface).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.k;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.interface);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.interface.bitLength(), random)).compareTo(a.interface) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.interface).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.super(a.interface, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.interface).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.interface);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.interface, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.interface, fp.k.multiply(a.k).mod(a.interface));
        }

        public BigInteger getQ() {
            Fp a;
            return a.interface;
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.interface, fp.k.modInverse(a.interface));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.interface, fp.k.multiply(a.toBigInteger()).mod(a2.interface));
        }

        private static /* synthetic */ BigInteger[] super(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        public int hashCode() {
            Fp a;
            return a.interface.hashCode() ^ a.k.hashCode();
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.interface.equals(fp.interface) && a2.k.equals(fp.k);
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.interface, fp.k.add(a.toBigInteger()).mod(a2.interface));
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.k;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.interface, fp.k.subtract(a.toBigInteger()).mod(a2.interface));
        }

        @Override
        public String getFieldName() {
            return ECUtil.double("3\u001b");
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.interface.bitLength();
        }
    }
}

