/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1ParsingException;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.jce.provider.asymmetric.ec.ECUtil;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.AUX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.Aux;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.auX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.cON;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nuL;
import com.jxdinfo.hussar.core.exception.HussarCoreExceptionHandler;
import com.jxdinfo.hussar.core.exception.InvalidKaptchaException;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    ECCurve B;
    protected Aux preCompInfo;
    protected cON multiplier;
    protected boolean withCompression;
    ECFieldElement j;
    ECFieldElement m;
    private static X9IntegerConverter finally = new X9IntegerConverter();

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.m.equals(((ECPoint)a).m) && a2.j.equals(((ECPoint)a).j);
    }

    public ECFieldElement getX() {
        ECPoint a;
        return a.m;
    }

    void true(Aux a) {
        a.preCompInfo = a;
    }

    public abstract byte[] getEncoded();

    public boolean isInfinity() {
        ECPoint a;
        return a.m == null && a.j == null;
    }

    synchronized void static() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new auX();
        }
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public abstract ECPoint twice();

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint negate();

    public ECFieldElement getY() {
        ECPoint a;
        return a.j;
    }

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.B = a;
        eCPoint.m = a2;
        eCPoint.j = a3;
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(HussarCoreExceptionHandler.finally("Z3m}(eB\u000fA\rW\u0007g0v8wp|+h=q?'0zjl2|/s;d\""));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.B.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.static();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.false(eCPoint2, a, eCPoint2.preCompInfo);
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.m.hashCode() ^ a.j.hashCode();
    }

    public abstract ECPoint add(ECPoint var1);

    public ECCurve getCurve() {
        ECPoint a;
        return a.B;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.B, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.throw(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.m.toBigInteger().signum() == 0) {
                return a.B.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.m.add(f2m.j.divide(a.m));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.B.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.B.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.m.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.B, f2m3, eCFieldElement, a.withCompression);
        }

        private static /* synthetic */ void throw(ECPoint a, ECPoint a2) {
            if (!a.B.equals(a2.B)) {
                throw new IllegalArgumentException(ASN1ParsingException.for(")-\u0012\"W\"Sp\u0011.\u0000v\t-Z+T|W!\u00109Y94\u0007#\u0002'G\u001e9\u0015~\u001e<F\"Rw1\u0015\u0000j\rz\u00156\u0018+\u0012$\u001e,\u0000$"));
            }
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.m.equals(f2m)) {
                if (a2.j.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.B.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.j.add((ECFieldElement)object).divide(a2.m.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.m).add(f2m).add(a2.B.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.m.add(f2m)).add(f2m).add(a2.j);
            return new F2m(a2.B, f2m, (ECFieldElement)object, a2.withCompression);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(InvalidKaptchaException.true("k?\u0004gRdS=PoFg\nj\u000e~@\"EJgOd];cHeObKiLm\u0006\\-5\fhJ"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.m, f2m.j);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.m, f2m2.B.getA());
                }
            }
            a5.withCompression = a4;
        }

        @Override
        synchronized void static() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.B).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new nuL();
                    return;
                }
                a.multiplier = new AUX();
            }
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.throw(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = finally.getByteLength(a.m);
            byte[] byArray = finally.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = finally.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.j.toBigInteger().signum() == 0) {
                return a.B.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.B.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.B.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.m.square().multiply(eCFieldElement2).add(a.B.m).divide(a.j.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.m.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.m.subtract(eCFieldElement2)).subtract(a.j);
            return new Fp(a.B, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.B, fp.m, a.j.negate(), a.withCompression);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        @Override
        synchronized void static() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new AUX();
            }
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(ECUtil.class("$\f\t\\W\u0010\u0019P\u0003\u000b\u001cY\nY\u0003\u0000\u0000\u0017NYJ1$6n$1\u001b\u000f\u001d\n\u000b\u0010E\u0010F\t9>\r\u0011"));
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }

        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = finally.getByteLength(a.m);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = finally.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = finally.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = finally.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.m.equals(a.m)) {
                if (a2.j.equals(a.j)) {
                    return a2.twice();
                }
                return a2.B.getInfinity();
            }
            ECFieldElement eCFieldElement = a.j.subtract(a2.j).divide(a.m.subtract(a2.m));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.m).subtract(a.m);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.m.subtract(eCFieldElement2)).subtract(a2.j);
            return new Fp(a2.B, eCFieldElement2, eCFieldElement3);
        }
    }
}

