/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.banner.EmbeddedContainerUtils;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9ECParametersHolder;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.COn;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.util.CookieUtils;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract String getFieldName();

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement sqrt();

    public abstract int getFieldSize();

    public abstract ECFieldElement negate();

    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement square();

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement invert();

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        public static final int TPB = 2;
        private int i;
        private int b;
        private int A;
        public static final int PPB = 3;
        private int B;
        public static final int GNB = 1;
        private int j;
        private int m;
        private COn class;

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.i == f2m.i && a2.m == f2m.m && a2.j == f2m.j && a2.B == f2m.B && a2.b == f2m.b && a2.class.equals(f2m.class);
        }

        @Override
        public String getFieldName() {
            return X9ECParametersHolder.instanceof("#1\u0000");
        }

        public int getRepresentation() {
            F2m a;
            return a.b;
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            COn cOn2 = (COn)a.class.clone();
            COn cOn3 = new COn(a.A);
            F2m f2m = a;
            COn cOn4 = cOn3;
            cOn4.break(a.i);
            cOn4.break(0);
            cOn3.break(f2m.m);
            if (f2m.b == 3) {
                COn cOn5 = cOn3;
                cOn5.break(a.j);
                cOn5.break(a.B);
            }
            COn cOn6 = new COn(a.A);
            cOn6.break(0);
            COn cOn7 = new COn(a.A);
            COn cOn8 = cOn2;
            while (!cOn8.true()) {
                int n = cOn2.synchronized() - cOn3.synchronized();
                if (n < 0) {
                    COn cOn9 = cOn2;
                    cOn2 = cOn3;
                    cOn3 = cOn9;
                    COn cOn10 = cOn6;
                    cOn6 = cOn7;
                    cOn7 = cOn10;
                    n = -n;
                }
                int n2 = n >> 5;
                COn cOn11 = cOn3.true(n &= 0x1F);
                COn cOn12 = cOn2;
                cOn8 = cOn12;
                cOn12.short(cOn11, n2);
                COn cOn13 = cOn7.true(n);
                cOn6.short(cOn13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.i, f2m2.m, f2m3.j, f2m3.B, cOn7);
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        public int getK1() {
            F2m a;
            return a.m;
        }

        public int getK2() {
            F2m a;
            return a.j;
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(CookieUtils.implements("\u001aD!H)Oc@ M,[(Z`\u000etAmL$\u001b&f\u0002v\u0003'\u0007F2P,C'@?$\u0002Kda\u000ej,A!K\u0003Y9\bii\u001a]\\\u001e("));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.i != f2m2.i || f2m.m != f2m2.m || f2m.j != f2m2.j || f2m.B != f2m2.B) {
                throw new IllegalArgumentException(X9ECParametersHolder.instanceof("+b\u0000o\t(\u0003~\u0019/IN:'\u001aj\u0017`K`\u000fwM`\u0007h\u000eE {\u0012#\u0002lDv\u0004Fmy\u0005n\b+\u0003j\bd\u00022:'\u0016"));
            }
            if (f2m.b != f2m2.b) {
                throw new IllegalArgumentException(CookieUtils.implements("\tL.\u0018>DkT!W{S5H(@m\njI(E'A/\t!\u001dc\u0004#M?Och\bo\u000ei\u001a[aL,^dL\"g\u0002_6A.XeV(_4P/\u0000bs\u000f\u0007sC+"));
            }
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            COn cOn2 = f2m.class.new(f2m.i);
            int[] nArray = new int[3];
            nArray[0] = a.m;
            nArray[1] = a.j;
            nArray[2] = a.B;
            cOn2.for(a.i, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.i, f2m2.m, f2m3.j, f2m3.B, cOn2);
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(X9ECParametersHolder.instanceof("bO:tSf\u0015y\u001ez\u001cz\u000ew\u0018"));
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.class.char();
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, COn a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.A = a + 31 >> 5;
            f2m3.class = a5;
            f2m2.i = a;
            f2m2.m = a2;
            f2m.j = a3;
            f2m.B = a4;
            if (a3 == 0 && a4 == 0) {
                a6.b = 2;
                return;
            }
            a6.b = 3;
        }

        public int getM() {
            F2m a;
            return a.i;
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.A = a + 31 >> 5;
            F2m f2m = a6;
            a6.class = new COn(a5, a6.A);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.b = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(CookieUtils.implements("Fv\u0005!q\u001eYdF(\f6I,C*P.Exo\u000f\u001d:Gv"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(X9ECParametersHolder.instanceof("cT2\u00117_Tn6_+\t;Fh\u0004zF{\ts\u0012x\u0006"));
                }
                a6.b = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(CookieUtils.implements("UdS-h\u0018HdG,B+K9\u000f$P|\u000bi`\u000f\u0007sZ "));
            }
            F2m f2m2 = a6;
            a6.i = a;
            f2m2.m = a2;
            f2m2.j = a3;
            a6.B = a4;
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            COn cOn2 = (COn)a2.class.clone();
            F2m f2m = (F2m)a;
            cOn2.short(f2m.class, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.i, f2m2.m, f2m3.j, f2m3.B, cOn2);
        }

        public int hashCode() {
            F2m a;
            return a.class.hashCode() ^ a.i ^ a.m ^ a.j ^ a.B;
        }

        public int getK3() {
            F2m a;
            return a.B;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.class.switch(((F2m)object).class, a2.i);
            int[] nArray = new int[3];
            nArray[0] = a2.m;
            nArray[1] = a2.j;
            nArray[2] = a2.B;
            ((COn)object).for(a2.i, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.i, f2m.m, f2m2.j, f2m2.B, (COn)object);
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.i;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger m;
        BigInteger void;

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.m.testBit(0)) {
                throw new RuntimeException(LicenseInfo.byte("L\t`ps<{46+u "));
            }
            if (a.m.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.m, fp.void.modPow(a.m.shiftRight(2).add(ECConstants.ONE), a.m));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.m.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.void.modPow(bigInteger2, a.m).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.void;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.m);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.m.bitLength(), random)).compareTo(a.m) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.m).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.strictfp(a.m, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.m).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.m);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.m, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.m, fp.void.multiply(a.void).mod(a.m));
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.m.bitLength();
        }

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.m, fp.void.modInverse(a.m));
        }

        private static /* synthetic */ BigInteger[] strictfp(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.m.equals(fp.m) && a2.void.equals(fp.void);
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.m, fp.void.add(a.toBigInteger()).mod(a2.m));
        }

        public int hashCode() {
            Fp a;
            return a.m.hashCode() ^ a.void.hashCode();
        }

        public BigInteger getQ() {
            Fp a;
            return a.m;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.m, fp.void.multiply(a.toBigInteger().modInverse(a2.m)).mod(a2.m));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.m, fp.void.multiply(a.toBigInteger()).mod(a2.m));
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.void;
        }

        @Override
        public String getFieldName() {
            return EmbeddedContainerUtils.long("\u001a\\");
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.m, fp.void.subtract(a.toBigInteger()).mod(a2.m));
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.void = a2;
            if (a3.void.compareTo(a) >= 0) {
                throw new IllegalArgumentException(LicenseInfo.byte("xdW\u0004d9de}\"nef/b3%$K\b461ya-*+a,}14j"));
            }
            a3.m = a;
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.m, fp.void.negate().mod(a.m));
        }
    }
}

