/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.Contact;
import com.jxdinfo.hussar.core.HussarCoreAutoConfiguration;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9ECParametersHolder;
import com.jxdinfo.hussar.core.bouncycastle.asn1.x9.X9IntegerConverter;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.CON;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECCurve;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECFieldElement;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.NuL;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.auX;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.con;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.nul;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ECPoint {
    private static X9IntegerConverter e = new X9IntegerConverter();
    protected CON multiplier;
    protected NuL preCompInfo;
    ECFieldElement f;
    protected boolean withCompression;
    ECCurve E;
    ECFieldElement enum;

    synchronized void continue() {
        ECPoint a;
        if (a.multiplier == null) {
            ECPoint eCPoint = a;
            eCPoint.multiplier = new con();
        }
    }

    public abstract ECPoint subtract(ECPoint var1);

    public boolean equals(Object a) {
        ECPoint a2;
        if (a == a2) {
            return true;
        }
        if (!(a instanceof ECPoint)) {
            return false;
        }
        a = (ECPoint)a;
        if (a2.isInfinity()) {
            return ((ECPoint)a).isInfinity();
        }
        return a2.f.equals(((ECPoint)a).f) && a2.enum.equals(((ECPoint)a).enum);
    }

    public ECCurve getCurve() {
        ECPoint a;
        return a.E;
    }

    void final(NuL a) {
        a.preCompInfo = a;
    }

    public ECFieldElement getX() {
        ECPoint a;
        return a.f;
    }

    public ECFieldElement getY() {
        ECPoint a;
        return a.enum;
    }

    public int hashCode() {
        ECPoint a;
        if (a.isInfinity()) {
            return 0;
        }
        return a.f.hashCode() ^ a.enum.hashCode();
    }

    public ECPoint multiply(BigInteger a) {
        ECPoint a2;
        if (a.signum() < 0) {
            throw new IllegalArgumentException(X9ECParametersHolder.byte("5^\r\u001fN\u0001\fC\u0005K\u0015G\u0006SW\u001b\u001a\u001f\rXM\u001a'kn{8*\fP\u0003R\u0017]\u000fK"));
        }
        if (a2.isInfinity()) {
            return a2;
        }
        if (a.signum() == 0) {
            return a2.E.getInfinity();
        }
        ECPoint eCPoint = a2;
        eCPoint.continue();
        ECPoint eCPoint2 = a2;
        return eCPoint.multiplier.static(eCPoint2, a, eCPoint2.preCompInfo);
    }

    public boolean isCompressed() {
        ECPoint a;
        return a.withCompression;
    }

    public abstract byte[] getEncoded();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint twice();

    public abstract ECPoint negate();

    protected ECPoint(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
        ECPoint a4;
        ECPoint eCPoint = a4;
        ECPoint eCPoint2 = a4;
        a4.multiplier = null;
        eCPoint2.preCompInfo = null;
        eCPoint2.E = a;
        eCPoint.f = a2;
        eCPoint.enum = a3;
    }

    public boolean isInfinity() {
        ECPoint a;
        return a.f == null && a.enum == null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECPoint {
        @Override
        public byte[] getEncoded() {
            F2m a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = e.getByteLength(a.f);
            byte[] byArray = e.integerToBytes(a.getX().toBigInteger(), n);
            if (a.withCompression) {
                byte[] byArray2 = new byte[n + 1];
                byArray2[0] = 2;
                if (!a.getX().toBigInteger().equals(ECConstants.ZERO) && a.getY().multiply(a.getX().invert()).toBigInteger().testBit(0)) {
                    byArray2[0] = 3;
                }
                System.arraycopy(byArray, 0, byArray2, 1, n);
                return byArray2;
            }
            byte[] byArray3 = e.integerToBytes(a.getY().toBigInteger(), n);
            int n2 = n;
            byte[] byArray4 = new byte[n2 + n2 + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, n);
            System.arraycopy(byArray3, 0, byArray4, n + 1, n);
            return byArray4;
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            F2m a4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.synchronized(f2m, a);
            return f2m.addSimple((F2m)a);
        }

        @Override
        public ECPoint twice() {
            F2m a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.f.toBigInteger().signum() == 0) {
                return a.E.getInfinity();
            }
            F2m f2m = a;
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.f.add(f2m.enum.divide(a.f));
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m2.square().add(f2m2).add(a.E.getA());
            F2m f2m4 = a;
            ECFieldElement eCFieldElement = f2m4.E.fromBigInteger(ECConstants.ONE);
            eCFieldElement = (ECFieldElement.F2m)f2m4.f.square().add(f2m3.multiply(f2m2.add(eCFieldElement)));
            return new F2m(a.E, f2m3, eCFieldElement, a.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            F2m a2;
            F2m f2m = a2;
            F2m.synchronized(f2m, a);
            return f2m.subtractSimple((F2m)a);
        }

        public F2m(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            F2m a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(ToolUtil.abstract("Sm<p/2o\u0015\u0012]\u001e\u0000\u0007ywm9{vb%1pR^'fx8)jm\">?jqj9\"j"));
            }
            if (a2 != null) {
                F2m f2m = a5;
                ECFieldElement.F2m.checkFieldElements(f2m.f, f2m.enum);
                if (a != null) {
                    F2m f2m2 = a5;
                    ECFieldElement.F2m.checkFieldElements(f2m2.f, f2m2.E.getA());
                }
            }
            a5.withCompression = a4;
        }

        private static /* synthetic */ void synchronized(ECPoint a, ECPoint a2) {
            if (!a.E.equals(a2.E)) {
                throw new IllegalArgumentException(HussarCoreAutoConfiguration.final("h\u0017Q\u001a\u0007\tJ\u0012Y\u001dCNG\u0018\u0001\u000b\u0002Q\t\u0004D\u0016UNO\u0007\u0018BD_D\u0018\u0004\u0014c:'8p.N\u0011\r\u001cXTC\u001b\u0002Jp=\u0015\\L\u0013"));
            }
        }

        @Override
        synchronized void continue() {
            F2m a;
            if (a.multiplier == null) {
                if (((ECCurve.F2m)a.E).isKoblitz()) {
                    F2m f2m = a;
                    f2m.multiplier = new nul();
                    return;
                }
                a.multiplier = new auX();
            }
        }

        public F2m addSimple(F2m a) {
            F2m a2;
            Object object = a;
            if (a2.isInfinity()) {
                return object;
            }
            if (((ECPoint)object).isInfinity()) {
                return a2;
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)((ECPoint)object).getX();
            object = (ECFieldElement.F2m)((ECPoint)object).getY();
            if (a2.f.equals(f2m)) {
                if (a2.enum.equals(object)) {
                    return (F2m)a2.twice();
                }
                return (F2m)a2.E.getInfinity();
            }
            object = (ECFieldElement.F2m)a2.enum.add((ECFieldElement)object).divide(a2.f.add(f2m));
            f2m = (ECFieldElement.F2m)((ECFieldElement.F2m)object).square().add((ECFieldElement)object).add(a2.f).add(f2m).add(a2.E.getA());
            object = (ECFieldElement.F2m)((ECFieldElement.F2m)object).multiply(a2.f.add(f2m)).add(f2m).add(a2.enum);
            return new F2m(a2.E, f2m, (ECFieldElement)object, a2.withCompression);
        }

        public F2m subtractSimple(F2m a) {
            F2m a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.addSimple((F2m)a.negate());
        }

        @Override
        public ECPoint negate() {
            F2m a;
            return new F2m(a.E, a.getX(), a.getY().add(a.getX()), a.withCompression);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECPoint {
        @Override
        public byte[] getEncoded() {
            Fp a;
            if (a.isInfinity()) {
                return new byte[1];
            }
            int n = e.getByteLength(a.f);
            if (a.withCompression) {
                int n2 = a.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = e.integerToBytes(a.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = e.integerToBytes(a.getX().toBigInteger(), n);
            byte[] byArray3 = e.integerToBytes(a.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        @Override
        public ECPoint add(ECPoint a) {
            Fp a2;
            if (a2.isInfinity()) {
                return a;
            }
            if (a.isInfinity()) {
                return a2;
            }
            if (a2.f.equals(a.f)) {
                if (a2.enum.equals(a.enum)) {
                    return a2.twice();
                }
                return a2.E.getInfinity();
            }
            ECFieldElement eCFieldElement = a.enum.subtract(a2.enum).divide(a.f.subtract(a2.f));
            ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(a2.f).subtract(a.f);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(a2.f.subtract(eCFieldElement2)).subtract(a2.enum);
            return new Fp(a2.E, eCFieldElement2, eCFieldElement3);
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3) {
            a4(a, a2, a3, false);
            Fp a4;
        }

        public Fp(ECCurve a, ECFieldElement a2, ECFieldElement a3, boolean a4) {
            Fp a5;
            ECFieldElement eCFieldElement = a2;
            super(a, eCFieldElement, a3);
            if (eCFieldElement != null && a3 == null || a2 == null && a3 != null) {
                throw new IllegalArgumentException(Contact.else("\u0003\u001aaJ?C4Bog\u000e/\u0002z^W)@gD)]6\f*o\u0004Y3\u0015|Q4\u0002)VgV/\u001e|"));
            }
            a5.withCompression = a4;
        }

        @Override
        public ECPoint subtract(ECPoint a) {
            Fp a2;
            if (a.isInfinity()) {
                return a2;
            }
            return a2.add(a.negate());
        }

        @Override
        public ECPoint twice() {
            Fp a;
            if (a.isInfinity()) {
                return a;
            }
            if (a.enum.toBigInteger().signum() == 0) {
                return a.E.getInfinity();
            }
            Fp fp = a;
            ECFieldElement eCFieldElement = fp.E.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = fp.E.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = fp.f.square().multiply(eCFieldElement2).add(a.E.instanceof).divide(a.enum.multiply(eCFieldElement));
            eCFieldElement2 = eCFieldElement3.square().subtract(a.f.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(a.f.subtract(eCFieldElement2)).subtract(a.enum);
            return new Fp(a.E, eCFieldElement2, eCFieldElement4, a.withCompression);
        }

        @Override
        synchronized void continue() {
            Fp a;
            if (a.multiplier == null) {
                Fp fp = a;
                fp.multiplier = new auX();
            }
        }

        @Override
        public ECPoint negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.E, fp.f, a.enum.negate(), a.withCompression);
        }
    }
}

