/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.math.ec;

import com.jxdinfo.hussar.core.bouncycastle.math.ec.Con;
import com.jxdinfo.hussar.core.bouncycastle.math.ec.ECConstants;
import com.jxdinfo.hussar.core.encrypt.file.exceptioin.FileEncryptException;
import com.jxdinfo.hussar.core.support.ClassKit;
import com.jxdinfo.hussar.core.support.ObjectKit;
import com.jxdinfo.hussar.core.support.WafKit;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public ECFieldElement() {
        ECFieldElement a;
    }

    public abstract int getFieldSize();

    public abstract String getFieldName();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement square();

    public abstract BigInteger toBigInteger();

    public abstract ECFieldElement divide(ECFieldElement var1);

    public String toString() {
        ECFieldElement a;
        return a.toBigInteger().toString(2);
    }

    public abstract ECFieldElement negate();

    public abstract ECFieldElement sqrt();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class F2m
    extends ECFieldElement {
        private Con b;
        private int M;
        private int c;
        private int e;
        public static final int TPB = 2;
        private int f;
        private int E;
        public static final int GNB = 1;
        private int goto;
        public static final int PPB = 3;

        @Override
        public ECFieldElement add(ECFieldElement a) {
            F2m a2;
            Con con2 = (Con)a2.b.clone();
            F2m f2m = (F2m)a;
            con2.super(f2m.b, 0);
            F2m f2m2 = a2;
            F2m f2m3 = a2;
            return new F2m(f2m2.E, f2m2.M, f2m3.e, f2m3.f, con2);
        }

        public boolean equals(Object a) {
            F2m a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)a;
            return a2.E == f2m.E && a2.M == f2m.M && a2.e == f2m.e && a2.f == f2m.f && a2.goto == f2m.goto && a2.b.equals(f2m.b);
        }

        private /* synthetic */ F2m(int a, int a2, int a3, int a4, Con a5) {
            F2m a6;
            F2m f2m = a6;
            F2m f2m2 = a6;
            F2m f2m3 = a6;
            f2m3.c = a + 31 >> 5;
            f2m3.b = a5;
            f2m2.E = a;
            f2m2.M = a2;
            f2m.e = a3;
            f2m.f = a4;
            if (a3 == 0 && a4 == 0) {
                a6.goto = 2;
                return;
            }
            a6.goto = 3;
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            F2m a2;
            Object object = (F2m)a;
            object = a2.b.import(((F2m)object).b, a2.E);
            int[] nArray = new int[3];
            nArray[0] = a2.M;
            nArray[1] = a2.e;
            nArray[2] = a2.f;
            ((Con)object).package(a2.E, nArray);
            F2m f2m = a2;
            F2m f2m2 = a2;
            return new F2m(f2m.E, f2m.M, f2m2.e, f2m2.f, (Con)object);
        }

        @Override
        public String getFieldName() {
            return ClassKit.finally("7\u000f\u0014");
        }

        public F2m(int a, int a2, int a3, int a4, BigInteger a5) {
            BigInteger bigInteger;
            F2m a6;
            a6.c = a + 31 >> 5;
            F2m f2m = a6;
            a6.b = new Con(a5, a6.c);
            if (a3 == 0 && a4 == 0) {
                bigInteger = a5;
                a6.goto = 2;
            } else {
                if (a3 >= a4) {
                    throw new IllegalArgumentException(FileEncryptException.public("R\f\u0012X]\\\f_xxN\u001a\\W\f\u000bP@\u0012A]SF\u000f\tV"));
                }
                if (a3 <= 0) {
                    throw new IllegalArgumentException(ClassKit.finally("]@\f\u0005\tKjz\bK\u0015\u001d\u0005RV\u0010DRE\u001dM\u0006F\u0012"));
                }
                a6.goto = 3;
                bigInteger = a5;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException(FileEncryptException.public("A\u001eDTDZ\u001d_y|\u0000\u0007^B@\u0005P\u0012\\PRS\\F\u0014\u0000"));
            }
            F2m f2m2 = a6;
            a6.E = a;
            f2m2.M = a2;
            f2m2.e = a3;
            a6.f = a4;
        }

        public int getM() {
            F2m a;
            return a.E;
        }

        @Override
        public ECFieldElement square() {
            F2m a;
            F2m f2m = a;
            Con con2 = f2m.b.this(f2m.E);
            int[] nArray = new int[3];
            nArray[0] = a.M;
            nArray[1] = a.e;
            nArray[2] = a.f;
            con2.package(a.E, nArray);
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.E, f2m2.M, f2m3.e, f2m3.f, con2);
        }

        public int getK1() {
            F2m a;
            return a.M;
        }

        @Override
        public BigInteger toBigInteger() {
            F2m a;
            return a.b.extends();
        }

        @Override
        public int getFieldSize() {
            F2m a;
            return a.E;
        }

        public int getRepresentation() {
            F2m a;
            return a.goto;
        }

        public int getK3() {
            F2m a;
            return a.f;
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            F2m a2;
            ECFieldElement eCFieldElement = a.invert();
            return a2.multiply(eCFieldElement);
        }

        public int getK2() {
            F2m a;
            return a.e;
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            F2m a2;
            return a2.add(a);
        }

        public F2m(int a, int a2, BigInteger a3) {
            a4(a, a2, 0, 0, a3);
            F2m a4;
        }

        public int hashCode() {
            F2m a;
            return a.b.hashCode() ^ a.E ^ a.M ^ a.e ^ a.f;
        }

        public static void checkFieldElements(ECFieldElement a, ECFieldElement a2) {
            if (!(a instanceof F2m) || !(a2 instanceof F2m)) {
                throw new IllegalArgumentException(FileEncryptException.public("yp{\\S\u0019[]ST[\\A[\u000f\u0019\r\u007f=\u0000\u0006E\u0016]W@[\u0019WQKCQt~PA\u0019QV\u0017}|_wU[]{]ST[\\A\u0006i\u001dE"));
            }
            F2m f2m = (F2m)a;
            F2m f2m2 = (F2m)a2;
            if (f2m.E != f2m2.E || f2m.M != f2m2.M || f2m.e != f2m2.e || f2m.f != f2m2.f) {
                throw new IllegalArgumentException(ClassKit.finally("?\\\u0014Q\u001d\u0016\u0017@\r\u0011]p.\u0019\u000eT\u0003^_^\u001bIY^\u0013V\u001a{4E\u0006\u001d\u0016RPH\u0010xyG\u0011P\u001c\u0015\u0017T\u001cZ\u0016\f.\u0019\u0002"));
            }
            if (f2m.goto != f2m2.goto) {
                throw new IllegalArgumentException(FileEncryptException.public("Qq}:rS\u0012MVU\u0017^V|rT\u0017\\RT[\\PFF\bN\n\u001a:s\u0001\u001d\u0011SS]YVWJL\u0018_Qi=\\\\ZQBE]\\m>BRILTE\\PFT\\F@F"));
            }
        }

        @Override
        public ECFieldElement sqrt() {
            throw new RuntimeException(ClassKit.finally("vq.JGX\u0001G\nD\bD\u001aI\f"));
        }

        @Override
        public ECFieldElement negate() {
            F2m a;
            return a;
        }

        @Override
        public ECFieldElement invert() {
            F2m a;
            Con con2 = (Con)a.b.clone();
            Con con3 = new Con(a.c);
            F2m f2m = a;
            Con con4 = con3;
            con4.assert(a.E);
            con4.assert(0);
            con3.assert(f2m.M);
            if (f2m.goto == 3) {
                Con con5 = con3;
                con5.assert(a.e);
                con5.assert(a.f);
            }
            Con con6 = new Con(a.c);
            con6.assert(0);
            Con con7 = new Con(a.c);
            Con con8 = con2;
            while (!con8.enum()) {
                int n = con2.assert() - con3.assert();
                if (n < 0) {
                    Con con9 = con2;
                    con2 = con3;
                    con3 = con9;
                    Con con10 = con6;
                    con6 = con7;
                    con7 = con10;
                    n = -n;
                }
                int n2 = n >> 5;
                Con con11 = con3.class(n &= 0x1F);
                Con con12 = con2;
                con8 = con12;
                con12.super(con11, n2);
                Con con13 = con7.class(n);
                con6.super(con13, n2);
            }
            F2m f2m2 = a;
            F2m f2m3 = a;
            return new F2m(f2m2.E, f2m2.M, f2m3.e, f2m3.f, con7);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Fp
    extends ECFieldElement {
        BigInteger E;
        BigInteger false;

        @Override
        public ECFieldElement invert() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.E, fp.false.modInverse(a.E));
        }

        @Override
        public ECFieldElement square() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.E, fp.false.multiply(a.false).mod(a.E));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.E, fp.false.multiply(a.toBigInteger()).mod(a2.E));
        }

        @Override
        public ECFieldElement subtract(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.E, fp.false.subtract(a.toBigInteger()).mod(a2.E));
        }

        @Override
        public ECFieldElement add(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.E, fp.false.add(a.toBigInteger()).mod(a2.E));
        }

        @Override
        public ECFieldElement divide(ECFieldElement a) {
            Fp a2;
            Fp fp = a2;
            return new Fp(fp.E, fp.false.multiply(a.toBigInteger().modInverse(a2.E)).mod(a2.E));
        }

        public BigInteger getQ() {
            Fp a;
            return a.E;
        }

        @Override
        public ECFieldElement negate() {
            Fp a;
            Fp fp = a;
            return new Fp(fp.E, fp.false.negate().mod(a.E));
        }

        @Override
        public String getFieldName() {
            return WafKit.do("a3");
        }

        public Fp(BigInteger a, BigInteger a2) {
            Fp a3;
            a3.false = a2;
            if (a3.false.compareTo(a) >= 0) {
                throw new IllegalArgumentException(ObjectKit.char("\b\b\u0000O\u001f^9$$g6!=h\u0002O<!9fxf9m7ga|},\u001eN+i"));
            }
            a3.E = a;
        }

        public int hashCode() {
            Fp a;
            return a.E.hashCode() ^ a.false.hashCode();
        }

        private static /* synthetic */ BigInteger[] transient(BigInteger a, BigInteger a2, BigInteger a3, BigInteger a4) {
            BigInteger bigInteger = a4;
            int n = bigInteger.bitLength();
            int n2 = bigInteger.getLowestSetBit();
            BigInteger bigInteger2 = ECConstants.ONE;
            BigInteger bigInteger3 = ECConstants.TWO;
            BigInteger bigInteger4 = a2;
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.ONE;
            int n3 = n = n - 1;
            while (n3 >= n2 + 1) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
                if (a4.testBit(n)) {
                    bigInteger6 = bigInteger5.multiply(a3).mod(a);
                    bigInteger2 = bigInteger2.multiply(bigInteger4).mod(a);
                    BigInteger bigInteger7 = bigInteger4;
                    bigInteger3 = bigInteger7.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    bigInteger4 = bigInteger7.multiply(bigInteger7).subtract(bigInteger6.shiftLeft(1)).mod(a);
                } else {
                    bigInteger6 = bigInteger5;
                    bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
                    bigInteger4 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger5)).mod(a);
                    BigInteger bigInteger8 = bigInteger3;
                    bigInteger3 = bigInteger8.multiply(bigInteger8).subtract(bigInteger5.shiftLeft(1)).mod(a);
                }
                n3 = --n;
            }
            bigInteger5 = bigInteger5.multiply(bigInteger6).mod(a);
            bigInteger6 = bigInteger5.multiply(a3).mod(a);
            bigInteger2 = bigInteger2.multiply(bigInteger3).subtract(bigInteger5).mod(a);
            BigInteger bigInteger9 = bigInteger5;
            bigInteger3 = bigInteger4.multiply(bigInteger3).subtract(a2.multiply(bigInteger9)).mod(a);
            bigInteger5 = bigInteger9.multiply(bigInteger6).mod(a);
            int n4 = n = 1;
            while (n4 <= n2) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod(a);
                BigInteger bigInteger10 = bigInteger3;
                bigInteger3 = bigInteger10.multiply(bigInteger10).subtract(bigInteger5.shiftLeft(1)).mod(a);
                BigInteger bigInteger11 = bigInteger5;
                bigInteger5 = bigInteger11.multiply(bigInteger11).mod(a);
                n4 = ++n;
            }
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = bigInteger2;
            bigIntegerArray[1] = bigInteger3;
            return bigIntegerArray;
        }

        public boolean equals(Object a) {
            Fp a2;
            if (a == a2) {
                return true;
            }
            if (!(a instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)a;
            return a2.E.equals(fp.E) && a2.false.equals(fp.false);
        }

        @Override
        public BigInteger toBigInteger() {
            Fp a;
            return a.false;
        }

        @Override
        public ECFieldElement sqrt() {
            Fp a;
            if (!a.E.testBit(0)) {
                throw new RuntimeException(ObjectKit.char(">g/#%v\u007f,SR i"));
            }
            if (a.E.testBit(1)) {
                Fp fp = a;
                Fp fp2 = new Fp(fp.E, fp.false.modPow(a.E.shiftRight(2).add(ECConstants.ONE), a.E));
                if (((ECFieldElement)fp2).square().equals(a)) {
                    return fp2;
                }
                return null;
            }
            Fp fp = a;
            BigInteger bigInteger = fp.E.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!fp.false.modPow(bigInteger2, a.E).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2).shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = a.false;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(a.E);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(a.E.bitLength(), random)).compareTo(a.E) >= 0) {
                    continue;
                }
                BigInteger bigInteger7 = bigInteger6;
                if (!bigInteger7.multiply(bigInteger7).subtract(bigInteger5).modPow(bigInteger2, a.E).equals(bigInteger)) continue;
                BigInteger[] bigIntegerArray = Fp.transient(a.E, bigInteger6, bigInteger4, bigInteger3);
                BigInteger bigInteger8 = bigIntegerArray[0];
                BigInteger bigInteger9 = bigIntegerArray[1];
                if (bigInteger9.multiply(bigInteger9).mod(a.E).equals(bigInteger5)) {
                    if (bigInteger9.testBit(0)) {
                        bigInteger9 = bigInteger9.add(a.E);
                    }
                    bigInteger9 = bigInteger9.shiftRight(1);
                    return new Fp(a.E, bigInteger9);
                }
                if (!bigInteger8.equals(ECConstants.ONE) && !bigInteger8.equals(bigInteger)) break;
            }
            return null;
        }

        @Override
        public int getFieldSize() {
            Fp a;
            return a.E.bitLength();
        }
    }
}

