/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.bouncycastle.asn1;

import com.jxdinfo.hussar.core.banner.EmbeddedContainerUtils;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Boolean;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1EncodableVector;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Enumerated;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Exception;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1GeneralizedTime;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1Integer;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1StreamParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.ASN1UTCTime;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERApplicationSpecificParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERConstructedOctetString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BEROctetStringParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERSequenceParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERSetParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.BERTaggedObjectParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.CON;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERApplicationSpecific;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERBMPString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERBitString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERExternal;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERExternalParser;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERGeneralString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERIA5String;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERNull;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERNumericString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERObject;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DEROctetString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERPrintableString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERT61String;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERTags;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERUTF8String;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERUniversalString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERUnknownTag;
import com.jxdinfo.hussar.core.bouncycastle.asn1.DERVisibleString;
import com.jxdinfo.hussar.core.bouncycastle.asn1.LazyDERSequence;
import com.jxdinfo.hussar.core.bouncycastle.asn1.cON;
import com.jxdinfo.hussar.core.bouncycastle.asn1.nuL;
import com.jxdinfo.hussar.core.bouncycastle.asn1.nul;
import com.jxdinfo.hussar.core.bouncycastle.util.io.Streams;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ASN1InputStream
extends FilterInputStream
implements DERTags {
    private final int E;
    private final boolean interface;

    /*
     * Enabled aggressive block sorting
     */
    static DERObject static(int a, byte[] a2) {
        switch (a) {
            case 3: {
                return DERBitString.throw(a2);
            }
            case 30: {
                return new DERBMPString(a2);
            }
            case 1: {
                return new ASN1Boolean(a2);
            }
            case 10: {
                return new ASN1Enumerated(a2);
            }
            case 24: {
                return new ASN1GeneralizedTime(a2);
            }
            case 27: {
                return new DERGeneralString(a2);
            }
            case 22: {
                return new DERIA5String(a2);
            }
            case 2: {
                return new ASN1Integer(a2);
            }
            case 5: {
                return DERNull.INSTANCE;
            }
            case 18: {
                return new DERNumericString(a2);
            }
            case 6: {
                return new ASN1ObjectIdentifier(a2);
            }
            case 4: {
                return new DEROctetString(a2);
            }
            case 19: {
                return new DERPrintableString(a2);
            }
            case 20: {
                return new DERT61String(a2);
            }
            case 28: {
                return new DERUniversalString(a2);
            }
            case 23: {
                return new ASN1UTCTime(a2);
            }
            case 12: {
                return new DERUTF8String(a2);
            }
            case 26: {
                return new DERVisibleString(a2);
            }
        }
        return new DERUnknownTag(false, a, a2);
    }

    protected DERObject buildObject(int a, int a2, int a32) throws IOException {
        ASN1InputStream a4;
        boolean bl = (a & 0x20) != 0;
        nuL a32 = new nuL(a4, a32);
        if ((a & 0x40) != 0) {
            return new DERApplicationSpecific(bl, a2, a32.public());
        }
        if ((a & 0x80) != 0) {
            return new ASN1StreamParser(a32).private(bl, a2);
        }
        if (bl) {
            switch (a2) {
                case 4: {
                    return new BERConstructedOctetString(a4.protected((nuL)a32).abstract);
                }
                case 16: {
                    while (false) {
                    }
                    if (a4.interface) {
                        return new LazyDERSequence(a32.public());
                    }
                    return nul.goto(a4.protected(a32));
                }
                case 17: {
                    return nul.abstract(a4.protected(a32), false);
                }
                case 8: {
                    return new DERExternal(a4.protected(a32));
                }
            }
            return new DERUnknownTag(true, a2, a32.public());
        }
        return ASN1InputStream.static(a2, a32.public());
    }

    public ASN1InputStream(InputStream a, int a2, boolean a3) {
        ASN1InputStream a4;
        ASN1InputStream aSN1InputStream = a4;
        super(a);
        aSN1InputStream.E = a2;
        aSN1InputStream.interface = a3;
    }

    public ASN1InputStream(byte[] a, boolean a2) {
        a3(new ByteArrayInputStream(a), a.length, a2);
        ASN1InputStream a3;
    }

    ASN1EncodableVector protected(nuL a) throws IOException {
        return new ASN1InputStream(a).false();
    }

    public DERObject readObject() throws IOException {
        ASN1InputStream a;
        int n = a.read();
        if (n <= 0) {
            if (n == 0) {
                throw new IOException(EmbeddedContainerUtils.extends("\u00137\u001cNfAgM|\"F[p}\u0014hA/AlMPamWv\u0005\u007fSd]\u007fH"));
            }
            return null;
        }
        int n2 = ASN1InputStream.implements(a, n);
        boolean bl = (n & 0x20) != 0;
        int n3 = a.readLength();
        if (n3 < 0) {
            if (!bl) {
                throw new IOException(LicenseInfo.import("+w>d5av*#ier=m`(pc\u0007^\fS\u0011Wn*\u001a\u0004=m%r'q,~E[,z+j=|2~>d"));
            }
            ASN1InputStream aSN1InputStream = a;
            cON cON2 = new cON(aSN1InputStream, aSN1InputStream.E);
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(cON2, a.E);
            if ((n & 0x40) != 0) {
                return new BERApplicationSpecificParser(n2, aSN1StreamParser).getLoadedObject();
            }
            if ((n & 0x80) != 0) {
                return new BERTaggedObjectParser(true, n2, aSN1StreamParser).getLoadedObject();
            }
            switch (n2) {
                case 4: {
                    return new BEROctetStringParser(aSN1StreamParser).getLoadedObject();
                }
                case 16: {
                    return new BERSequenceParser(aSN1StreamParser).getLoadedObject();
                }
                case 17: {
                    return new BERSetParser(aSN1StreamParser).getLoadedObject();
                }
                case 8: {
                    return new DERExternalParser(aSN1StreamParser).getLoadedObject();
                }
            }
            throw new IOException(EmbeddedContainerUtils.extends("CxOjVn(F|[K\u0019hEhG`W\u0004am@jP|FsD\u007f^"));
        }
        try {
            return a.buildObject(n, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception(LicenseInfo.import("@h.\rQ(w#yck6k\u0000_/9 z'm4x>d"), illegalArgumentException);
        }
    }

    public ASN1InputStream(InputStream a, int a2) {
        a3(a, a2, false);
        ASN1InputStream a3;
    }

    public ASN1InputStream(byte[] a) {
        a2(new ByteArrayInputStream(a), a.length);
        ASN1InputStream a2;
    }

    protected int readLength() throws IOException {
        ASN1InputStream a;
        ASN1InputStream aSN1InputStream = a;
        return ASN1InputStream.protected(aSN1InputStream, aSN1InputStream.E);
    }

    protected void readFully(byte[] a) throws IOException {
        ASN1InputStream a2;
        if (Streams.readFully(a2, a) != a.length) {
            throw new EOFException(LicenseInfo.import("FH\u001a8&\u0019O\nK\u0016Wb.\u001a@xj(=.q&}\t[bv\"?<j=i8t"));
        }
    }

    static int implements(InputStream a, int a2) throws IOException {
        if ((a2 &= 0x1F) == 31) {
            a2 = 0;
            int n = a.read();
            if ((n & 0x7F) == 0) {
                throw new IOException(EmbeddedContainerUtils.extends("`LiIgB-\u001cr\u0016wPk\\'\u000byT\u0016\u007fJrXu/\u0002\u001evp^o\u0007vCd\u0003JqnA`W2TyCt^"));
            }
            int n2 = n;
            while (n2 >= 0 && (n & 0x80) != 0) {
                a2 |= n & 0x7F;
                a2 <<= 7;
                n2 = a.read();
            }
            if (n < 0) {
                throw new EOFException(LicenseInfo.import("{7e':\u0010Q6gft-k+}\u0000\u001e6x#?%i;y>."));
            }
            a2 |= n & 0x7F;
        }
        return a2;
    }

    static int protected(InputStream a, int a2) throws IOException {
        int n = a.read();
        if (n < 0) {
            throw new EOFException(EmbeddedContainerUtils.extends("sYb$_v3\bZ>nQbI\"NfMCpk\u0003`]bWuB\u007f^"));
        }
        if (n == 128) {
            return -1;
        }
        if (n > 127) {
            int n2;
            int n3 = n & 0x7F;
            if (n3 > 4) {
                throw new IOException(new StringBuilder().insert(0, LicenseInfo.import("3i7\u001e\u0014Fi;\u000bLxn)o&86q\u0004Pb-d}*|2\u007fa ")).append(n3).toString());
            }
            n = 0;
            int n4 = n2 = 0;
            while (n4 < n3) {
                int n5 = a.read();
                if (n5 < 0) {
                    throw new EOFException(EmbeddedContainerUtils.extends("\u0003)x>\u007fVrIf\u0002qFE`jMb\u0005~WxQnR"));
                }
                n = (n << 8) + n5;
                n4 = ++n2;
            }
            if (n < 0) {
                throw new IOException(LicenseInfo.import("4c7l-ss9|c\u0004X\u0017[\u0019N'q_J=d'i*n'9\t[,~0wsn8y5d"));
            }
            if (n >= a2) {
                throw new IOException(EmbeddedContainerUtils.extends("X}@+\ffBa@9J2\u0014<\u0018[6\t$Vl2FQx9[hRlFp\u0003HamDqM2TyCt^"));
            }
        }
        return n;
    }

    ASN1EncodableVector false() throws IOException {
        DERObject dERObject;
        ASN1InputStream a;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1InputStream aSN1InputStream = a;
        while ((dERObject = aSN1InputStream.readObject()) != null) {
            aSN1InputStream = a;
            aSN1EncodableVector.add(dERObject);
        }
        return aSN1EncodableVector;
    }

    public ASN1InputStream(InputStream a) {
        ASN1InputStream a2;
        InputStream inputStream = a;
        a2(inputStream, ASN1InputStream.return(inputStream));
    }

    static int return(InputStream a) {
        if (a instanceof CON) {
            return ((CON)a).else();
        }
        if (a instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)a).available();
        }
        return Integer.MAX_VALUE;
    }
}

